package net.mt1006.mocap.utils;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import org.jetbrains.annotations.Nullable;

import java.net.URI;
import java.net.URISyntaxException;

public class Utils
{
	public static void exception(Exception exception, String str)
	{
		MocapMod.LOGGER.error(str);
		exception.printStackTrace();
	}

	public static void sendMessage(@Nullable class_1657 player, String component, Object... args)
	{
		if (player == null) { return; }
		player.method_7353(getTranslatableComponent(player, component, args), false);
	}

	public static void sendComponent(@Nullable class_1657 player, class_2561 component)
	{
		if (player == null) { return; }
		player.method_7353(component, false);
	}

	public static String stringFromComponent(String component, Object... args)
	{
		return class_2561.method_43469("mocap." + component, args).getString();
	}

	public static class_5250 getTranslatableComponent(@Nullable class_1297 entity, String component, Object... args)
	{
		String key = "mocap." + component;
		return supportsTranslatable(entity)
				? class_2561.method_43469(key, args)
				: class_2561.method_43470(class_2561.method_43469(key, args).getString());
	}

	public static class_5250 getSuggestCommandComponent(String toSuggest, class_5250 component)
	{
		return component.method_10862(class_2583.field_24360.method_10958(new class_2558.class_10610(toSuggest)));
	}

	public static class_5250 getOpenUrlComponent(String url, class_5250 component)
	{
		try { return component.method_10862(class_2583.field_24360.method_10958(new class_2558.class_10608(new URI(url)))); }
		catch (URISyntaxException e) { return component; }
	}

	public static class_2487 nbtFromString(String nbtString) throws CommandSyntaxException
	{
		return class_2522.method_67315(nbtString);
	}

	private static boolean supportsTranslatable(@Nullable class_1297 entity)
	{
		return entity instanceof class_3222 && PlayerConnectionEvent.players.contains((class_3222)entity);
	}
}
