/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.MocapModLoaderInterface;
import net.mt1006.mocap.command.commands.MocapCommand;
import net.mt1006.mocap.fabric.PacketHandler;
import net.mt1006.mocap.fabric.events.BlockInteractionFabricEvent;
import net.mt1006.mocap.fabric.events.ChatFabricEvent;
import net.mt1006.mocap.fabric.events.EntityFabricEvent;
import net.mt1006.mocap.fabric.events.LifecycleFabricEvent;
import net.mt1006.mocap.fabric.events.PlayerConnectionFabricEvent;
import net.mt1006.mocap.fabric.events.ServerTickFabricEvent;
import net.mt1006.mocap.network.MocapPacketC2S;
import net.mt1006.mocap.network.MocapPacketS2C;

public class MocapModFabric
implements ModInitializer,
MocapModLoaderInterface {
    private static final FabricLoader FABRIC_LOADER = FabricLoader.getInstance();
    public static final boolean isDedicatedServer = FABRIC_LOADER.getEnvironmentType() == EnvType.SERVER;

    public void onInitialize() {
        MocapMod.init(isDedicatedServer, this);
        PlayerBlockBreakEvents.BEFORE.register(BlockInteractionFabricEvent::onBlockBreak);
        UseBlockCallback.EVENT.register(BlockInteractionFabricEvent::onRightClickBlock);
        ServerLivingEntityEvents.AFTER_DAMAGE.register(EntityFabricEvent::onEntityHurt);
        ServerPlayerEvents.AFTER_RESPAWN.register(EntityFabricEvent::onPlayerRespawn);
        ServerTickEvents.END_SERVER_TICK.register(ServerTickFabricEvent::onEndTick);
        ServerLifecycleEvents.SERVER_STARTED.register(LifecycleFabricEvent::onServerStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(LifecycleFabricEvent::onServerStop);
        ServerPlayConnectionEvents.JOIN.register(PlayerConnectionFabricEvent::onPlayerJoin);
        ServerPlayConnectionEvents.DISCONNECT.register(PlayerConnectionFabricEvent::onPlayerLeave);
        ServerMessageEvents.CHAT_MESSAGE.register(ChatFabricEvent::onChatMessage);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> MocapCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess));
        PacketHandler.register();
        MocapMod.postInit();
    }

    @Override
    public String getLoaderName() {
        return "Fabric";
    }

    @Override
    public String getModVersion() {
        Optional modContainer = FABRIC_LOADER.getModContainer("mocap");
        return modContainer.isPresent() ? ((ModContainer)modContainer.get()).getMetadata().getVersion().getFriendlyString() : "[unknown]";
    }

    @Override
    public void sendPacketToClient(class_3222 player, MocapPacketS2C packet) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    @Override
    public void sendPacketToServer(MocapPacketC2S packet) {
        ClientPlayNetworking.send((class_8710)packet);
    }
}

