/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.api.impl.controller;

import java.util.List;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.mt1006.mocap.api.v1.controller.MocapController;
import net.mt1006.mocap.api.v1.controller.MocapPlaybackRoot;
import net.mt1006.mocap.api.v1.controller.config.MocapRecordingConfig;
import net.mt1006.mocap.api.v1.controller.playable.MocapActiveRecording;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.command.io.APICommandInfo;
import net.mt1006.mocap.mocap.playing.PlaybackManager;
import net.mt1006.mocap.mocap.playing.playable.ActiveRecording;
import net.mt1006.mocap.mocap.recording.RecordingManager;
import net.mt1006.mocap.mocap.recording.RecordingSource;
import net.mt1006.mocap.mocap.settings.SettingFields;
import net.mt1006.mocap.mocap.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class MocapControllerImpl
implements MocapController {
    private final CommandInfo commandInfo;
    private final RecordingSource recordingSource;

    public MocapControllerImpl(MinecraftServer server, String name) {
        this.commandInfo = new APICommandInfo(server, server.method_30002(), name);
        this.recordingSource = RecordingSource.forAPI(name);
    }

    @Override
    public CommandInfo getCommandInfo() {
        return this.commandInfo;
    }

    @Override
    public CommandInfo getCommandInfoForLevel(class_3218 level) {
        if (level == this.commandInfo.getLevel()) {
            return this.commandInfo;
        }
        return new APICommandInfo(level.method_8503(), level, this.commandInfo.getSourceName());
    }

    @Override
    @Nullable
    public MocapPlaybackRoot findPlayback(String id) {
        return PlaybackManager.findPlayback(this.commandInfo, id, null);
    }

    @Override
    public List<? extends MocapPlaybackRoot> getActivePlaybacks() {
        return List.copyOf(PlaybackManager.playbacks);
    }

    @Override
    @Nullable
    public MocapActiveRecording startRecording(class_3222 player) {
        return this.startRecording(player, MocapRecordingConfig.createFromSettings(), true);
    }

    @Override
    @Nullable
    public MocapActiveRecording startRecording(class_3222 player, MocapRecordingConfig config, boolean startInstantly) {
        return ActiveRecording.get(RecordingManager.start(player, this.recordingSource, config, null, startInstantly, false));
    }

    @Override
    @Nullable
    public String getSetting(String name) {
        SettingFields.Field<?> field = Settings.getField(name);
        return field != null ? field.valToString() : null;
    }

    @Override
    public boolean setSetting(String name, String val) {
        SettingFields.Field<?> field = Settings.getField(name);
        return field != null && field.setFromString(val);
    }

    @Override
    public boolean resetSetting(String name) {
        SettingFields.Field<?> field = Settings.getField(name);
        if (field != null) {
            field.reset();
        }
        return field != null;
    }
}

