/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.api.impl.extenstion;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.impl.extenstion.MocapExtensionImpl;
import net.mt1006.mocap.api.v1.extension.MocapExtension;
import net.mt1006.mocap.mocap.settings.RequiredExtensions;
import net.mt1006.mocap.mocap.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class Extensions {
    private static final int MAX_EXTENSION_COUNT = 256;
    private static final Map<String, MocapExtensionImpl> extensions = new HashMap<String, MocapExtensionImpl>();
    public static final byte FLAGS_IS_REQUIRED = 1;

    @Nullable
    public static MocapExtension registerExtension(String id, short version, boolean required) {
        if (extensions.containsKey(id)) {
            MocapMod.LOGGER.warn("Trying to register extension with specific id multiple times - \"{}\"!", (Object)id);
            return null;
        }
        if (extensions.size() == 256) {
            MocapMod.LOGGER.warn("Extension count limit reached! Rejecting extension - \"{}\"", (Object)id);
            return null;
        }
        MocapExtensionImpl extension = new MocapExtensionImpl(id, version, required);
        extensions.put(extension.getId(), extension);
        return extension;
    }

    @Nullable
    public static MocapExtension getExtension(String id, short minVersion) {
        MocapExtension extension = extensions.get(id);
        return extension == null || Math.abs(extension.getVersion()) < minVersion ? null : extension;
    }

    public static Collection<MocapExtensionImpl> getExtensions() {
        return extensions.values();
    }

    public static boolean isRequired(boolean isRequiredFlag) {
        return switch ((RequiredExtensions)((Object)Settings.REQUIRED_EXTENSIONS.val)) {
            default -> throw new MatchException(null, null);
            case RequiredExtensions.REQUIRE_ALL -> true;
            case RequiredExtensions.IGNORE_ALL -> false;
            case RequiredExtensions.LET_EXTENSION_DECIDE -> isRequiredFlag;
        };
    }
}

