/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.api.v1.modifiers;

import net.minecraft.class_1299;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.mt1006.mocap.api.v1.modifiers.MocapEntityFilter;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilter;

public class MocapEntityFilterBuilder {
    private final StringBuilder builder = new StringBuilder();

    public MocapEntityFilterBuilder includeEntity(class_2960 id) {
        this.builder.append(id.toString());
        return this;
    }

    public MocapEntityFilterBuilder excludeEntity(class_2960 id) {
        this.builder.append("-");
        return this.includeEntity(id);
    }

    public MocapEntityFilterBuilder includeEntity(class_1299<?> entityType) {
        return this.includeEntity(class_7923.field_41177.method_10221(entityType));
    }

    public MocapEntityFilterBuilder excludeEntity(class_1299<?> entityType) {
        return this.excludeEntity(class_7923.field_41177.method_10221(entityType));
    }

    public MocapEntityFilterBuilder includeAll() {
        this.builder.append("*");
        return this;
    }

    public MocapEntityFilterBuilder excludeAll() {
        this.builder.append("-*");
        return this;
    }

    public MocapEntityFilterBuilder includeNamespace(String namespace) {
        if (!class_2960.method_20209((String)namespace)) {
            throw new class_151("Invalid namespace!");
        }
        this.builder.append(namespace);
        this.builder.append(":*");
        return this;
    }

    public MocapEntityFilterBuilder excludeNamespace(String namespace) {
        this.builder.append("-");
        return this.includeNamespace(namespace);
    }

    public MocapEntityFilterBuilder includeTag(String tag) {
        this.builder.append("$");
        this.builder.append(tag);
        return this;
    }

    public MocapEntityFilterBuilder excludeTag(String tag) {
        this.builder.append("-");
        return this.includeTag(tag);
    }

    public MocapEntityFilterBuilder includeGroup(Group group) {
        this.builder.append("@");
        this.builder.append(group.name());
        this.builder.append(";");
        return this;
    }

    public MocapEntityFilterBuilder excludeGroup(Group group) {
        this.builder.append("-");
        return this.includeGroup(group);
    }

    public MocapEntityFilterBuilder appendFilter(String filter) {
        this.builder.append(filter);
        return this;
    }

    public MocapEntityFilter build() {
        if (this.builder.isEmpty()) {
            this.includeGroup(Group.NONE);
        }
        return EntityFilter.fromString(this.builder.toString());
    }

    public static enum Group {
        NONE,
        VEHICLES,
        PROJECTILES,
        ITEMS,
        MOBS,
        MINECARTS;

    }
}

