/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapEntityFilterBuilder;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.PlaybackManager;
import net.mt1006.mocap.mocap.playing.playable.SceneFile;
import net.mt1006.mocap.mocap.playing.playback.PlaybackRoot;
import net.mt1006.mocap.mocap.recording.RecordingManager;

public class CommandSuggestions {
    private static final int RECORDINGS = 1;
    private static final int SCENES = 2;
    private static final int CURRENTLY_RECORDED = 4;
    private static final int VIRTUAL = 8;
    private static final int PLAYABLE = 15;
    public static final Set<String> inputSet = new HashSet<String>();
    public static final Set<String> skinFileSet = new HashSet<String>();
    public static final Map<String, List<String>> sceneElementCache = new HashMap<String, List<String>>();

    private static CompletableFuture<Suggestions> inputSuggestions(SuggestionsBuilder builder, int suggestionFlags) {
        Object remaining = builder.getRemaining();
        if (suggestionFlags == 2 && !((String)remaining).startsWith(".")) {
            remaining = "." + (String)remaining;
        } else if (suggestionFlags == 4 && !((String)remaining).startsWith("-")) {
            remaining = "-" + (String)remaining;
        } else if (suggestionFlags == 8 && !((String)remaining).startsWith("+")) {
            remaining = "+" + (String)remaining;
        }
        for (String input : inputSet) {
            int type;
            if ((suggestionFlags & (type = (switch (input.charAt(0)) {
                case '.' -> 2;
                case '-' -> 4;
                case '+' -> 8;
                default -> 1;
            }))) == 0 || !input.startsWith((String)remaining)) continue;
            builder.suggest(input);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> recording(CommandContext<?> ctx, SuggestionsBuilder builder) {
        return CommandSuggestions.inputSuggestions(builder, 1);
    }

    public static CompletableFuture<Suggestions> scene(CommandContext<?> ctx, SuggestionsBuilder builder) {
        return CommandSuggestions.inputSuggestions(builder, 2);
    }

    public static CompletableFuture<Suggestions> currentlyRecorded(CommandContext<?> ctx, SuggestionsBuilder builder) {
        return CommandSuggestions.inputSuggestions(builder, 4);
    }

    public static CompletableFuture<Suggestions> playable(CommandContext<?> ctx, SuggestionsBuilder builder) {
        return CommandSuggestions.inputSuggestions(builder, 15);
    }

    public static CompletableFuture<Suggestions> playbackId(CommandContext<?> ctx, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        for (PlaybackRoot playback : PlaybackManager.playbacks) {
            String str = playback.getSuggestedId();
            if (!str.startsWith(remaining)) continue;
            builder.suggest(str);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> sceneElement(CommandContext<?> ctx, SuggestionsBuilder builder) {
        Object sceneName = StringArgumentType.getString(ctx, (String)"scene_name");
        if (((String)sceneName).isEmpty()) {
            return builder.buildFuture();
        }
        if (((String)sceneName).charAt(0) != '.') {
            sceneName = "." + (String)sceneName;
        }
        if (!inputSet.contains(sceneName)) {
            return builder.buildFuture();
        }
        List<String> elements = sceneElementCache.get(sceneName);
        if (elements == null) {
            SceneData sceneData = new SceneData();
            if (!sceneData.load(CommandOutput.LOGS, SceneFile.get(CommandOutput.LOGS, (String)sceneName))) {
                builder.buildFuture();
            }
            elements = sceneData.saveToSceneElementCache((String)sceneName);
        }
        if (elements == null) {
            return builder.buildFuture();
        }
        String remaining = builder.getRemaining();
        for (String str : elements) {
            if (!str.startsWith(remaining)) continue;
            builder.suggest(str);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> skinFile(CommandContext<?> ctx, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        for (String input : skinFileSet) {
            if (!input.startsWith(remaining)) continue;
            builder.suggest(input);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> entityFilter(CommandContext<?> ctx, SuggestionsBuilder builder) {
        int entryStart;
        String remaining = builder.getRemaining();
        String entry = remaining.substring(entryStart = remaining.lastIndexOf(59) + 1);
        boolean startsWithMinus = entry.startsWith("-");
        if (startsWithMinus) {
            entry = entry.substring(1);
            ++entryStart;
        }
        builder = builder.createOffset(builder.getStart() + entryStart);
        ArrayList<Object> list = new ArrayList<Object>();
        for (MocapEntityFilterBuilder.Group group : MocapEntityFilterBuilder.Group.values()) {
            list.add("@" + group.name().toLowerCase());
        }
        HashSet<String> namespaces = new HashSet<String>();
        for (class_2960 id : class_7923.field_41177.method_10235()) {
            list.add(id.toString());
            namespaces.add(id.method_12836());
        }
        namespaces.forEach(n -> list.add(n + ":*"));
        list.add("*");
        String withMcNamespace = "minecraft:" + entry;
        for (String string : list) {
            if (!string.startsWith(entry) && !string.startsWith(withMcNamespace)) continue;
            builder.suggest(string);
            if (!string.equals(entry)) continue;
            builder = builder.createOffset(builder.getStart() + string.length());
            builder.suggest(";");
            return builder.buildFuture();
        }
        if (entry.isEmpty()) {
            if (!startsWithMinus) {
                builder.suggest("-");
            }
            builder.suggest("$");
        }
        return builder.buildFuture();
    }

    public static void refresh() {
        CommandSuggestions.initInputSet();
        CommandSuggestions.initSkinSet();
    }

    public static void clearCache() {
        sceneElementCache.clear();
    }

    private static void initInputSet() {
        List<String> sceneList;
        inputSet.clear();
        List<String> recordingList = RecordingFiles.list();
        if (recordingList != null) {
            inputSet.addAll(recordingList);
        }
        if ((sceneList = SceneFiles.list()) != null) {
            inputSet.addAll(sceneList);
        }
        RecordingManager.allContexts().forEach(ctx -> inputSet.add(ctx.id.str));
    }

    private static void initSkinSet() {
        skinFileSet.clear();
        if (!Files.initialized) {
            return;
        }
        String[] skinList = Files.skinDirectory.list(Files::isSkinFile);
        String[] slimSkinList = Files.slimSkinDirectory.list(Files::isSkinFile);
        if (skinList != null) {
            for (String filename : skinList) {
                skinFileSet.add(filename.substring(0, filename.lastIndexOf(46)));
            }
        }
        if (slimSkinList != null) {
            for (String filename : slimSkinList) {
                skinFileSet.add("slim/" + filename.substring(0, filename.lastIndexOf(46)));
            }
        }
    }
}

