/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2212;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.io.FullCommandInfo;
import org.jetbrains.annotations.Nullable;

public class CommandUtils {
    public static ArgumentBuilder<class_2168, ?> playerNameArgument(Command<class_2168> command) {
        return class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).executes(command);
    }

    public static ArgumentBuilder<class_2168, ?> playerArguments(class_7157 buildContext, Command<class_2168> command) {
        return CommandUtils.withModelArguments(buildContext, CommandUtils.playerNameArgument(command), command, true);
    }

    public static ArgumentBuilder<class_2168, ?> withModelArguments(class_7157 buildContext, ArgumentBuilder<class_2168, ?> builder, Command<class_2168> command, boolean addPlayerAsEntity) {
        builder.then(class_2170.method_9247((String)"skin_from_player").then(class_2170.method_9244((String)"skin_player_name", (ArgumentType)StringArgumentType.greedyString()).executes(command)));
        builder.then(class_2170.method_9247((String)"skin_from_file").then(class_2170.method_9244((String)"skin_filename", (ArgumentType)StringArgumentType.greedyString()).suggests(CommandSuggestions::skinFile).executes(command)));
        builder.then(class_2170.method_9247((String)"skin_from_mineskin").then(class_2170.method_9244((String)"mineskin_url", (ArgumentType)StringArgumentType.greedyString()).executes(command)));
        if (addPlayerAsEntity) {
            builder.then(class_2170.method_9247((String)"player_as_entity").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_7733.method_45603((class_7157)buildContext, (class_5321)class_7924.field_41266)).executes(command)).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2212.method_9389()).executes(command))));
        }
        return builder;
    }

    public static ArgumentBuilder<class_2168, ?> withModifiers(class_7157 buildContext, ArgumentBuilder<class_2168, ?> builder, Command<class_2168> command, boolean isScene) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"time").then(class_2170.method_9247((String)"start_delay").then(class_2170.method_9244((String)"seconds", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(command)))).then(class_2170.method_9247((String)"wait_on_start").then(class_2170.method_9244((String)"seconds", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(command)))).then(class_2170.method_9247((String)"wait_on_end").then(class_2170.method_9244((String)"seconds", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(command)))).then(class_2170.method_9247((String)"wait_for_parent_end").then(class_2170.method_9244((String)"wait_for_parent_end", (ArgumentType)BoolArgumentType.bool()).executes(command)))).then(class_2170.method_9247((String)"loop").then(class_2170.method_9244((String)"loop", (ArgumentType)BoolArgumentType.bool()).executes(command))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"transformations").then(class_2170.method_9247((String)"rotation").then(class_2170.method_9244((String)"deg", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mirror").then(class_2170.method_9247((String)"none").executes(command))).then(class_2170.method_9247((String)"x").executes(command))).then(class_2170.method_9247((String)"z").executes(command))).then(class_2170.method_9247((String)"xz").executes(command)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"scale").then(class_2170.method_9247((String)"of_player").then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(command)))).then(class_2170.method_9247((String)"of_scene").then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(command))))).then(class_2170.method_9247((String)"offset").then(class_2170.method_9244((String)"offset_x", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"offset_y", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"offset_z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").then(class_2170.method_9247((String)"round_block_pos").then(class_2170.method_9244((String)"round", (ArgumentType)BoolArgumentType.bool()).executes(command)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"recording_center").then(class_2170.method_9247((String)"auto").executes(command))).then(class_2170.method_9247((String)"block_center").executes(command))).then(class_2170.method_9247((String)"block_corner").executes(command))).then(class_2170.method_9247((String)"actual").executes(command)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"scene_center").then(class_2170.method_9247((String)"common_first").executes(command))).then(class_2170.method_9247((String)"common_last").executes(command))).then(class_2170.method_9247((String)"common_specific").then(class_2170.method_9244((String)"specific_scene_element", (ArgumentType)StringArgumentType.string()).executes(command)))).then(class_2170.method_9247((String)"individual").executes(command)))).then(class_2170.method_9247((String)"center_offset").then(class_2170.method_9244((String)"offset_x", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"offset_y", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"offset_z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command)))))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"player_name").then(class_2170.method_9247((String)"inherited").executes(command))).then(class_2170.method_9247((String)"blank").executes(command))).then(class_2170.method_9247((String)"set").then(CommandUtils.playerNameArgument(command))));
        builder.then(CommandUtils.withModelArguments(buildContext, class_2170.method_9247((String)"player_skin"), command, false));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"player_as_entity").then(class_2170.method_9247((String)"disabled").executes(command))).then(class_2170.method_9247((String)"enabled").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_7733.method_45603((class_7157)buildContext, (class_5321)class_7924.field_41266)).executes(command)).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2212.method_9389()).executes(command)))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"entity_filter").then(class_2170.method_9247((String)"disabled").executes(command))).then(class_2170.method_9247((String)"enabled").then(class_2170.method_9244((String)"entity_filter", (ArgumentType)StringArgumentType.greedyString()).suggests(CommandSuggestions::entityFilter).executes(command))));
        if (isScene) {
            builder.then(class_2170.method_9247((String)"subscene_name").then(class_2170.method_9244((String)"new_name", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::playable).executes(command)));
        }
        return builder;
    }

    public static Command<class_2168> command(Function<FullCommandInfo, Boolean> function) {
        return ctx -> (Boolean)function.apply(new FullCommandInfo((CommandContext<class_2168>)ctx)) != false ? 1 : 0;
    }

    public static RequiredArgumentBuilder<class_2168, String> withStringArgument(BiFunction<FullCommandInfo, String, Boolean> function, String arg) {
        return (RequiredArgumentBuilder)class_2170.method_9244((String)arg, (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandUtils.stringCommand(function, (CommandContext<class_2168>)ctx, arg, false));
    }

    public static RequiredArgumentBuilder<class_2168, String> withInputArgument(BiFunction<FullCommandInfo, String, Boolean> function, SuggestionProvider<class_2168> suggestions, String arg) {
        return CommandUtils.withStringArgument(function, arg).suggests(suggestions);
    }

    public static RequiredArgumentBuilder<class_2168, String> withInputAndStringArgument(TriFunction<FullCommandInfo, String, String, Boolean> function, SuggestionProvider<class_2168> suggestions, String arg1, String arg2) {
        return (RequiredArgumentBuilder)class_2170.method_9244((String)arg1, (ArgumentType)StringArgumentType.string()).suggests(suggestions).then(class_2170.method_9244((String)arg2, (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandUtils.twoStringCommand(function, (CommandContext<class_2168>)ctx, arg1, arg2)));
    }

    public static RequiredArgumentBuilder<class_2168, String> withTwoInputArguments(TriFunction<FullCommandInfo, String, String, Boolean> function, SuggestionProvider<class_2168> suggestions1, SuggestionProvider<class_2168> suggestions2, String arg1, String arg2) {
        return (RequiredArgumentBuilder)class_2170.method_9244((String)arg1, (ArgumentType)StringArgumentType.string()).suggests(suggestions1).then(class_2170.method_9244((String)arg2, (ArgumentType)StringArgumentType.string()).suggests(suggestions2).executes(ctx -> CommandUtils.twoStringCommand(function, (CommandContext<class_2168>)ctx, arg1, arg2)));
    }

    private static int stringCommand(BiFunction<FullCommandInfo, String, Boolean> function, CommandContext<class_2168> ctx, String arg, boolean nullable) {
        FullCommandInfo info = new FullCommandInfo(ctx);
        try {
            String str = info.getString(arg);
            return function.apply(info, str) != false ? 1 : 0;
        }
        catch (IllegalArgumentException e) {
            if (nullable) {
                return function.apply(info, null) != false ? 1 : 0;
            }
            info.sendException(e, "error.unable_to_get_argument", new Object[0]);
            return 0;
        }
    }

    private static int twoStringCommand(TriFunction<FullCommandInfo, String, String, Boolean> function, CommandContext<class_2168> ctx, String arg1, String arg2) {
        FullCommandInfo info = new FullCommandInfo(ctx);
        try {
            String str1 = info.getString(arg1);
            String str2 = info.getString(arg2);
            return function.apply(info, str1, str2) != false ? 1 : 0;
        }
        catch (IllegalArgumentException e) {
            info.sendException(e, "error.unable_to_get_argument", new Object[0]);
            return 0;
        }
    }

    public static Pair<String, @Nullable String> splitIdStr(String str) {
        int dashPos = str.indexOf(45);
        int pos = Integer.parseInt(dashPos != -1 ? str.substring(0, dashPos) : str);
        String expectedName = dashPos != -1 ? str.substring(dashPos + 1) : null;
        return Pair.of((Object)Integer.toString(pos), (Object)expectedName);
    }

    public static Pair<Integer, @Nullable String> splitPosStr(String str) {
        int dashPos = str.indexOf(45);
        int pos = Integer.parseInt(dashPos != -1 ? str.substring(0, dashPos) : str);
        String expectedName = dashPos != -1 ? str.substring(dashPos + 1) : null;
        return Pair.of((Object)pos, (Object)expectedName);
    }

    @Nullable
    public static String getNode(List<? extends ParsedCommandNode<?>> nodes, int pos) {
        int size = nodes.size();
        if (pos < 0) {
            pos += size;
        }
        if (pos >= size || pos < 0) {
            return null;
        }
        return nodes.get(pos).getNode().getName();
    }

    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

