/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3222;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import org.jetbrains.annotations.Nullable;

public class CommandsContext {
    private static final Map<class_3222, CommandsContext> contexts = new HashMap<class_3222, CommandsContext>();
    public static int haveSyncEnabled = 0;
    public MocapModifiers modifiers = PlaybackModifiers.DEFAULT;
    private boolean sync = false;
    @Nullable
    public String doubleStart = null;

    public static CommandsContext get(class_3222 player) {
        CommandsContext ctx = contexts.get(player);
        if (ctx == null) {
            ctx = new CommandsContext();
            contexts.put(player, ctx);
        }
        return ctx;
    }

    public static void removePlayer(class_3222 player) {
        CommandsContext ctx = contexts.get(player);
        if (ctx == null) {
            return;
        }
        if (ctx.sync) {
            --haveSyncEnabled;
        }
        contexts.remove(player);
    }

    public static boolean hasDefaultModifiers(@Nullable class_3222 source) {
        return source == null || CommandsContext.get((class_3222)source).modifiers.areDefault();
    }

    public static MocapModifiers getFinalModifiers(@Nullable class_3222 source, MocapModifiers simpleModifiers) {
        PlaybackModifiers contextModifiers = source != null ? CommandsContext.get((class_3222)source).modifiers : PlaybackModifiers.DEFAULT;
        MocapModifiers modifiers = simpleModifiers.mergeWithParent(contextModifiers);
        return modifiers.withTransformations(contextModifiers.getTransformations());
    }

    public boolean setSync(boolean sync) {
        boolean oldSync = this.sync;
        this.sync = sync;
        if (oldSync != sync) {
            haveSyncEnabled = sync ? ++haveSyncEnabled : --haveSyncEnabled;
        }
        return oldSync;
    }

    public boolean getSync() {
        return this.sync;
    }
}

