/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.mt1006.mocap.api.impl.extenstion.Extensions;
import net.mt1006.mocap.api.impl.extenstion.MocapExtensionImpl;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.CommandsContext;
import net.mt1006.mocap.command.converter.AlphaConverter;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.playing.skins.CustomServerSkinManager;
import net.mt1006.mocap.network.MocapPacketS2C;

public class MiscCommand {
    public static LiteralArgumentBuilder<class_2168> getArgumentBuilder() {
        LiteralArgumentBuilder commandBuilder = class_2170.method_9247((String)"misc");
        commandBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"sync").then(class_2170.method_9247((String)"enable").executes(CommandUtils.command(MiscCommand::syncEnable)))).then(class_2170.method_9247((String)"disable").executes(CommandUtils.command(MiscCommand::syncDisable))));
        commandBuilder.then(class_2170.method_9247((String)"clear_cache").executes(CommandUtils.command(MiscCommand::clearCache)));
        commandBuilder.then(class_2170.method_9247((String)"refresh_suggestions").executes(CommandUtils.command(MiscCommand::refreshSuggestions)));
        commandBuilder.then(class_2170.method_9247((String)"extensions").executes(CommandUtils.command(MiscCommand::extensions)));
        commandBuilder.then(class_2170.method_9247((String)"convert").then(CommandUtils.withInputArgument(AlphaConverter::command, (SuggestionProvider<class_2168>)((SuggestionProvider)CommandSuggestions::recording), "name")));
        return commandBuilder;
    }

    private static boolean syncEnable(CommandInfo info) {
        if (info.getSourcePlayer() == null) {
            return info.sendFailure("failure.resolve_player", new Object[0]);
        }
        CommandsContext ctx = CommandsContext.get(info.getSourcePlayer());
        return info.sendSuccess(ctx.setSync(true) ? "misc.sync.enable.not_changed" : "misc.sync.enable.changed", new Object[0]);
    }

    private static boolean syncDisable(CommandInfo info) {
        if (info.getSourcePlayer() == null) {
            return info.sendFailure("failure.resolve_player", new Object[0]);
        }
        CommandsContext ctx = CommandsContext.get(info.getSourcePlayer());
        return info.sendSuccess(ctx.setSync(false) ? "misc.sync.disable.changed" : "misc.sync.disable.not_changed", new Object[0]);
    }

    private static boolean clearCache(CommandOutput out) {
        CommandSuggestions.clearCache();
        CustomServerSkinManager.clearCache();
        PlayerConnectionEvent.players.forEach(MocapPacketS2C::sendClearCache);
        return out.sendSuccess("misc.clear_cache.success", new Object[0]);
    }

    private static boolean refreshSuggestions(CommandOutput out) {
        CommandSuggestions.refresh();
        return out.sendSuccess("misc.refresh_suggestions.success", new Object[0]);
    }

    private static boolean extensions(CommandOutput out) {
        Collection<MocapExtensionImpl> extensions = Extensions.getExtensions();
        if (extensions.isEmpty()) {
            out.sendSuccess("misc.extensions.no_extensions", new Object[0]);
        } else {
            out.sendSuccess("misc.extensions.list", new Object[0]);
            for (MocapExtensionImpl ext : extensions) {
                short version = ext.getVersion();
                if (version >= 0) {
                    out.sendSuccess("misc.extensions.info", ext.getId(), version);
                    continue;
                }
                out.sendSuccess("misc.extensions.info.experimental", ext.getId(), -version);
            }
        }
        return true;
    }
}

