/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.io.FullCommandInfo;
import net.mt1006.mocap.mocap.recording.RecordingManager;
import net.mt1006.mocap.mocap.recording.RecordingSource;
import net.mt1006.mocap.mocap.settings.Settings;

public class RecordingCommand {
    private static final Command<class_2168> COMMAND_START = CommandUtils.command(RecordingCommand::start);

    public static LiteralArgumentBuilder<class_2168> getArgumentBuilder() {
        LiteralArgumentBuilder commandBuilder = class_2170.method_9247((String)"recording");
        commandBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"start").executes(COMMAND_START)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(COMMAND_START)).then(class_2170.method_9244((String)"instant_save", (ArgumentType)StringArgumentType.string()).executes(COMMAND_START))));
        commandBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").executes(CommandUtils.command(RecordingCommand::stop))).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::currentlyRecorded).executes(CommandUtils.command(RecordingCommand::stop))));
        commandBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"discard").executes(CommandUtils.command(RecordingCommand::discard))).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::currentlyRecorded).executes(CommandUtils.command(RecordingCommand::discard))));
        commandBuilder.then(class_2170.method_9247((String)"save").then(CommandUtils.withStringArgument(RecordingCommand::saveAuto, "name").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::currentlyRecorded).executes(CommandUtils.command(RecordingCommand::saveSpecific)))));
        commandBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(CommandUtils.command(RecordingCommand::list))).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(CommandSuggestions::currentlyRecorded).executes(CommandUtils.command(RecordingCommand::list))));
        return commandBuilder;
    }

    private static boolean start(FullCommandInfo info) {
        List<class_3222> players;
        String instantSave = null;
        try {
            players = class_2186.method_9310(info.ctx, (String)"player");
            if (players.isEmpty()) {
                return info.sendFailure("recording.start.player_not_found", new Object[0]);
            }
            instantSave = info.getNullableString("instant_save");
        }
        catch (Exception e) {
            class_1297 entity = info.getSourceEntity();
            if (!(entity instanceof class_3222)) {
                return info.sendFailure((Boolean)Settings.SHOW_TIPS.val != false ? "recording.start.player_not_specified.with_tip" : "recording.start.player_not_specified.no_tip", new Object[0]);
            }
            players = List.of((class_3222)entity);
        }
        RecordingSource source = RecordingSource.forCommand(info);
        int successes = 0;
        for (class_3222 player : players) {
            String instantSaveName = players.size() > 1 && instantSave != null ? instantSave + "_" + player.method_5477().getString() : instantSave;
            successes += RecordingManager.startOrWait(info, player, source, instantSaveName, players.size() > 1) != null ? 1 : 0;
        }
        if (players.size() > 1) {
            if (successes == players.size()) {
                info.sendSuccess("recording.start.multiple_started.success", new Object[0]);
            } else if (successes > 0) {
                info.sendFailure("recording.start.multiple_started.partial_success", new Object[0]);
            } else {
                info.sendFailure("recording.start.error", new Object[0]);
            }
        }
        return successes == players.size();
    }

    private static boolean stop(FullCommandInfo info) {
        return RecordingManager.stop(info, info.getNullableString("id"));
    }

    private static boolean discard(FullCommandInfo info) {
        return RecordingManager.discard(info, info.getNullableString("id"));
    }

    private static boolean saveAuto(FullCommandInfo info, String name) {
        return RecordingManager.save(info, null, name);
    }

    private static boolean saveSpecific(FullCommandInfo info) {
        String name = info.getNullableString("name");
        if (name == null) {
            return info.sendFailure("error.unable_to_get_argument", new Object[0]);
        }
        return RecordingManager.save(info, info.getNullableString("id"), name);
    }

    private static boolean list(FullCommandInfo info) {
        return RecordingManager.list(info, info.getNullableString("id"));
    }
}

