/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playable.RecordingFile;
import net.mt1006.mocap.utils.Utils;

public class RecordingsCommand {
    public static LiteralArgumentBuilder<class_2168> getArgumentBuilder() {
        LiteralArgumentBuilder commandBuilder = class_2170.method_9247((String)"recordings");
        commandBuilder.then(class_2170.method_9247((String)"copy").then(CommandUtils.withInputAndStringArgument(RecordingsCommand::copy, (SuggestionProvider<class_2168>)((SuggestionProvider)CommandSuggestions::recording), "src_name", "dest_name")));
        commandBuilder.then(class_2170.method_9247((String)"rename").then(CommandUtils.withInputAndStringArgument(RecordingsCommand::rename, (SuggestionProvider<class_2168>)((SuggestionProvider)CommandSuggestions::recording), "old_name", "new_name")));
        commandBuilder.then(class_2170.method_9247((String)"remove").then(CommandUtils.withInputArgument(RecordingsCommand::remove, (SuggestionProvider<class_2168>)((SuggestionProvider)CommandSuggestions::recording), "name")));
        commandBuilder.then(class_2170.method_9247((String)"info").then(CommandUtils.withInputArgument(RecordingsCommand::info, (SuggestionProvider<class_2168>)((SuggestionProvider)CommandSuggestions::recording), "name")));
        commandBuilder.then(class_2170.method_9247((String)"list").executes(CommandUtils.command(RecordingsCommand::list)));
        return commandBuilder;
    }

    public static boolean copy(CommandOutput out, String srcName, String destName) {
        RecordingFile srcFile = RecordingFile.get(out, srcName);
        RecordingFile destFile = RecordingFile.get(out, destName);
        if (srcFile == null || destFile == null) {
            return false;
        }
        return srcFile.copy(out, destFile) != null;
    }

    public static boolean rename(CommandOutput out, String srcName, String destName) {
        RecordingFile srcFile = RecordingFile.get(out, srcName);
        RecordingFile destFile = RecordingFile.get(out, destName);
        if (srcFile == null || destFile == null) {
            return false;
        }
        return srcFile.rename(out, destFile) != null;
    }

    public static boolean remove(CommandOutput out, String name) {
        RecordingFile file = RecordingFile.get(out, name);
        return file != null && file.remove(out);
    }

    public static boolean info(CommandInfo info, String name) {
        return RecordingFiles.info(info, RecordingFile.get((CommandOutput)info, name));
    }

    public static boolean list(CommandOutput out) {
        StringBuilder recordingsListStr = new StringBuilder();
        List<String> recordingsList = RecordingFiles.list();
        if (recordingsList == null) {
            recordingsListStr.append(" ").append(Utils.stringFromComponent("list.error", new Object[0]));
        } else if (!recordingsList.isEmpty()) {
            recordingsList.forEach(name -> recordingsListStr.append(" ").append((String)name));
        } else {
            recordingsListStr.append(" ").append(Utils.stringFromComponent("list.empty", new Object[0]));
        }
        return out.sendSuccess("recordings.list", new String(recordingsListStr));
    }
}

