/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.converter;

import net.minecraft.class_243;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.mocap.actions.Movement;
import net.mt1006.mocap.mocap.settings.Settings;

public class AlphaMovement {
    private static final byte Y_SHORT = 1;
    private static final byte Y_FLOAT = 2;
    private static final byte Y_DOUBLE = 3;
    private static final byte XZ_SHORT = 4;
    private static final byte XZ_FLOAT = 8;
    private static final byte XZ_DOUBLE = 12;
    private static final byte ROT_0 = 0;
    private static final byte ROT_HEAD_EQ = 32;
    private static final byte ROT_HEAD_DIFF = 48;
    private static final byte ON_GROUND = 64;
    private static final byte PACKED_Y = -128;
    private static final byte MASK_Y = 3;
    private static final byte MASK_XZ = 12;
    private static final byte MASK_ROT = 48;
    private static final double PACKED_Y_DIV = 4.0;
    private static final double PACKED_XZ_DIV = 2.0;
    private final byte flags;
    private final class_243 position;
    private final float[] rotation;
    private final float headRot;

    public AlphaMovement(MocapAction.Reader reader) {
        this.flags = reader.readByte();
        double y = switch (this.flags & 3) {
            case 1 -> {
                if ((this.flags & 0xFFFFFF80) != 0) {
                    yield AlphaMovement.unpackValue(reader.readShort(), 4.0);
                }
                yield (double)reader.readShort() / 2.0;
            }
            case 2 -> reader.readFloat();
            case 3 -> reader.readDouble();
            default -> 0.0;
        };
        double x = this.readXZ(reader);
        double z = this.readXZ(reader);
        this.position = new class_243(x, y, z);
        this.rotation = new float[2];
        if ((this.flags & 0x30) != 0) {
            this.rotation[0] = AlphaMovement.unpackRot(reader.readShort());
            this.rotation[1] = AlphaMovement.unpackRot(reader.readShort());
        }
        this.headRot = switch (this.flags & 0x30) {
            case 32 -> this.rotation[1];
            case 48 -> AlphaMovement.unpackRot(reader.readShort());
            default -> 0.0f;
        };
    }

    private double readXZ(MocapAction.Reader reader) {
        return switch (this.flags & 0xC) {
            case 4 -> AlphaMovement.unpackValue(reader.readShort(), 2.0);
            case 8 -> reader.readFloat();
            case 12 -> reader.readDouble();
            default -> 0.0;
        };
    }

    private static double unpackValue(short packed, double div) {
        return (double)packed / 32767.0 * div;
    }

    private static float unpackRot(short packed) {
        return (float)((double)packed / 65536.0 * 360.0);
    }

    private boolean isYRelative() {
        int yFlags = this.flags & 3;
        boolean yShortAbs = yFlags == 1 && (this.flags & 0xFFFFFF80) == 0;
        return yFlags != 3 && !yShortAbs;
    }

    private boolean isXzRelative() {
        int xzFlags = this.flags & 0xC;
        return xzFlags != 12;
    }

    public void applyToPosition(double[] currentPos) {
        boolean xzRel = this.isXzRelative();
        boolean yRel = this.isYRelative();
        currentPos[0] = xzRel ? currentPos[0] + this.position.field_1352 : this.position.field_1352;
        currentPos[1] = yRel ? currentPos[1] + this.position.field_1351 : this.position.field_1351;
        currentPos[2] = xzRel ? currentPos[2] + this.position.field_1350 : this.position.field_1350;
    }

    public Movement convert(class_243 startPos, double[] currentPos) {
        byte newFlags = 0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        class_243 oldPos = new class_243(currentPos[0], currentPos[1], currentPos[2]);
        this.applyToPosition(currentPos);
        class_243 newPos = new class_243(currentPos[0], currentPos[1], currentPos[2]);
        if (oldPos.field_1351 != newPos.field_1351) {
            double relNewY = newPos.field_1351 - startPos.field_1351;
            double newY2 = newPos.field_1351 * 2.0;
            if (newY2 == (double)((short)newY2)) {
                y = newPos.field_1351;
                newFlags = (byte)(newFlags | 3);
            } else if (Math.abs(relNewY) > (Double)Settings.MAX_FLOAT_POS_VALUE.val) {
                y = relNewY;
                newFlags = (byte)(newFlags | 2);
            } else if ((float)relNewY != (float)(oldPos.field_1351 - startPos.field_1351)) {
                y = relNewY;
                newFlags = (byte)(newFlags | 1);
            }
        }
        if (oldPos.field_1352 != newPos.field_1352 || oldPos.field_1350 != newPos.field_1350) {
            double relNewX = newPos.field_1352 - startPos.field_1352;
            double relNewZ = newPos.field_1350 - startPos.field_1350;
            if (Math.abs(relNewX) > (Double)Settings.MAX_FLOAT_POS_VALUE.val || Math.abs(relNewZ) > (Double)Settings.MAX_FLOAT_POS_VALUE.val) {
                x = relNewX;
                z = relNewZ;
                newFlags = (byte)(newFlags | 8);
            } else if ((float)relNewX != (float)(oldPos.field_1352 - startPos.field_1352) || (float)relNewZ != (float)(oldPos.field_1350 - startPos.field_1350)) {
                x = relNewX;
                z = relNewZ;
                newFlags = (byte)(newFlags | 4);
            }
        }
        newFlags = (byte)(newFlags | (byte)(this.flags & 0x30));
        newFlags = (byte)(newFlags | (byte)(this.flags & 0x40));
        return new Movement(newFlags, new class_243(x, y, z), this.rotation, this.headRot);
    }
}

