/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.command.io;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2212;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7733;
import net.minecraft.server.MinecraftServer;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerSkin;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerAsEntity;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerSkin;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class FullCommandInfo
implements CommandInfo {
    public final CommandContext<class_2168> ctx;
    public final class_2168 source;
    private final MinecraftServer server;
    private final class_3218 level;
    @Nullable
    private final class_3222 sourcePlayer;
    @Nullable
    private final class_1297 sourceEntity;

    public FullCommandInfo(CommandContext<class_2168> ctx) {
        this.ctx = ctx;
        this.source = (class_2168)ctx.getSource();
        this.server = this.source.method_9211();
        this.level = this.source.method_9225();
        this.sourcePlayer = this.source.method_44023();
        this.sourceEntity = this.source.method_9228();
    }

    @Override
    public boolean sendSuccess(String component, Object ... args) {
        this.source.method_9226(() -> this.getTranslatableComponent(component, args), false);
        return true;
    }

    @Override
    public boolean sendSuccessLiteral(String format, Object ... args) {
        this.source.method_9226(() -> class_2561.method_43470((String)String.format(format, args)), false);
        return true;
    }

    @Override
    public boolean sendSuccessComponent(class_2561 component) {
        this.source.method_9226(() -> component, false);
        return true;
    }

    @Override
    public boolean sendFailure(String component, Object ... args) {
        this.source.method_9213((class_2561)this.getTranslatableComponent(component, args));
        return false;
    }

    @Override
    public boolean sendFailureWithTip(String component, Object ... args) {
        this.source.method_9213((class_2561)this.getTranslatableComponent(component, args));
        if (((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
            this.source.method_9213((class_2561)this.getTranslatableComponent(component + ".tip", new Object[0]));
        }
        return false;
    }

    @Override
    public boolean sendException(Exception exception, String component, Object ... args) {
        this.sendFailure(component, args);
        Utils.exception(exception, Utils.stringFromComponent(component, args));
        return false;
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public class_3218 getLevel() {
        return this.level;
    }

    @Override
    @Nullable
    public class_3222 getSourcePlayer() {
        return this.sourcePlayer;
    }

    @Override
    @Nullable
    public class_1297 getSourceEntity() {
        return this.sourceEntity;
    }

    @Override
    public String getSourceName() {
        return this.sourcePlayer != null ? this.sourcePlayer.method_5477().getString() : "+mc";
    }

    @Nullable
    public FullCommandInfo getFinalCommandInfo() {
        CommandContext tempCtx = this.ctx;
        do {
            String command;
            if ((command = CommandUtils.getNode(tempCtx.getNodes(), 0)) == null || !command.equals("mocap") && !command.equals("mocap:mocap")) continue;
            return new FullCommandInfo((CommandContext<class_2168>)tempCtx);
        } while ((tempCtx = this.ctx.getChild()) != null);
        return null;
    }

    @Nullable
    public String getNode(int pos) {
        return CommandUtils.getNode(this.ctx.getNodes(), pos);
    }

    public int getInteger(String name) {
        return IntegerArgumentType.getInteger(this.ctx, (String)name);
    }

    public double getDouble(String name) {
        return DoubleArgumentType.getDouble(this.ctx, (String)name);
    }

    public boolean getBool(String name) {
        return BoolArgumentType.getBool(this.ctx, (String)name);
    }

    public String getString(String name) {
        return StringArgumentType.getString(this.ctx, (String)name);
    }

    @Nullable
    public String getNullableString(String name) {
        try {
            return StringArgumentType.getString(this.ctx, (String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public MocapPlayerSkin getPlayerSkin() {
        String fromPlayer = this.getNullableString("skin_player_name");
        if (fromPlayer != null) {
            return PlayerSkin.createVerified(this, MocapPlayerSkin.Source.FROM_PLAYER, fromPlayer);
        }
        String fromFile = this.getNullableString("skin_filename");
        if (fromFile != null) {
            return PlayerSkin.createVerified(this, MocapPlayerSkin.Source.FROM_FILE, fromFile);
        }
        String fromMineskin = this.getNullableString("mineskin_url");
        if (fromMineskin != null) {
            return PlayerSkin.createVerified(this, MocapPlayerSkin.Source.FROM_MINESKIN, fromMineskin);
        }
        return PlayerSkin.DEFAULT;
    }

    @Nullable
    public MocapModifiers getSimpleModifiers(CommandOutput out) {
        String playerName = this.getNullableString("player_name");
        if (!PlaybackModifiers.checkIfProperPlayerName(out, playerName)) {
            return null;
        }
        MocapPlayerSkin playerSkin = this.getPlayerSkin();
        if (playerSkin == null) {
            return null;
        }
        PlayerAsEntity playerAsEntity = PlayerAsEntity.DISABLED;
        try {
            class_2520 tag;
            String playerAsEntityId = class_7733.method_45609(this.ctx, (String)"entity").method_40237().method_29177().toString();
            try {
                tag = class_2212.method_9390(this.ctx, (String)"nbt");
            }
            catch (Exception e) {
                tag = null;
            }
            class_2487 nbt = tag instanceof class_2487 ? (class_2487)tag : null;
            playerAsEntity = new PlayerAsEntity(playerAsEntityId, nbt != null ? nbt.toString() : null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PlaybackModifiers.DEFAULT.withPlayerName(playerName).withPlayerSkin(playerSkin).withPlayerAsEntity(playerAsEntity);
    }
}

