/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.events;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.mt1006.mocap.command.CommandsContext;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketC2S;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class PlayerConnectionEvent {
    private static final int MAX_PLAYER_COUNT = 2048;
    private static final int MAX_NOCOL_PLAYER_COUNT = 4096;
    public static final Set<class_3222> players = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    public static final Set<UUID> nocolPlayers = Collections.synchronizedSet(new HashSet());

    public static void onPlayerJoin(MocapPacketC2S.Client client) {
        MocapPacketS2C.sendOnLogin(client);
    }

    public static void onPlayerLeave(class_3222 player) {
        players.remove(player);
        CommandsContext.removePlayer(player);
    }

    public static void addPlayer(@Nullable class_3222 player) {
        if (player == null || players.size() >= 2048) {
            return;
        }
        players.add(player);
        players.removeIf(class_1297::method_31481);
    }

    public static void addNocolPlayer(UUID uuid) {
        if (nocolPlayers.size() >= 4096) {
            return;
        }
        nocolPlayers.add(uuid);
    }

    public static void removeNocolPlayer(UUID uuid) {
        nocolPlayers.remove(uuid);
    }

    public static void experimentalReleaseWarning(class_3222 player) {
        if (!player.method_64475(2) || !((Boolean)Settings.EXPERIMENTAL_RELEASE_WARNING.val).booleanValue()) {
            return;
        }
        Utils.sendComponent((class_1657)player, (class_2561)Utils.getTranslatableComponent((class_1297)player, "warning.experimental", new Object[0]).method_10852((class_2561)Utils.getOpenUrlComponent("https://modrinth.com/mod/motion-capture/versions?c=release", Utils.getTranslatableComponent((class_1297)player, "warning.experimental.stable_download", new Object[0]))).method_10852((class_2561)Utils.getOpenUrlComponent("https://discord.gg/nzDETZhqur", class_2561.method_43470((String)"\u00a7n[Discord]\u00a7r "))).method_10852((class_2561)Utils.getOpenUrlComponent("https://github.com/mt1006/mc-mocap-mod", class_2561.method_43470((String)"\u00a7n[GitHub]\u00a7r "))).method_10852((class_2561)Utils.getSuggestCommandComponent("/mocap settings advanced experimental_release_warning false", Utils.getTranslatableComponent((class_1297)player, "warning.experimental.disable_message", new Object[0]))));
    }
}

