/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.mixin.fields.LivingEntityFields;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class ChangeItem
implements MocapStateAction {
    private static final int ITEM_COUNT_LEGACY = 6;
    private static final int ITEM_COUNT = 8;
    private final byte itemCount;
    private final List<ItemData> items = new ArrayList<ItemData>();

    @Nullable
    public static ChangeItem fromEntity(class_1297 entity) {
        ChangeItem changeItem;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            changeItem = new ChangeItem(livingEntity);
        } else {
            changeItem = null;
        }
        return changeItem;
    }

    private ChangeItem(class_1309 entity) {
        class_6903 ops = entity.method_56673().method_57093((DynamicOps)class_2509.field_11560);
        this.addItem(entity.method_6047(), (DynamicOps<class_2520>)ops);
        this.addItem(entity.method_6079(), (DynamicOps<class_2520>)ops);
        this.addItem(entity.method_6118(class_1304.field_6166), (DynamicOps<class_2520>)ops);
        this.addItem(entity.method_6118(class_1304.field_6172), (DynamicOps<class_2520>)ops);
        this.addItem(entity.method_6118(class_1304.field_6174), (DynamicOps<class_2520>)ops);
        this.addItem(entity.method_6118(class_1304.field_6169), (DynamicOps<class_2520>)ops);
        this.addItem(entity.method_6118(class_1304.field_48824), (DynamicOps<class_2520>)ops);
        this.addItem(entity.method_6118(class_1304.field_55946), (DynamicOps<class_2520>)ops);
        int itemCounter = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.items.get((int)i).type == ItemDataType.NO_ITEM) continue;
            itemCounter = i + 1;
        }
        this.itemCount = (byte)itemCounter;
    }

    public ChangeItem(MocapAction.Reader reader, MocapRecordingData data) {
        byte firstByte = reader.readByte();
        if (firstByte >= 0) {
            reader.shift(-1);
            this.itemCount = (byte)6;
        } else {
            this.itemCount = firstByte != -128 ? -firstByte : (byte)0;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            this.items.add(new ItemData(reader, data));
        }
    }

    private void addItem(@Nullable class_1799 itemStack, DynamicOps<class_2520> ops) {
        this.items.add(ItemData.get(itemStack, ops));
    }

    private void setEntityItems(class_1309 entity) {
        class_6903 ops = entity.method_56673().method_57093((DynamicOps)class_2509.field_11560);
        for (int i = 0; i < 8; ++i) {
            ItemData item = i < this.itemCount ? this.items.get(i) : ItemData.EMPTY;
            class_1799 itemStack = item.getItemStack((DynamicOps<class_2520>)ops);
            switch (i) {
                case 0: {
                    entity.method_5673(class_1304.field_6173, itemStack);
                    break;
                }
                case 1: {
                    entity.method_5673(class_1304.field_6171, itemStack);
                    break;
                }
                case 2: {
                    entity.method_5673(class_1304.field_6166, itemStack);
                    break;
                }
                case 3: {
                    entity.method_5673(class_1304.field_6172, itemStack);
                    break;
                }
                case 4: {
                    entity.method_5673(class_1304.field_6174, itemStack);
                    break;
                }
                case 5: {
                    entity.method_5673(class_1304.field_6169, itemStack);
                    break;
                }
                case 6: {
                    entity.method_5673(class_1304.field_48824, itemStack);
                    break;
                }
                case 7: {
                    entity.method_5673(class_1304.field_55946, itemStack);
                }
            }
            if (!(entity instanceof class_1657)) continue;
            ((LivingEntityFields)entity).callDetectEquipmentUpdates();
        }
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        if (this.itemCount != ((ChangeItem)previousAction).itemCount) {
            return true;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            ItemData item2;
            ItemData item1 = this.items.get(i);
            if (!item1.differs(item2 = ((ChangeItem)previousAction).items.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBeInitialized() {
        return this.itemCount != 0;
    }

    @Override
    public void prepareWrite(MocapRecordingData data) {
        if (this.itemCount > this.items.size()) {
            throw new RuntimeException();
        }
        for (int i = 0; i < this.itemCount; ++i) {
            this.items.get(i).prepareWrite(data);
        }
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addByte(this.itemCount > 0 ? (byte)(-this.itemCount) : (byte)-128);
        for (int i = 0; i < this.itemCount; ++i) {
            this.items.get(i).write(writer);
        }
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        class_1309 livingEntity = ctx.getLivingEntityOrDummyPlayer();
        if (livingEntity == null) {
            return MocapAction.Result.IGNORED;
        }
        this.setEntityItems(livingEntity);
        return MocapAction.Result.OK;
    }

    private static class ItemData {
        public static final ItemData EMPTY = new ItemData();
        public final ItemDataType type;
        public final class_1792 item;
        public final String data;
        private int idToWrite = -1;

        private ItemData() {
            this.type = ItemDataType.NO_ITEM;
            this.item = class_1802.field_8162;
            this.data = "";
        }

        private ItemData(class_1799 itemStack, DynamicOps<class_2520> ops) {
            class_2520 tag;
            this.item = itemStack.method_7909();
            try {
                tag = (class_2520)class_1799.field_24671.encodeStart(ops, (Object)itemStack).getOrThrow();
            }
            catch (Exception exception) {
                tag = null;
            }
            if (!(tag instanceof class_2487) || !((class_2487)tag).method_10545("components")) {
                this.type = ItemDataType.ID_ONLY;
                this.data = "";
                return;
            }
            class_2520 componentsTag = ((class_2487)tag).method_10580("components");
            if (!(componentsTag instanceof class_2487)) {
                this.type = ItemDataType.ID_ONLY;
                this.data = "";
                return;
            }
            this.type = ItemDataType.ID_AND_COMPONENTS;
            this.data = componentsTag.toString();
        }

        public ItemData(MocapAction.Reader reader, MocapRecordingData recordingData) {
            this.type = ItemDataType.get(reader.readByte());
            int itemId = this.type.hasId ? reader.readInt() : 0;
            String string = this.data = this.type.hasData ? reader.readString() : "";
            if (recordingData == null) {
                this.item = class_1802.field_8162;
                return;
            }
            this.item = recordingData.itemFromId(itemId);
        }

        public static ItemData get(@Nullable class_1799 itemStack, DynamicOps<class_2520> ops) {
            return itemStack == null || itemStack.method_7960() ? EMPTY : new ItemData(itemStack, ops);
        }

        public boolean differs(ItemData itemData) {
            return this.type != itemData.type || this.item != itemData.item || !this.data.equals(itemData.data);
        }

        public void prepareWrite(MocapRecordingData recordingData) {
            this.idToWrite = recordingData.provideItemId(this.item);
        }

        public void write(MocapAction.Writer writer) {
            if (this.idToWrite == -1) {
                throw new RuntimeException("ItemData write wasn't prepared!");
            }
            writer.addByte(this.type.id);
            if (this.type.hasId) {
                writer.addInt(this.idToWrite);
            }
            if (this.type.hasData) {
                writer.addString(this.data);
            }
        }

        public class_1799 getItemStack(DynamicOps<class_2520> ops) {
            switch (this.type.ordinal()) {
                case 0: {
                    return class_1799.field_8037;
                }
                case 1: 
                case 2: {
                    return new class_1799((class_1935)this.item);
                }
                case 3: {
                    class_2487 tag = this.tagFromIdAndComponents();
                    if (tag == null) {
                        return class_1799.field_8037;
                    }
                    try {
                        return (class_1799)class_1799.field_24671.parse(ops, (Object)tag).getOrThrow();
                    }
                    catch (Exception e) {
                        return class_1799.field_8037;
                    }
                }
            }
            return null;
        }

        @Nullable
        private class_2487 tagFromIdAndComponents() {
            class_2487 tag = new class_2487();
            try {
                tag.method_10566("components", (class_2520)Utils.nbtFromString(this.data));
            }
            catch (CommandSyntaxException e) {
                return null;
            }
            tag.method_10566("id", (class_2520)class_2519.method_23256((String)class_7923.field_41178.method_10221((Object)this.item).toString()));
            tag.method_10566("count", (class_2520)class_2497.method_23247((int)1));
            return tag;
        }
    }

    private static enum ItemDataType {
        NO_ITEM(0, false, false),
        ID_ONLY(1, true, false),
        ID_AND_NBT(2, true, true),
        ID_AND_COMPONENTS(3, true, true);

        private static final ItemDataType[] VALUES;
        public final byte id;
        public final boolean hasId;
        public final boolean hasData;

        private ItemDataType(int id, boolean hasId, boolean hasData) {
            this.id = (byte)id;
            this.hasId = hasId;
            this.hasData = hasData;
        }

        public static ItemDataType get(byte id) {
            if (id < 0 || id >= VALUES.length) {
                return NO_ITEM;
            }
            ItemDataType type = VALUES[id];
            if (type.id != id) {
                throw new RuntimeException("ChangeItem.ItemDataType VALUES out of order!");
            }
            return type;
        }

        static {
            VALUES = ItemDataType.values();
        }
    }
}

