/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7471;
import net.minecraft.class_8824;
import net.minecraft.server.MinecraftServer;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;

public class ChatMessage
implements MocapAction {
    private final String messageJson;

    public ChatMessage(class_2561 component) {
        String message;
        try {
            message = ((JsonElement)class_8824.field_46597.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)component).getOrThrow()).toString();
        }
        catch (IllegalStateException e) {
            message = "{}";
        }
        this.messageJson = message;
    }

    public ChatMessage(String messageJson) {
        this.messageJson = messageJson;
    }

    public ChatMessage(MocapAction.Reader reader) {
        reader.readByte();
        this.messageJson = reader.readString();
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addByte((byte)0);
        writer.addString(this.messageJson);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        UUID senderUUID;
        class_2561 message;
        if (!ctx.getConfig().getChatPlayback()) {
            return MocapAction.Result.IGNORED;
        }
        class_3222 player = ctx.getRealOrDummyPlayer();
        if (player == null) {
            return MocapAction.Result.IGNORED;
        }
        MinecraftServer server = ctx.getLevel().method_8503();
        try {
            message = (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse(this.messageJson)).getOrThrow()).getFirst();
        }
        catch (Exception e) {
            return MocapAction.Result.IGNORED;
        }
        if (message == null) {
            return MocapAction.Result.IGNORED;
        }
        if (player != ctx.getEntity()) {
            List playerList = ctx.getLevel().method_8503().method_3760().method_14571();
            if (playerList.isEmpty()) {
                return MocapAction.Result.IGNORED;
            }
            senderUUID = ((class_3222)playerList.get(0)).method_5667();
        } else {
            senderUUID = player.method_5667();
        }
        class_7471 chatMessage = class_7471.method_45098((UUID)senderUUID, (String)message.getString()).method_44863(message);
        server.method_3760().method_43673(chatMessage, player, class_2556.method_44832((class_5321)class_2556.field_11737, (class_1297)player));
        return MocapAction.Result.OK;
    }
}

