/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.command.converter.AlphaConverter;
import net.mt1006.mocap.mocap.actions.ActionType;
import net.mt1006.mocap.mocap.actions.DummyAction;
import org.jetbrains.annotations.Nullable;

public class EntityAction
implements MocapAction {
    private final int id;
    private final MocapAction action;

    public EntityAction(int id, MocapAction action) {
        this.id = id;
        this.action = action;
    }

    public EntityAction(MocapAction.Reader reader, MocapRecordingData data) {
        this(reader, data, null);
    }

    public EntityAction(MocapAction.Reader reader, MocapRecordingData data, @Nullable AlphaConverter converter) {
        this.id = reader.readInt();
        MocapAction action = ActionType.readAction(reader, data, converter, this.id);
        this.action = action != null ? action : DummyAction.INSTANCE;
    }

    @Override
    public void prepareWrite(MocapRecordingData data) {
        this.action.prepareWrite(data);
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addInt(this.id);
        ActionType.writeAction(writer, data, this.action);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        if (!ctx.setContextEntity(this.id)) {
            return MocapAction.Result.IGNORED;
        }
        MocapAction.Result retVal = this.action.execute(ctx);
        ctx.setMainContextEntity();
        return retVal;
    }
}

