/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.mt1006.mocap.api.v1.controller.config.MocapNbtRecordingMode;
import net.mt1006.mocap.api.v1.controller.config.MocapRecordingConfig;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.modifiers.MocapEntityFilter;
import net.mt1006.mocap.command.converter.AlphaConverter;
import net.mt1006.mocap.mixin.fields.EntityIdFields;
import net.mt1006.mocap.mocap.actions.Hurt;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class EntityUpdate
implements MocapAction {
    private final UpdateType type;
    private final int id;
    @Nullable
    private final String nbtString;
    @Nullable
    private final class_243 position;

    public static EntityUpdate addEntity(int id, class_1297 entity, MocapRecordingConfig config) {
        String nbtString = EntityUpdate.serializeEntityNBT(entity, config).toString();
        return new EntityUpdate(UpdateType.ADD, id, nbtString, entity.method_73189());
    }

    public static EntityUpdate removeEntity(int id) {
        return new EntityUpdate(UpdateType.REMOVE, id, null, null);
    }

    public static EntityUpdate kill(int id) {
        return new EntityUpdate(UpdateType.KILL, id, null, null);
    }

    public static EntityUpdate hurt(int id) {
        return new EntityUpdate(UpdateType.HURT, id, null, null);
    }

    public static EntityUpdate playerMount(int id) {
        return new EntityUpdate(UpdateType.PLAYER_MOUNT, id, null, null);
    }

    public static EntityUpdate playerDismount() {
        return new EntityUpdate(UpdateType.PLAYER_DISMOUNT, 0, null, null);
    }

    private EntityUpdate(UpdateType type, int id, @Nullable String nbtString, @Nullable class_243 position) {
        this.type = type;
        this.id = id;
        this.nbtString = nbtString;
        this.position = position;
    }

    public EntityUpdate(MocapAction.Reader reader) {
        this(reader, null, 0);
    }

    public EntityUpdate(MocapAction.Reader reader, @Nullable AlphaConverter converter, int dummy) {
        this.type = UpdateType.fromId(reader.readByte());
        this.id = reader.readInt();
        if (this.type == UpdateType.ADD) {
            this.nbtString = reader.readString();
            this.position = reader.readVec3();
            if (converter != null) {
                converter.posByEntity.put(this.id, new double[]{this.position.field_1352, this.position.field_1351, this.position.field_1350});
            }
        } else {
            this.nbtString = null;
            this.position = null;
        }
    }

    public static class_2487 serializeEntityNBT(class_1297 entity, MocapRecordingConfig config) {
        class_11362 tagOutput = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)entity.method_56673());
        String id = ((EntityIdFields)entity).callGetEncodeId();
        tagOutput.method_71469("id", id != null ? id : "minecraft:cow");
        if (config.getNbtRecordingMode() != MocapNbtRecordingMode.DISABLED) {
            entity.method_5647((class_11372)tagOutput);
        }
        class_2487 nbt = tagOutput.method_71475();
        nbt.method_10551("UUID");
        nbt.method_10551("Pos");
        nbt.method_10551("Motion");
        if (config.getNbtRecordingMode() == MocapNbtRecordingMode.FILTERED) {
            EntityUpdate.filterEntityNBT(nbt, entity);
        }
        return nbt;
    }

    public static void filterEntityNBT(class_2487 nbt, class_1297 entity) {
        nbt.method_10551("Brain");
        nbt.method_10551("EggLayTime");
        nbt.method_10551("CanPickUpLoot");
        nbt.method_10551("NoAI");
        nbt.method_10551("ForcedAge");
        nbt.method_10551("EggLayTime");
        nbt.method_10551("fall_distance");
        if (nbt.method_68565("HurtTime", (short)-1) == 0) {
            nbt.method_10551("HurtTime");
        }
        if (nbt.method_68565("DeathTime", (short)-1) == 0) {
            nbt.method_10551("DeathTime");
        }
        if (nbt.method_68083("HurtByTimestamp", -1) == 0) {
            nbt.method_10551("HurtByTimestamp");
        }
        if (nbt.method_68565("Air", (short)-1) == entity.method_5748()) {
            nbt.method_10551("Air");
        }
        if (nbt.method_66563("AbsorptionAmount", -1.0f) == 0.0f) {
            nbt.method_10551("AbsorptionAmount");
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (nbt.method_66563("Health", -1.0f) == living.method_6063()) {
                nbt.method_10551("Health");
            }
        }
        if (nbt.method_68083("Age", -1) >= 0) {
            nbt.method_10551("Age");
        } else {
            nbt.method_10569("Age", -9);
        }
        class_2499 listTag = nbt.method_10554("attributes").orElse(null);
        if (listTag != null) {
            class_2499 newListTag = new class_2499();
            for (class_2520 tag : listTag) {
                class_2960 attributeId;
                class_2487 attribute = tag.method_68571().orElse(null);
                String attributeIdStr = attribute != null ? (String)attribute.method_10558("id").orElse(null) : null;
                class_2960 class_29602 = attributeId = attributeIdStr != null ? class_2960.method_12829((String)attributeIdStr) : null;
                if (attributeId == null) {
                    newListTag.add((Object)tag);
                    continue;
                }
                if (class_5134.field_23717.method_40226(attributeId) || class_5134.field_23721.method_40226(attributeId) || class_5134.field_49077.method_40226(attributeId) || class_5134.field_49079.method_40226(attributeId)) continue;
                newListTag.add((Object)tag);
            }
            if (newListTag.isEmpty()) {
                nbt.method_10551("attributes");
            } else {
                nbt.method_10566("attributes", (class_2520)newListTag);
            }
        }
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addByte(this.type.id);
        writer.addInt(this.id);
        if (this.type == UpdateType.ADD) {
            writer.addString(this.nbtString != null ? this.nbtString : "");
            writer.addVec3(this.position != null ? this.position : class_243.field_1353);
        }
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        switch (this.type.ordinal()) {
            case 1: {
                return this.executeAdd(ctx);
            }
            case 6: {
                ctx.getEntity().method_5848();
                return MocapAction.Result.OK;
            }
            case 0: {
                return MocapAction.Result.IGNORED;
            }
        }
        MocapActionContext.EntityData entityData = ctx.getEntityData(this.id);
        if (entityData == null) {
            return MocapAction.Result.IGNORED;
        }
        class_1297 entity = entityData.entity;
        switch (this.type.ordinal()) {
            case 2: {
                entity.method_5650(class_1297.class_5529.field_26998);
                return MocapAction.Result.OK;
            }
            case 3: {
                entity.field_6008 = 0;
                entity.method_5768(ctx.getLevel());
                return MocapAction.Result.OK;
            }
            case 4: {
                Hurt.hurtEntity(entity, ctx.getConfig());
                return MocapAction.Result.OK;
            }
            case 5: {
                ctx.getEntity().method_5873(entity, true, true);
                return MocapAction.Result.OK;
            }
        }
        return MocapAction.Result.IGNORED;
    }

    private MocapAction.Result executeAdd(MocapActionContext ctx) {
        class_2487 compoundTag;
        MocapEntityFilter filter = ctx.getModifiers().getEntityFilter();
        if (this.nbtString == null || this.position == null || ctx.hasEntity(this.id) || filter.isEmpty()) {
            return MocapAction.Result.IGNORED;
        }
        try {
            compoundTag = Utils.nbtFromString(this.nbtString);
        }
        catch (Exception e) {
            Utils.exception(e, "Exception occurred when parsing entity NBT data!");
            return MocapAction.Result.ERROR;
        }
        class_11368 nbt = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)ctx.getEntity().method_56673(), (class_2487)compoundTag);
        class_1297 entity = class_1299.method_5892((class_11368)nbt, (class_1937)ctx.getLevel(), (class_3730)class_3730.field_16471).orElse(null);
        if (entity == null || !filter.isAllowed(entity)) {
            return MocapAction.Result.IGNORED;
        }
        entity.method_33574(ctx.getTransformer().transformPos(this.position));
        entity.method_18800(0.0, 0.0, 0.0);
        entity.method_5875(true);
        entity.method_5684(ctx.getConfig().getInvulnerablePlayback());
        entity.method_5780("mocap_entity");
        if (entity instanceof class_1308) {
            ((class_1308)entity).method_5977(true);
        }
        ctx.getModifiers().getTransformations().applyScaleToEntity(entity);
        ctx.getLevel().method_8649(entity);
        ctx.addEntity(this.id, entity, this.position);
        return MocapAction.Result.OK;
    }

    public static enum UpdateType {
        NONE(0),
        ADD(1),
        REMOVE(2),
        KILL(3),
        HURT(4),
        PLAYER_MOUNT(5),
        PLAYER_DISMOUNT(6);

        private static final UpdateType[] VALUES;
        private final byte id;

        private UpdateType(int id) {
            this.id = (byte)id;
        }

        private static UpdateType fromId(byte id) {
            for (UpdateType type : VALUES) {
                if (type.id != id) continue;
                return type;
            }
            return NONE;
        }

        static {
            VALUES = UpdateType.values();
        }
    }
}

