/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import java.util.Set;
import net.minecraft.class_10182;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2726;
import net.minecraft.class_2777;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.mocap.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class Movement
implements MocapAction {
    private static final byte Y_DELTA0 = 0;
    private static final byte Y_FLOAT = 1;
    private static final byte Y_DOUBLE = 2;
    private static final byte Y_SHORT = 3;
    private static final byte XZ_DELTA0 = 0;
    private static final byte XZ_FLOAT = 4;
    private static final byte XZ_DOUBLE = 8;
    private static final byte ROT_DELTA0 = 0;
    private static final byte ROT_HEAD_0 = 16;
    private static final byte ROT_HEAD_EQ = 32;
    private static final byte ROT_HEAD_DIFF = 48;
    private static final byte ON_GROUND = 64;
    private static final byte MASK_Y = 3;
    private static final byte MASK_XZ = 12;
    private static final byte MASK_ROT = 48;
    private final byte flags;
    private final class_243 position;
    private final float[] rotation;
    private final float headRot;

    public Movement(byte flags, class_243 position, float[] rotation, float headRot) {
        this.flags = flags;
        this.position = position;
        this.rotation = rotation;
        this.headRot = headRot;
    }

    public Movement(MocapAction.Reader reader) {
        this.flags = reader.readByte();
        double y = switch (this.flags & 3) {
            case 1 -> reader.readFloat();
            case 2 -> reader.readDouble();
            case 3 -> (double)reader.readShort() / 2.0;
            default -> 0.0;
        };
        double x = this.readXZ(reader);
        double z = this.readXZ(reader);
        this.position = new class_243(x, y, z);
        this.rotation = new float[2];
        if ((this.flags & 0x30) != 0) {
            this.rotation[0] = Movement.unpackRot(reader.readShort());
            this.rotation[1] = Movement.unpackRot(reader.readShort());
        }
        this.headRot = switch (this.flags & 0x30) {
            case 32 -> this.rotation[1];
            case 48 -> Movement.unpackRot(reader.readShort());
            default -> 0.0f;
        };
    }

    private double readXZ(MocapAction.Reader reader) {
        return switch (this.flags & 0xC) {
            case 4 -> reader.readFloat();
            case 8 -> reader.readDouble();
            default -> 0.0;
        };
    }

    @Nullable
    public static Movement delta(class_243 startPos, class_243 oldPos, class_243 newPos, float[] oldRot, float newRotX, float newRotY, float oldHeadRot, float newHeadRot, boolean oldOnGround, boolean newOnGround, boolean forceNonPosData) {
        byte flags = newOnGround ? (byte)64 : 0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float[] rotation = new float[2];
        float headRot = 0.0f;
        if (oldPos.field_1351 != newPos.field_1351) {
            double relNewY = newPos.field_1351 - startPos.field_1351;
            double newY2 = newPos.field_1351 * 2.0;
            if (newY2 == (double)((short)newY2)) {
                y = newPos.field_1351;
                flags = (byte)(flags | 3);
            } else if (Math.abs(relNewY) > (Double)Settings.MAX_FLOAT_POS_VALUE.val) {
                y = relNewY;
                flags = (byte)(flags | 2);
            } else if ((float)relNewY != (float)(oldPos.field_1351 - startPos.field_1351)) {
                y = relNewY;
                flags = (byte)(flags | 1);
            }
        }
        if (oldPos.field_1352 != newPos.field_1352 || oldPos.field_1350 != newPos.field_1350) {
            double relNewX = newPos.field_1352 - startPos.field_1352;
            double relNewZ = newPos.field_1350 - startPos.field_1350;
            if (Math.abs(relNewX) > (Double)Settings.MAX_FLOAT_POS_VALUE.val || Math.abs(relNewZ) > (Double)Settings.MAX_FLOAT_POS_VALUE.val) {
                x = relNewX;
                z = relNewZ;
                flags = (byte)(flags | 8);
            } else if ((float)relNewX != (float)(oldPos.field_1352 - startPos.field_1352) || (float)relNewZ != (float)(oldPos.field_1350 - startPos.field_1350)) {
                x = relNewX;
                z = relNewZ;
                flags = (byte)(flags | 4);
            }
        }
        if (newRotX - oldRot[0] != 0.0f || newRotY - oldRot[1] != 0.0f || newHeadRot - oldHeadRot != 0.0f || forceNonPosData) {
            rotation[0] = newRotX;
            rotation[1] = newRotY;
            if (newHeadRot == 0.0f) {
                flags = (byte)(flags | 0x10);
                headRot = 0.0f;
            } else if (newHeadRot == newRotY) {
                flags = (byte)(flags | 0x20);
                headRot = newRotY;
            } else {
                flags = (byte)(flags | 0x30);
                headRot = newHeadRot;
            }
        }
        return (flags & 0xFFFFFFBF) != 0 || oldOnGround != newOnGround || forceNonPosData ? new Movement(flags, new class_243(x, y, z), rotation, headRot) : null;
    }

    public static Movement teleportToPos(class_243 pos, boolean onGround) {
        byte flags = (byte)((onGround ? 64 : 0) | 2 | 8 | 0);
        float[] rotArray = new float[]{0.0f, 0.0f};
        return new Movement(flags, pos, rotArray, 0.0f);
    }

    private static short packRot(float rot) {
        return (short)((double)rot / 360.0 * 65536.0);
    }

    private static float unpackRot(short packed) {
        return (float)((double)packed / 65536.0 * 360.0);
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addByte(this.flags);
        switch (this.flags & 3) {
            case 1: {
                writer.addFloat((float)this.position.field_1351);
                break;
            }
            case 2: {
                writer.addDouble(this.position.field_1351);
                break;
            }
            case 3: {
                writer.addShort((short)(this.position.field_1351 * 2.0));
            }
        }
        this.writeXZ(writer, this.position.field_1352);
        this.writeXZ(writer, this.position.field_1350);
        if ((this.flags & 0x30) != 0) {
            writer.addShort(Movement.packRot(this.rotation[0]));
            writer.addShort(Movement.packRot(this.rotation[1]));
        }
        if ((this.flags & 0x30) == 48) {
            writer.addShort(Movement.packRot(this.headRot));
        }
    }

    private void writeXZ(MocapAction.Writer writer, double val) {
        switch (this.flags & 0xC) {
            case 4: {
                writer.addFloat((float)val);
                break;
            }
            case 8: {
                writer.addDouble(val);
            }
        }
    }

    public class_243 getNewPosition(class_243 startPos, class_243 oldPos) {
        boolean xzChanged = (this.flags & 0xC) != 0;
        int yFlags = this.flags & 3;
        boolean yRelative = yFlags != 0 && yFlags != 3;
        double absoluteY = yFlags == 3 ? this.position.field_1351 : oldPos.field_1351;
        double x = xzChanged ? startPos.field_1352 + this.position.field_1352 : oldPos.field_1352;
        double y = yRelative ? startPos.field_1351 + this.position.field_1351 : absoluteY;
        double z = xzChanged ? startPos.field_1350 + this.position.field_1350 : oldPos.field_1350;
        return new class_243(x, y, z);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        class_1297 entity = ctx.getEntity();
        boolean updateRot = (this.flags & 0x30) != 0;
        float rotX = updateRot ? this.rotation[0] : entity.method_36455();
        float rotY = updateRot ? this.rotation[1] : entity.method_36454();
        float finHeadRot = ctx.getTransformer().transformRotation(this.headRot);
        class_243 startPos = ctx.getRecordingData().getStartPos();
        class_243 oldPos = ctx.getPosition();
        double x = (this.flags & 0xC) != 0 ? this.position.field_1352 + startPos.field_1352 : oldPos.field_1352;
        double z = (this.flags & 0xC) != 0 ? this.position.field_1350 + startPos.field_1350 : oldPos.field_1350;
        double y = switch (this.flags & 3) {
            case 1, 2 -> this.position.field_1351 + startPos.field_1351;
            case 3 -> this.position.field_1351;
            default -> oldPos.field_1351;
        };
        ctx.changePosition(new class_243(x, y, z), rotY, rotX, updateRot);
        if (updateRot) {
            entity.method_5847(finHeadRot);
        }
        entity.method_24830((this.flags & 0x40) != 0);
        entity.method_64166(oldPos, entity.method_73189());
        ctx.fluentMovement(() -> new class_2777(entity.method_5628(), class_10182.method_63638((class_1297)entity), Set.of(), (this.flags & 0x40) != 0));
        if (updateRot) {
            byte headRotData = (byte)Math.floor(finHeadRot * 256.0f / 360.0f);
            ctx.fluentMovement(() -> new class_2726(entity, headRotData));
        }
        return MocapAction.Result.OK;
    }
}

