/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.utils.EntityData;
import org.jetbrains.annotations.Nullable;

public class SetEffectParticles
implements MocapStateAction {
    private final Set<String> particleJsonSet = new TreeSet<String>();
    private final boolean ambience;

    @Nullable
    public static SetEffectParticles fromEntity(class_1297 entity) {
        SetEffectParticles setEffectParticles;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            setEffectParticles = new SetEffectParticles(livingEntity);
        } else {
            setEffectParticles = null;
        }
        return setEffectParticles;
    }

    private SetEffectParticles(class_1309 entity) {
        for (class_2394 particle : EntityData.LIVING_ENTITY_EFFECT_PARTICLES.valOrDef((class_1297)entity, List.of())) {
            JsonElement jsonElement = class_2398.field_25125.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)particle).result().orElse(null);
            if (jsonElement == null) continue;
            this.particleJsonSet.add(jsonElement.toString());
        }
        this.ambience = EntityData.LIVING_ENTITY_EFFECT_AMBIENCE.valOrDef((class_1297)entity, false);
    }

    public SetEffectParticles(MocapAction.Reader reader) {
        int count = reader.readPackedInt();
        for (int i = 0; i < count; ++i) {
            String particleJson = reader.readString();
            this.particleJsonSet.add(particleJson);
        }
        this.ambience = reader.readBoolean();
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        return !this.particleJsonSet.equals(((SetEffectParticles)previousAction).particleJsonSet) || this.ambience != ((SetEffectParticles)previousAction).ambience;
    }

    @Override
    public boolean shouldBeInitialized() {
        return !this.particleJsonSet.isEmpty() || this.ambience;
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        writer.addPackedInt(this.particleJsonSet.size());
        this.particleJsonSet.forEach(writer::addString);
        writer.addBoolean(this.ambience);
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        class_1297 class_12972 = ctx.getEntity();
        if (!(class_12972 instanceof class_1309)) {
            return MocapAction.Result.IGNORED;
        }
        class_1309 entity = (class_1309)class_12972;
        ArrayList<class_2394> particles = new ArrayList<class_2394>();
        for (String jsonStr : this.particleJsonSet) {
            try {
                particles.add((class_2394)((Pair)class_2398.field_25125.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse(jsonStr)).getOrThrow()).getFirst());
            }
            catch (Exception exception) {}
        }
        EntityData.LIVING_ENTITY_EFFECT_PARTICLES.set((class_1297)entity, particles);
        EntityData.LIVING_ENTITY_EFFECT_AMBIENCE.set(ctx.getEntity(), this.ambience);
        return MocapAction.Result.OK;
    }
}

