/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.actions;

import java.util.Objects;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1492;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1501;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_7689;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.mixin.fields.AbstractArrowFields;
import net.mt1006.mocap.mixin.fields.AbstractHorseFields;
import net.mt1006.mocap.mixin.fields.BoatFields;
import net.mt1006.mocap.mixin.fields.HorseFields;
import net.mt1006.mocap.mixin.fields.LlamaFields;
import net.mt1006.mocap.utils.EntityData;
import org.jetbrains.annotations.Nullable;

public class SetNonPlayerEntityData
implements MocapStateAction {
    private static final byte VAL_FLAG1 = 1;
    private static final byte VAL_FLAG2 = 2;
    private static final byte HAS_BYTE1 = 4;
    private static final byte HAS_INT1 = 8;
    private static final byte HAS_INT2 = 16;
    private static final byte HAS_INT3 = 32;
    private static final byte HAS_FLOAT1 = 64;
    private final boolean flag1;
    private final boolean flag2;
    @Nullable
    private final Byte byte1;
    @Nullable
    private final Integer int1;
    @Nullable
    private final Integer int2;
    @Nullable
    private final Integer int3;
    @Nullable
    private final Float float1;

    @Nullable
    public static SetNonPlayerEntityData fromEntity(class_1297 entity) {
        if (entity instanceof class_1657) {
            return null;
        }
        if (entity instanceof class_1496) {
            boolean flag1 = false;
            boolean flag2 = ((class_1296)entity).method_5618() < 0;
            Byte byte1 = EntityData.ABSTRACT_HORSE_FLAGS.valOrDef(entity, (byte)0);
            Integer int1 = null;
            if (entity instanceof class_1498) {
                int1 = ((HorseFields)entity).callGetTypeVariant();
            } else if (entity instanceof class_1492) {
                class_1492 chestedHorse = (class_1492)entity;
                flag1 = chestedHorse.method_6703();
            } else if (entity instanceof class_7689) {
                class_7689 camel = (class_7689)entity;
                flag1 = camel.method_45361();
            }
            if (entity instanceof class_1501) {
                class_1501 llama = (class_1501)entity;
                int1 = llama.method_6809().method_47875();
            }
            return new SetNonPlayerEntityData(flag1, flag2, byte1, int1, null, null, null);
        }
        if (entity instanceof class_1690) {
            class_1690 boat = (class_1690)entity;
            return new SetNonPlayerEntityData(boat.method_64491(0), boat.method_64491(1), null, boat.method_54295(), boat.method_54296(), ((BoatFields)entity).callGetBubbleTime(), Float.valueOf(boat.method_54294()));
        }
        if (entity instanceof class_1688) {
            class_1688 minecart = (class_1688)entity;
            return new SetNonPlayerEntityData(false, false, null, minecart.method_54295(), minecart.method_54296(), null, Float.valueOf(minecart.method_54294()));
        }
        if (entity instanceof class_1665) {
            boolean flag1 = ((AbstractArrowFields)entity).callIsInGround();
            return new SetNonPlayerEntityData(flag1, false, null, null, null, null, null);
        }
        if (entity instanceof class_1296) {
            boolean flag2 = ((class_1296)entity).method_5618() < 0;
            return new SetNonPlayerEntityData(false, flag2, null, null, null, null, null);
        }
        return null;
    }

    private SetNonPlayerEntityData(boolean flag1, boolean flag2, @Nullable Byte byte1, @Nullable Integer int1, @Nullable Integer int2, @Nullable Integer int3, @Nullable Float float1) {
        this.byte1 = byte1;
        this.flag1 = flag1;
        this.flag2 = flag2;
        this.int1 = int1;
        this.int2 = int2;
        this.int3 = int3;
        this.float1 = float1;
    }

    public SetNonPlayerEntityData(MocapAction.Reader reader) {
        byte flags = reader.readByte();
        this.flag1 = (flags & 1) != 0;
        this.flag2 = (flags & 2) != 0;
        this.byte1 = (flags & 4) != 0 ? Byte.valueOf(reader.readByte()) : null;
        this.int1 = (flags & 8) != 0 ? Integer.valueOf(reader.readPackedInt()) : null;
        this.int2 = (flags & 0x10) != 0 ? Integer.valueOf(reader.readPackedInt()) : null;
        this.int3 = (flags & 0x20) != 0 ? Integer.valueOf(reader.readPackedInt()) : null;
        this.float1 = (flags & 0x40) != 0 ? Float.valueOf(reader.readFloat()) : null;
    }

    @Override
    public boolean differs(MocapStateAction previousAction) {
        SetNonPlayerEntityData data = (SetNonPlayerEntityData)previousAction;
        return this.flag1 != data.flag1 || this.flag2 != data.flag2 || !Objects.equals(this.byte1, data.byte1) || !Objects.equals(this.int1, data.int1) || !Objects.equals(this.int2, data.int2) || !Objects.equals(this.int3, data.int3) || !Objects.equals(this.float1, data.float1);
    }

    @Override
    public void write(MocapAction.Writer writer, MocapRecordingData data) {
        byte flags = 0;
        flags = (byte)(flags | (this.flag1 ? 1 : 0));
        flags = (byte)(flags | (this.flag2 ? 2 : 0));
        flags = (byte)(flags | (this.byte1 != null ? 4 : 0));
        flags = (byte)(flags | (this.int1 != null ? 8 : 0));
        flags = (byte)(flags | (this.int2 != null ? 16 : 0));
        flags = (byte)(flags | (this.int3 != null ? 32 : 0));
        flags = (byte)(flags | (this.float1 != null ? 64 : 0));
        writer.addByte(flags);
        if (this.byte1 != null) {
            writer.addByte(this.byte1);
        }
        if (this.int1 != null) {
            writer.addPackedInt(this.int1);
        }
        if (this.int2 != null) {
            writer.addPackedInt(this.int2);
        }
        if (this.int3 != null) {
            writer.addPackedInt(this.int3);
        }
        if (this.float1 != null) {
            writer.addFloat(this.float1.floatValue());
        }
    }

    @Override
    public MocapAction.Result execute(MocapActionContext ctx) {
        class_1297 entity = ctx.getEntity();
        if (entity instanceof class_1296) {
            class_1296 ageableMob = (class_1296)entity;
            if (ageableMob.method_5618() < 0) {
                ageableMob.method_5614(0);
            }
            EntityData.AGEABLE_MOB_IS_BABY.set(entity, this.flag2);
        }
        if (entity instanceof class_1496) {
            if (this.byte1 == null) {
                return MocapAction.Result.ERROR;
            }
            EntityData.ABSTRACT_HORSE_FLAGS.set(entity, this.byte1);
            try {
                class_1799 itemStack = new class_1799((class_1935)((this.byte1 & 4) != 0 ? class_1802.field_8175 : class_1802.field_8162));
                ((AbstractHorseFields)entity).getInventory().method_5447(0, itemStack);
            }
            catch (Exception itemStack) {
                // empty catch block
            }
            if (entity instanceof class_1498) {
                ((HorseFields)entity).callSetTypeVariant(this.int1 != null ? this.int1 : 0);
            } else if (entity instanceof class_1492) {
                class_1492 chestedHorse = (class_1492)entity;
                chestedHorse.method_6704(this.flag1);
            } else if (entity instanceof class_7689) {
                class_7689 camel = (class_7689)entity;
                camel.method_45362(this.flag1);
            }
            if (entity instanceof class_1501) {
                ((LlamaFields)entity).callSetVariant(class_1501.class_7993.method_47876((int)(this.int1 != null ? this.int1 : 0)));
            }
        } else if (entity instanceof class_1690) {
            class_1690 boat = (class_1690)entity;
            if (this.int1 == null || this.int2 == null || this.int3 == null || this.float1 == null) {
                return MocapAction.Result.ERROR;
            }
            boat.method_64490(this.flag1, this.flag2);
            boat.method_54299(this.int1.intValue());
            boat.method_54300(this.int2.intValue());
            ((BoatFields)entity).callSetBubbleTime(this.int3);
            boat.method_54297(this.float1.floatValue());
        } else if (entity instanceof class_1688) {
            class_1688 minecart = (class_1688)entity;
            if (this.int1 == null || this.int2 == null || this.float1 == null) {
                return MocapAction.Result.ERROR;
            }
            minecart.method_54299(this.int1.intValue());
            minecart.method_54300(this.int2.intValue());
            minecart.method_54297(this.float1.floatValue());
        } else if (entity instanceof class_1665) {
            ((AbstractArrowFields)entity).callSetInGround(this.flag1);
        }
        return MocapAction.Result.OK;
    }
}

