/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.files;

import java.io.ByteArrayInputStream;
import java.util.Scanner;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerSkin;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerAsEntity;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerSkin;
import net.mt1006.mocap.mocap.playing.modifiers.TimeModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.Transformations;
import org.jetbrains.annotations.Nullable;

public class LegacySceneDataParser {
    private static final String NULL_STR = "[null]";
    private boolean legacy = true;
    private boolean parsed = false;

    public LegacySceneDataParser(SceneData sceneData, CommandOutput out, byte[] scene) {
        try {
            Scanner scanner = new Scanner(new ByteArrayInputStream(scene));
            try {
                int versionNumber;
                try {
                    versionNumber = Integer.parseInt(scanner.next());
                }
                catch (NumberFormatException e) {
                    this.legacy = false;
                    scanner.close();
                    return;
                }
                if (!sceneData.setAndVerifyVersion(out, versionNumber)) {
                    scanner.close();
                }
                if (scanner.hasNextLine()) {
                    scanner.nextLine();
                }
                while (scanner.hasNextLine()) {
                    sceneData.elements.add(LegacySceneDataParser.parseSubscene(new Scanner(scanner.nextLine())));
                }
                this.parsed = true;
            }
            finally {
                try {
                    scanner.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (Exception e) {
            out.sendException(e, "error.failed_to_load_scene", new Object[0]);
        }
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public boolean wasParsed() {
        return this.parsed;
    }

    private static SceneData.Element parseSubscene(Scanner scanner) {
        String elementName = scanner.next();
        MocapModifiers modifiers = PlaybackModifiers.DEFAULT;
        try {
            modifiers = modifiers.withTimeModifiers(TimeModifiers.fromLegacyScene(Double.parseDouble(scanner.next())));
            modifiers = modifiers.withTransformations(Transformations.fromLegacyScene(Double.parseDouble(scanner.next()), Double.parseDouble(scanner.next()), Double.parseDouble(scanner.next())));
            modifiers = modifiers.withPlayerName(LegacySceneDataParser.parsePlayerName(scanner));
            modifiers = modifiers.withPlayerSkin(LegacySceneDataParser.parsePlayerSkin(scanner));
            String playerAsEntityStr = scanner.next();
            if (playerAsEntityStr.equals(NULL_STR)) {
                playerAsEntityStr = null;
            }
            modifiers = modifiers.withPlayerAsEntity(new PlayerAsEntity(playerAsEntityStr, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SceneData.Element(elementName, modifiers);
    }

    @Nullable
    private static String parsePlayerName(Scanner scanner) {
        try {
            String nameStr = scanner.next();
            return nameStr.length() <= 16 && !nameStr.equals(NULL_STR) ? nameStr : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static PlayerSkin parsePlayerSkin(Scanner scanner) {
        MocapPlayerSkin.Source source = MocapPlayerSkin.Source.DEFAULT;
        String skinPath = NULL_STR;
        try {
            skinPath = scanner.next();
            if (!skinPath.equals(NULL_STR)) {
                source = MocapPlayerSkin.Source.FROM_MINESKIN;
            }
            source = LegacySceneDataParser.skinSourceFromLegacyId(Integer.parseInt(scanner.next()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PlayerSkin(source, skinPath.equals(NULL_STR) ? null : skinPath);
    }

    private static MocapPlayerSkin.Source skinSourceFromLegacyId(int id) {
        return switch (id) {
            case 1 -> MocapPlayerSkin.Source.FROM_PLAYER;
            case 2 -> MocapPlayerSkin.Source.FROM_FILE;
            case 3 -> MocapPlayerSkin.Source.FROM_MINESKIN;
            default -> MocapPlayerSkin.Source.DEFAULT;
        };
    }
}

