/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.files;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.impl.extenstion.Extensions;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.extension.MocapExtension;
import net.mt1006.mocap.api.v1.extension.MocapPositionTransformer;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapBlockAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapTickAction;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.command.converter.AlphaConverter;
import net.mt1006.mocap.mocap.actions.ActionType;
import net.mt1006.mocap.mocap.actions.BlockStateData;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playable.RecordingFile;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.playing.playback.PreExecuteContext;
import net.mt1006.mocap.mocap.recording.PositionTracker;
import net.mt1006.mocap.utils.EntityData;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class RecordingData
implements MocapRecordingData {
    public static final RecordingData DUMMY = new RecordingData();
    private static final byte FLAGS1_ENDS_WITH_DEATH = 1;
    private static final byte FLAGS1_PACKED_SIZE_STRINGS = 2;
    private static final byte FLAGS1_HAS_ID_MAPS = 4;
    private static final byte FLAGS1_DIMENSION_SPECIFIED = 8;
    private static final byte FLAGS1_PLAYER_NAME_SPECIFIED = 16;
    private static final byte FLAGS1_HAS_EXTENSIONS = 32;
    private static final byte FLAGS1_EXPERIMENTAL_SUBVERSION = 64;
    private static final byte FLAGS1_HAS_FLAGS2 = -128;
    public long fileSize = 0L;
    public byte version = 0;
    public boolean experimentalVersion = false;
    public class_243 startPos = class_243.field_1353;
    public final float[] startRot = new float[2];
    public boolean endsWithDeath = false;
    private boolean usesIdMaps = true;
    private final ItemIdMap itemIdMap = new ItemIdMap(this);
    private final BlockStateIdMap blockStateIdMap = new BlockStateIdMap(this);
    @Nullable
    public class_2960 dimensionId = null;
    @Nullable
    public String playerName = null;
    private final SortedMap<Integer, MocapExtension> extensionById = new TreeMap<Integer, MocapExtension>();
    private final Map<MocapExtension, Byte> extensionToId = new HashMap<MocapExtension, Byte>();
    private final Map<MocapExtension, MocapRecordingData.ExtensionHeader> extensionHeaders = new HashMap<MocapExtension, MocapRecordingData.ExtensionHeader>();
    public byte experimentalSubversion = 0;
    public final List<MocapAction> actions = new ArrayList<MocapAction>();
    public final List<MocapBlockAction> blockActions = new ArrayList<MocapBlockAction>();
    public long tickCount = 0L;

    public static RecordingData forWriting() {
        RecordingData data = new RecordingData();
        data.setCurrentVersion();
        return data;
    }

    public void save(BufferedOutputStream stream) throws IOException {
        if (this.version != 5) {
            throw new RuntimeException("Trying to save recording with read-only version.");
        }
        this.actions.forEach(a -> ActionType.prepareToWriteAction(this, a));
        RecordingFiles.Writer writer = new RecordingFiles.Writer();
        writer.addByte(this.experimentalVersion ? -this.version : this.version);
        this.saveHeader(writer);
        this.actions.forEach(a -> ActionType.writeAction(writer, this, a));
        stream.write(writer.toByteArray());
    }

    public boolean load(CommandOutput out, @Nullable RecordingFile file, boolean useConverter) {
        if (file == null) {
            return false;
        }
        byte[] data = Files.loadFile(file.getFile());
        return data != null && this.load(out, new RecordingFiles.FileReader(data, true), useConverter);
    }

    private boolean load(CommandOutput out, RecordingFiles.FileReader reader, boolean useConverter) {
        AlphaConverter converter;
        this.fileSize = reader.getSize();
        byte versionByte = reader.readByte();
        this.version = (byte)Math.abs(versionByte);
        boolean bl = this.experimentalVersion = versionByte < 0;
        if (this.version > 5) {
            out.sendFailure("playback.start.error.load_header", new Object[0]);
            return false;
        }
        if (!this.loadHeader(out, reader, this.version == 1 || this.version == 2, useConverter)) {
            return false;
        }
        AlphaConverter alphaConverter = converter = this.experimentalVersion && this.version == 5 && this.experimentalSubversion == 0 && useConverter ? new AlphaConverter(this.startPos) : null;
        while (reader.canRead()) {
            MocapAction action = ActionType.readAction(reader, this, converter, null);
            if (action == null) {
                return false;
            }
            this.actions.add(action);
            if (action instanceof MocapBlockAction) {
                this.blockActions.add((MocapBlockAction)action);
                continue;
            }
            if (!(action instanceof MocapTickAction)) continue;
            MocapTickAction tickAction = (MocapTickAction)action;
            this.tickCount += (long)tickAction.getTickCount();
        }
        return true;
    }

    private void saveHeader(RecordingFiles.Writer writer) {
        boolean hasIdMaps = this.usesIdMaps && (this.itemIdMap.size() != 0 || this.blockStateIdMap.size() != 0);
        writer.addVec3(this.startPos);
        writer.addFloat(this.startRot[0]);
        writer.addFloat(this.startRot[1]);
        byte flags1 = 0;
        flags1 = (byte)(flags1 | (this.endsWithDeath ? 1 : 0));
        flags1 = (byte)(flags1 | 2);
        flags1 = (byte)(flags1 | (hasIdMaps ? 4 : 0));
        flags1 = (byte)(flags1 | (this.dimensionId != null ? 8 : 0));
        flags1 = (byte)(flags1 | (this.playerName != null ? 16 : 0));
        flags1 = (byte)(flags1 | (!this.extensionById.isEmpty() ? 32 : 0));
        flags1 = (byte)(flags1 | (this.experimentalSubversion != 0 ? 64 : 0));
        writer.addByte(flags1);
        if (hasIdMaps) {
            this.itemIdMap.save(writer);
            this.blockStateIdMap.save(writer);
        }
        if (this.dimensionId != null) {
            writer.addString(this.dimensionId.toString());
        }
        if (this.playerName != null) {
            writer.addString(this.playerName);
        }
        if (!this.extensionById.isEmpty()) {
            this.saveExtensionHeaders(writer);
        }
        if (this.experimentalSubversion != 0) {
            writer.addByte(this.experimentalSubversion);
        }
    }

    private void saveExtensionHeaders(RecordingFiles.Writer writer) {
        writer.addByte((byte)this.extensionById.size());
        int expectedId = 0;
        for (Map.Entry<Integer, MocapExtension> entry : this.extensionById.entrySet()) {
            if (entry.getKey() != expectedId) {
                throw new RuntimeException("Extensions in wrong order! Trying to save loaded recording?");
            }
            ++expectedId;
            MocapExtension extension = entry.getValue();
            writer.addString(extension.getId());
            writer.addShort(extension.getVersion());
            writer.addByte(extension.isRequired() ? (byte)1 : 0);
            RecordingFiles.Writer headerWriter = new RecordingFiles.Writer();
            this.extensionHeaders.get(extension).save(headerWriter);
            writer.addPackedInt(headerWriter.getSize());
            headerWriter.copyToWriter(writer);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean loadHeader(CommandOutput out, RecordingFiles.FileReader reader, boolean legacyHeader, boolean useConverter) {
        boolean hasExperimentalSubversion;
        this.startPos = reader.readVec3();
        this.startRot[0] = reader.readFloat();
        this.startRot[1] = reader.readFloat();
        if (legacyHeader) {
            return true;
        }
        byte flags1 = reader.readByte();
        this.endsWithDeath = (flags1 & 1) != 0;
        reader.setStringMode((flags1 & 2) == 0);
        this.usesIdMaps = (flags1 & 4) != 0;
        boolean startDimensionSpecified = (flags1 & 8) != 0;
        boolean playerNameSpecified = (flags1 & 0x10) != 0;
        boolean hasExtensions = (flags1 & 0x20) != 0;
        boolean bl = hasExperimentalSubversion = (flags1 & 0x40) != 0;
        if (this.experimentalVersion && this.version == 5 && !hasExperimentalSubversion) {
            if (!useConverter) {
                out.sendFailure("failure.not_supported_experimental_format", new Object[0]);
                out.sendFailure("failure.not_supported_experimental_format.suggest_converter.1", new Object[0]);
                out.sendFailure("failure.not_supported_experimental_format.suggest_converter.2", new Object[0]);
                return false;
            }
            reader.convertStrings = true;
        } else if (useConverter) {
            return out.sendFailure("misc.converter.not_convertible", new Object[0]);
        }
        if (this.usesIdMaps) {
            this.itemIdMap.load(reader);
            this.blockStateIdMap.load(reader);
        }
        if (startDimensionSpecified) {
            this.dimensionId = class_2960.method_60654((String)reader.readString());
        }
        if (playerNameSpecified) {
            this.playerName = reader.readString();
        }
        if (hasExtensions && !this.loadExtensionHeaders(out, reader)) {
            return false;
        }
        if (hasExperimentalSubversion) {
            this.experimentalSubversion = reader.readByte();
        }
        return true;
    }

    private boolean loadExtensionHeaders(CommandOutput out, RecordingFiles.FileReader reader) {
        int extensionCount = Byte.toUnsignedInt(reader.readByte());
        for (int i = 0; i < extensionCount; ++i) {
            String extensionId = reader.readString();
            short minVersion = reader.readShort();
            boolean isRequiredFlag = (reader.readByte() & 1) != 0;
            int headerSize = reader.readPackedInt();
            MocapExtension extension = Extensions.getExtension(extensionId, minVersion);
            if (extension == null) {
                if (Extensions.isRequired(isRequiredFlag)) {
                    out.sendFailure("playback.start.error.extension.not_present", extensionId);
                    return false;
                }
                reader.shift(headerSize);
                continue;
            }
            MocapRecordingData.ExtensionHeader extensionHeader = extension.createHeader();
            if (!extensionHeader.load(reader)) {
                out.sendFailure("playback.start.error.extension.load_header", extensionId);
                return false;
            }
            this.addExtension(i, extension, extensionHeader);
        }
        return true;
    }

    private void addExtension(int id, MocapExtension extension, MocapRecordingData.ExtensionHeader extensionHeader) {
        this.extensionById.put(id, extension);
        this.extensionToId.put(extension, (byte)id);
        this.extensionHeaders.put(extension, extensionHeader);
    }

    public void initAndAddExtension(MocapExtension extension) {
        this.addExtension(this.extensionById.size(), extension, extension.createHeader());
    }

    public void setCurrentVersion() {
        this.version = (byte)5;
        this.experimentalVersion = true;
        this.experimentalSubversion = 1;
    }

    public void initEntityPosition(class_1297 entity, MocapPositionTransformer transformer, boolean teleportFarAway) {
        class_243 pos = teleportFarAway ? PositionTracker.FAR_AWAY : transformer.transformPos(this.startPos);
        float rotY = transformer.transformRotation(this.startRot[0]);
        entity.method_60949(pos, rotY, this.startRot[1]);
        entity.method_5847(rotY);
    }

    public void preExecute(PreExecuteContext ctx) {
        if (ctx.getConfig().getBlockInitialization()) {
            for (int i = this.blockActions.size() - 1; i >= 0; --i) {
                this.blockActions.get(i).initBlocks(ctx);
            }
        }
    }

    public MocapAction.Result executeAction(ActionContext ctx, MocapPlaybackConfig config, boolean initialAction, int pos) {
        if (pos >= this.actions.size()) {
            return MocapAction.Result.END;
        }
        try {
            MocapAction nextAction = this.actions.get(pos);
            if (!config.getBlockActionsPlayback() && nextAction instanceof BlockStateData) {
                return MocapAction.Result.OK;
            }
            if (initialAction) {
                MocapStateAction stateAction;
                MocapTickAction tickAction;
                if (nextAction instanceof MocapTickAction && (tickAction = (MocapTickAction)nextAction).endsTick()) {
                    return MocapAction.Result.NEXT_TICK;
                }
                if (!(nextAction instanceof MocapStateAction) || !(stateAction = (MocapStateAction)nextAction).shouldBeInitialized()) {
                    return MocapAction.Result.IGNORED;
                }
            }
            return nextAction.execute(ctx);
        }
        catch (Exception e) {
            Utils.exception(e, "Exception occurred while executing action!");
            return MocapAction.Result.ERROR;
        }
    }

    public void firstExecute(class_1297 entity) {
        if (entity instanceof class_1657) {
            EntityData.PLAYER_SKIN_PARTS.set(entity, (byte)127);
        }
    }

    @Override
    public class_243 getStartPos() {
        return this.startPos;
    }

    @Override
    public class_1792 itemFromId(int id) {
        return this.itemIdMap.getObject(id);
    }

    @Override
    public int provideItemId(class_1792 item) {
        return this.itemIdMap.provideMappedId(item);
    }

    @Override
    public class_2680 blockStateFromId(int id) {
        return (class_2680)this.blockStateIdMap.getMappedObject(id);
    }

    @Override
    public int provideBlockStateId(class_2680 blockState) {
        return this.blockStateIdMap.provideMappedId(blockState);
    }

    @Override
    @Nullable
    public MocapExtension getExtension(byte idFromRecording) {
        return (MocapExtension)this.extensionById.get(Byte.toUnsignedInt(idFromRecording));
    }

    @Override
    @Nullable
    public Byte getExtensionId(MocapExtension extension) {
        return this.extensionToId.get(extension);
    }

    public static class ItemIdMap
    extends RefIdMap<class_1792> {
        public ItemIdMap(RecordingData parent) {
            super(parent);
        }

        @Override
        protected void init() {
            this.put(class_1802.field_8162);
        }

        @Override
        public int provideId(class_1792 item) {
            return this.parent.usesIdMaps ? this.provideMappedId(item) : class_1792.method_7880((class_1792)item);
        }

        @Override
        public class_1792 getObject(int id) {
            return this.parent.usesIdMaps ? (class_1792)this.getMappedObject(id) : class_1792.method_7875((int)id);
        }

        @Override
        protected void save(MocapAction.Writer writer) {
            writer.addInt(this.size());
            this.idToRef.subList(1, this.idToRef.size()).forEach(item -> writer.addString(this.resLocToStr(class_7923.field_41178.method_10221(item))));
        }

        @Override
        protected void load(MocapAction.Reader reader) {
            int size = reader.readInt();
            for (int i = 1; i <= size; ++i) {
                Optional itemHolder = class_7923.field_41178.method_10223(class_2960.method_60654((String)reader.readString()));
                class_1792 item = (class_1792)((class_6880.class_6883)itemHolder.get()).comp_349();
                this.refToId.put((Object)item, i);
                this.idToRef.add(item);
            }
        }
    }

    public static class BlockStateIdMap
    extends RefIdMap<class_2680> {
        public BlockStateIdMap(RecordingData parent) {
            super(parent);
        }

        @Override
        protected void init() {
            this.put(class_2246.field_10124.method_9564());
        }

        @Override
        public int provideId(class_2680 blockState) {
            return this.parent.usesIdMaps ? this.provideMappedId(blockState) : class_2248.method_9507((class_2680)blockState);
        }

        @Override
        public class_2680 getObject(int id) {
            return this.parent.usesIdMaps ? (class_2680)this.getMappedObject(id) : class_2248.method_9531((int)id);
        }

        @Override
        protected void save(MocapAction.Writer writer) {
            writer.addInt(this.size());
            for (class_2680 blockState : this.idToRef.subList(1, this.idToRef.size())) {
                List<class_2769> properties = blockState.method_28501();
                if (properties.size() > Short.MAX_VALUE) {
                    MocapMod.LOGGER.warn("BlockState properties count limit reached ({})!", (Object)properties.size());
                    properties = List.of();
                }
                writer.addString(this.resLocToStr(class_7923.field_41175.method_10221((Object)blockState.method_26204())));
                writer.addShort((short)properties.size());
                for (class_2769 property : properties) {
                    writer.addString(property.method_11899());
                    writer.addString(BlockStateIdMap.propertyValueToStr(blockState, property));
                }
            }
        }

        @Override
        protected void load(MocapAction.Reader reader) {
            int size = reader.readInt();
            for (int i = 1; i <= size; ++i) {
                Optional blockHolder = class_7923.field_41175.method_10223(class_2960.method_60654((String)reader.readString()));
                class_2248 block = (class_2248)((class_6880.class_6883)blockHolder.get()).comp_349();
                class_2689 stateDefinition = block.method_9595();
                class_2680 blockState = block.method_9564();
                int propertyCount = reader.readShort();
                for (int j = 0; j < propertyCount; ++j) {
                    class_2769 property = stateDefinition.method_11663(reader.readString());
                    blockState = BlockStateIdMap.updateBlockState(blockState, property, reader.readString());
                }
                this.refToId.put((Object)blockState, i);
                this.idToRef.add(blockState);
            }
        }

        private static <T extends Comparable<T>> String propertyValueToStr(class_2680 blockState, class_2769<T> property) {
            return property.method_11901(blockState.method_11654(property));
        }

        private static <T extends Comparable<T>> class_2680 updateBlockState(class_2680 blockState, @Nullable class_2769<T> property, String str) {
            if (property == null) {
                return blockState;
            }
            Optional value = property.method_11900(str);
            return value.map(val -> (class_2680)blockState.method_11657(property, val)).orElse(blockState);
        }
    }

    public static abstract class RefIdMap<T> {
        protected final RecordingData parent;
        protected final Reference2IntMap<T> refToId = new Reference2IntOpenHashMap();
        protected final List<T> idToRef = new ArrayList<T>();

        public RefIdMap(RecordingData parent) {
            this.parent = parent;
            this.init();
        }

        public int size() {
            return this.idToRef.size() - 1;
        }

        protected int provideMappedId(T ref) {
            int id = this.refToId.getOrDefault(ref, -1);
            return id != -1 ? id : this.put(ref);
        }

        protected T getMappedObject(int id) {
            return this.idToRef.get(id);
        }

        protected int put(T ref) {
            int pos = this.idToRef.size();
            this.idToRef.add(ref);
            this.refToId.put(ref, pos);
            return pos;
        }

        protected String resLocToStr(class_2960 resLoc) {
            return resLoc.method_12836().equals("minecraft") ? resLoc.method_12832() : resLoc.toString();
        }

        protected abstract void init();

        public abstract int provideId(T var1);

        public abstract T getObject(int var1);

        protected abstract void save(MocapAction.Writer var1);

        protected abstract void load(MocapAction.Reader var1);
    }
}

