/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.mt1006.mocap.api.v1.controller.playable.MocapRecordingFile;
import net.mt1006.mocap.api.v1.controller.playable.MocapSceneElement;
import net.mt1006.mocap.api.v1.controller.playable.MocapSceneFile;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.playing.playable.Playable;
import net.mt1006.mocap.mocap.playing.playable.RecordingFile;
import net.mt1006.mocap.mocap.playing.playable.SceneFile;

public class PlaybackDataManager {
    private final Map<MocapRecordingFile, RecordingData> recordingMap = new HashMap<MocapRecordingFile, RecordingData>();
    private final Map<MocapSceneFile, SceneData> sceneMap = new HashMap<MocapSceneFile, SceneData>();
    private final Stack<Playable> resourceStack = new Stack();

    public boolean loadRecording(CommandOutput out, RecordingFile file) {
        if (this.recordingMap.containsKey(file)) {
            return true;
        }
        this.resourceStack.push(file);
        RecordingData recording = new RecordingData();
        if (!recording.load(out, file, false)) {
            return this.sendFailureWithPath(out);
        }
        this.recordingMap.put(file, recording);
        this.resourceStack.pop();
        return true;
    }

    public boolean loadScene(CommandOutput out, SceneFile file) {
        if (this.sceneMap.containsKey(file)) {
            return true;
        }
        boolean hasResourceLoop = this.resourceStack.contains(file);
        this.resourceStack.push(file);
        if (hasResourceLoop) {
            return this.sendFailureWithPath(out, "playback.start.error.loop");
        }
        SceneData sceneData = new SceneData();
        if (!sceneData.load(out, file)) {
            return this.sendFailureWithPath(out);
        }
        this.sceneMap.put(file, sceneData);
        for (MocapSceneElement element : sceneData.elements) {
            if (this.loadFromName(out, element.getName())) continue;
            return false;
        }
        this.resourceStack.pop();
        return true;
    }

    private boolean loadFromName(CommandOutput out, String name) {
        if (name.charAt(0) == '.') {
            SceneFile file = SceneFile.get(out, name);
            return file != null && this.loadScene(out, file);
        }
        RecordingFile file = RecordingFile.get(out, name);
        return file != null && this.loadRecording(out, file);
    }

    private boolean sendFailureWithPath(CommandOutput out) {
        return this.sendFailureWithPath(out, "playback.start.error.load");
    }

    private boolean sendFailureWithPath(CommandOutput out, String component) {
        StringBuilder retStr = new StringBuilder();
        for (Playable playable : this.resourceStack) {
            retStr.append("/");
            retStr.append(playable.getName());
        }
        String path = retStr.toString();
        out.sendFailure(component, new Object[0]);
        out.sendFailure("playback.start.error.load.path", path);
        return false;
    }

    public RecordingData getRecording(MocapRecordingFile file) {
        return this.recordingMap.get(file);
    }

    public SceneData getScene(MocapSceneFile file) {
        return this.sceneMap.get(file);
    }
}

