/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_3222;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.command.CommandsContext;
import net.mt1006.mocap.command.io.FullCommandInfo;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.playable.Playable;
import net.mt1006.mocap.mocap.playing.playback.Playback;
import net.mt1006.mocap.mocap.playing.playback.PlaybackRoot;
import net.mt1006.mocap.mocap.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class PlaybackManager {
    public static final String MOCAP_ENTITY_TAG = "mocap_entity";
    public static final Multimap<String, PlaybackRoot> playbacksByOwner = HashMultimap.create();
    public static final Collection<PlaybackRoot> playbacks = playbacksByOwner.values();
    private static long tickCounter = 0L;
    private static double timer = 0.0;
    private static double previousPlaybackSpeed = 0.0;
    private static int nextPlaybackId = 0;

    public static PlaybackRoot addPlayback(Playable playable, Playback playback, boolean isHidden) {
        PlaybackRoot playbackRoot = new PlaybackRoot(playback, PlaybackManager.getNextId(), playable.getName(), playback.config, isHidden);
        playbacksByOwner.put((Object)(playback.owner != null ? playback.owner.method_5477().getString() : ""), (Object)playbackRoot);
        return playbackRoot;
    }

    private static int getNextId() {
        return nextPlaybackId++;
    }

    public static boolean stop(CommandOutput out, String id, @Nullable String expectedName) {
        PlaybackRoot playback = PlaybackManager.findPlayback(out, id, expectedName);
        if (playback == null) {
            return out.sendFailureWithTip("playback.stop.unable_to_find_playback", new Object[0]);
        }
        playback.stop();
        out.sendSuccess("playback.stop.success", new Object[0]);
        return true;
    }

    @Nullable
    public static PlaybackRoot findPlayback(CommandOutput out, String id, @Nullable String expectedName) {
        for (PlaybackRoot playback : playbacks) {
            if (!playback.getId().equals(id)) continue;
            if (expectedName != null && !expectedName.equals(playback.getRootName())) {
                out.sendFailure("playback.stop.wrong_playback_name", new Object[0]);
                return null;
            }
            return playback;
        }
        return null;
    }

    public static void stopAll(CommandOutput out, @Nullable class_3222 player) {
        if (player == null) {
            playbacks.forEach(PlaybackRoot::stop);
            out.sendSuccess(playbacks.isEmpty() ? "playback.stop_all.empty" : "playback.stop_all.all", new Object[0]);
        } else {
            Collection playerPlaybacks = playbacksByOwner.get((Object)player.method_5477().getString());
            playerPlaybacks.forEach(PlaybackRoot::stop);
            if (playerPlaybacks.isEmpty()) {
                out.sendSuccess(playbacks.isEmpty() ? "playback.stop_all.empty" : "playback.stop_all.own.empty", new Object[0]);
            } else {
                out.sendSuccess(playerPlaybacks.size() == playbacks.size() ? "playback.stop_all.own.all" : "playback.stop_all.own.not_all", new Object[0]);
            }
            if (playerPlaybacks.size() != playbacks.size() && ((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
                out.sendSuccess("playback.stop_all.own.tip", new Object[0]);
            }
        }
    }

    public static boolean modifiersSet(FullCommandInfo rootInfo) {
        class_3222 source = rootInfo.getSourcePlayer();
        if (source == null) {
            return rootInfo.sendFailure("failure.resolve_player", new Object[0]);
        }
        CommandsContext ctx = CommandsContext.get(source);
        FullCommandInfo info = rootInfo.getFinalCommandInfo();
        if (info == null) {
            return rootInfo.sendFailure("error.unable_to_get_argument", new Object[0]);
        }
        String propertyName = info.getNode(4);
        if (propertyName == null) {
            return rootInfo.sendFailure("error.unable_to_get_argument", new Object[0]);
        }
        try {
            MocapModifiers newModifiers = ctx.modifiers.modify(info, propertyName, 4);
            if (newModifiers != null) {
                ctx.modifiers = newModifiers;
            }
            return newModifiers != null ? rootInfo.sendSuccess("playback.modifiers.set", new Object[0]) : rootInfo.sendFailure("error.generic", new Object[0]);
        }
        catch (Exception e) {
            return rootInfo.sendException(e, "error.unable_to_get_argument", new Object[0]);
        }
    }

    public static boolean modifiersList(CommandInfo info) {
        class_3222 source = info.getSourcePlayer();
        if (source == null) {
            return info.sendFailure("failure.resolve_player", new Object[0]);
        }
        CommandsContext ctx = CommandsContext.get(source);
        info.sendSuccess("playback.modifiers.list", new Object[0]);
        ctx.modifiers.list(info);
        return true;
    }

    public static boolean modifiersReset(CommandInfo info) {
        class_3222 source = info.getSourcePlayer();
        if (source == null) {
            return info.sendFailure("failure.resolve_player", new Object[0]);
        }
        CommandsContext ctx = CommandsContext.get(source);
        ctx.modifiers = PlaybackModifiers.DEFAULT;
        return info.sendSuccess("playback.modifiers.reset", new Object[0]);
    }

    public static boolean modifiersAddTo(CommandInfo info, String sceneName, String toAdd) {
        class_3222 source = info.getSourcePlayer();
        if (source == null) {
            return info.sendFailure("failure.resolve_player", new Object[0]);
        }
        SceneData.Element element = new SceneData.Element(toAdd, CommandsContext.get((class_3222)source).modifiers);
        return SceneFiles.addElement(info, sceneName, element);
    }

    public static boolean list(CommandOutput out) {
        if (playbacks.isEmpty()) {
            out.sendSuccess("playback.list.empty", new Object[0]);
        } else {
            out.sendSuccess("playback.list", new Object[0]);
            playbacks.forEach(p -> out.sendSuccessLiteral("[%s] %s", p.getId(), p.getRootName()));
        }
        return true;
    }

    public static void onTick() {
        if (playbacks.isEmpty()) {
            ++tickCounter;
            return;
        }
        if (previousPlaybackSpeed != (Double)Settings.PLAYBACK_SPEED.val) {
            timer = 0.0;
            previousPlaybackSpeed = (Double)Settings.PLAYBACK_SPEED.val;
        }
        if ((long)timer < tickCounter) {
            timer = tickCounter;
        }
        while ((long)timer == tickCounter) {
            ArrayList<PlaybackRoot> toRemove = new ArrayList<PlaybackRoot>();
            for (PlaybackRoot playback : playbacks) {
                if (playback.isFinished()) {
                    toRemove.add(playback);
                    continue;
                }
                playback.tick();
            }
            PlaybackManager.removePlaybacks(toRemove);
            if (playbacks.isEmpty()) break;
            timer += 1.0 / (Double)Settings.PLAYBACK_SPEED.val;
        }
        ++tickCounter;
    }

    private static void removePlaybacks(Collection<PlaybackRoot> toRemove) {
        for (PlaybackRoot playback : toRemove) {
            class_3222 owner = playback.getOwner();
            playbacksByOwner.remove((Object)(owner != null ? owner.method_5477().getString() : ""), (Object)playback);
        }
    }
}

