/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_2960;
import net.minecraft.class_6026;
import net.minecraft.class_7923;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.mocap.files.Files;
import org.jetbrains.annotations.Nullable;

public class EntityFilterInstance {
    private static final String EMPTY_GROUP = "none";
    public final String filterStr;
    private final List<Element> elements;

    private EntityFilterInstance(String str) throws FilterParserException {
        this.filterStr = str;
        this.elements = Collections.unmodifiableList(EntityFilterInstance.parse(str));
    }

    private static List<Element> parse(String str) throws FilterParserException {
        String[] parts;
        ArrayList<Element> elements = new ArrayList<Element>();
        if (str.isEmpty()) {
            return elements;
        }
        for (String part : parts = str.split(";")) {
            String name;
            boolean exclude;
            if (part.isBlank()) {
                throw new FilterParserException();
            }
            boolean bl = exclude = part.charAt(0) == '-';
            if (exclude && part.length() == 1) {
                throw new FilterParserException();
            }
            char firstChar = part.charAt(exclude ? 1 : 0);
            if (firstChar == '@') {
                String groupName = part.substring(exclude ? 2 : 1);
                if (groupName.equals(EMPTY_GROUP)) continue;
                if (!Files.checkIfProperName(CommandOutput.DUMMY, groupName)) {
                    throw new FilterParserException();
                }
                GroupElement groupElement = Group.fromString(exclude, groupName);
                if (groupElement == null) {
                    throw new FilterParserException();
                }
                elements.add(groupElement);
                continue;
            }
            if (firstChar == '$') {
                String tagName = part.substring(exclude ? 2 : 1);
                elements.add(new TagElement(exclude, tagName));
                continue;
            }
            String string = name = exclude ? part.substring(1) : part;
            if (name.equals("*")) {
                elements.add(exclude ? AllEntitiesElement.EXCLUDE_ALL : AllEntitiesElement.INCLUDE_ALL);
                continue;
            }
            if (name.endsWith(":*")) {
                if (name.length() == 2) {
                    throw new FilterParserException();
                }
                String namespace = name.substring(0, name.length() - 2);
                if (!class_2960.method_20209((String)namespace)) {
                    throw new FilterParserException();
                }
                elements.add(new AllEntitiesElement(exclude, namespace));
                continue;
            }
            class_2960 resLoc = EntityFilterInstance.parseToResLoc(name);
            Element lastElement = elements.isEmpty() ? null : (Element)elements.get(elements.size() - 1);
            boolean reuseEntitySet = lastElement instanceof EntitySetElement && lastElement.exclude == exclude;
            EntitySetElement entitySetElement = reuseEntitySet ? (EntitySetElement)lastElement : new EntitySetElement(exclude);
            entitySetElement.add(resLoc);
            if (reuseEntitySet) continue;
            elements.add(entitySetElement);
        }
        return elements;
    }

    @Nullable
    public static EntityFilterInstance create(String str) {
        try {
            return new EntityFilterInstance(str);
        }
        catch (FilterParserException e) {
            return null;
        }
    }

    public static boolean test(String str) {
        try {
            EntityFilterInstance.parse(str);
            return true;
        }
        catch (FilterParserException e) {
            return false;
        }
    }

    public boolean isAllowed(class_1297 entity) {
        boolean allowed = false;
        for (Element element : this.elements) {
            switch (element.isAllowed(entity).ordinal()) {
                case 0: {
                    allowed = true;
                    break;
                }
                case 1: {
                    allowed = false;
                    break;
                }
            }
        }
        return allowed;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    private static class_2960 parseToResLoc(String str) throws FilterParserException {
        class_2960 resLoc = class_2960.method_12829((String)str);
        if (resLoc == null) {
            throw new FilterParserException();
        }
        return resLoc;
    }

    public static class FilterParserException
    extends Exception {
    }

    private static enum Group {
        VEHICLES(List.of(class_6026.class, class_1695.class, class_1690.class)),
        PROJECTILES(List.of(class_1676.class)),
        ITEMS(List.of(class_1542.class)),
        MOBS(List.of(class_1308.class)),
        MINECARTS(List.of(class_1688.class));

        public final String name = this.name().toLowerCase();
        public final GroupElement include;
        public final GroupElement exclude;

        private Group(List<Class<?>> parent) {
            this.include = new GroupElement(false, this.name, parent);
            this.exclude = new GroupElement(true, this.name, parent);
        }

        @Nullable
        public static GroupElement fromString(boolean exclude, String str) {
            try {
                Group group = Group.valueOf(str.toUpperCase());
                return exclude ? group.exclude : group.include;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    private static class GroupElement
    extends Element {
        public final String name;
        private final List<Class<?>> parents;

        public GroupElement(boolean exclude, String name, List<Class<?>> parents) {
            super(exclude);
            this.name = name;
            this.parents = parents;
        }

        @Override
        protected boolean applies(class_1297 entity) {
            for (Class<?> parent : this.parents) {
                if (!parent.isInstance(entity)) continue;
                return true;
            }
            return false;
        }
    }

    private static class TagElement
    extends Element {
        public final String tag;

        public TagElement(boolean exclude, String tag) {
            super(exclude);
            this.tag = tag;
        }

        @Override
        protected boolean applies(class_1297 entity) {
            return entity.method_5752().contains(this.tag);
        }
    }

    private static class AllEntitiesElement
    extends Element {
        public static final AllEntitiesElement INCLUDE_ALL = new AllEntitiesElement(false, null);
        public static final AllEntitiesElement EXCLUDE_ALL = new AllEntitiesElement(false, null);
        @Nullable
        private final String fromNamespace;

        public AllEntitiesElement(boolean exclude, @Nullable String fromNamespace) {
            super(exclude);
            this.fromNamespace = fromNamespace;
        }

        @Override
        protected boolean applies(class_1297 entity) {
            if (this.fromNamespace == null) {
                return true;
            }
            return class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12836().equals(this.fromNamespace);
        }
    }

    private static abstract class Element {
        private final boolean exclude;

        protected Element(boolean exclude) {
            this.exclude = exclude;
        }

        public FilterElementResults isAllowed(class_1297 entity) {
            return this.applies(entity) ? (this.exclude ? FilterElementResults.DENY : FilterElementResults.ALLOW) : FilterElementResults.IGNORE;
        }

        protected abstract boolean applies(class_1297 var1);
    }

    private static class EntitySetElement
    extends Element {
        public final Set<class_1299<?>> set = new HashSet();

        public EntitySetElement(boolean exclude) {
            super(exclude);
        }

        public void add(class_2960 resLoc) {
            Optional entityType = class_7923.field_41177.method_17966(resLoc);
            entityType.ifPresent(this.set::add);
        }

        @Override
        protected boolean applies(class_1297 entity) {
            return this.set.contains(entity.method_5864());
        }
    }

    private static enum FilterElementResults {
        ALLOW,
        DENY,
        IGNORE;

    }
}

