/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.class_2212;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7733;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapEntityFilter;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerAsEntity;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerSkin;
import net.mt1006.mocap.api.v1.modifiers.MocapTimeModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapTransformations;
import net.mt1006.mocap.command.io.FullCommandInfo;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilter;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilterInstance;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerAsEntity;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerSkin;
import net.mt1006.mocap.mocap.playing.modifiers.TimeModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.Transformations;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class PlaybackModifiers
implements MocapModifiers {
    public static final PlaybackModifiers DEFAULT = new PlaybackModifiers(null, PlayerSkin.DEFAULT, Transformations.EMPTY, PlayerAsEntity.DISABLED, TimeModifiers.DEFAULT, EntityFilter.FOR_PLAYBACK);
    @Nullable
    public final String playerName;
    public final MocapPlayerSkin playerSkin;
    public final MocapTransformations transformations;
    public final MocapPlayerAsEntity playerAsEntity;
    public final MocapTimeModifiers timeModifiers;
    public final MocapEntityFilter entityFilter;

    private PlaybackModifiers(@Nullable String playerName, MocapPlayerSkin playerSkin, MocapTransformations transformations, MocapPlayerAsEntity playerAsEntity, MocapTimeModifiers timeModifiers, MocapEntityFilter entityFilter) {
        this.playerName = playerName;
        this.playerSkin = playerSkin;
        this.transformations = transformations;
        this.playerAsEntity = playerAsEntity;
        this.timeModifiers = timeModifiers;
        this.entityFilter = entityFilter;
    }

    public PlaybackModifiers(SceneFiles.Reader reader) {
        this.playerName = reader.readString("player_name");
        this.playerSkin = PlayerSkin.fromObject(reader.readObject("player_skin"));
        this.transformations = Transformations.fromObject(reader.readObject("transformations"));
        this.playerAsEntity = PlayerAsEntity.fromObject(reader.readObject("player_as_entity"));
        this.timeModifiers = TimeModifiers.fromObject(reader.readObject("time"));
        this.entityFilter = EntityFilter.fromString(reader.readString("entity_filter"));
    }

    @Override
    @Nullable
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public MocapModifiers withPlayerName(@Nullable String name) {
        return new PlaybackModifiers(name, this.playerSkin, this.transformations, this.playerAsEntity, this.timeModifiers, this.entityFilter);
    }

    @Override
    public MocapPlayerSkin getPlayerSkin() {
        return this.playerSkin;
    }

    @Override
    public MocapModifiers withPlayerSkin(MocapPlayerSkin skin) {
        return new PlaybackModifiers(this.playerName, skin, this.transformations, this.playerAsEntity, this.timeModifiers, this.entityFilter);
    }

    @Override
    public MocapTransformations getTransformations() {
        return this.transformations;
    }

    @Override
    public MocapModifiers withTransformations(MocapTransformations transformations) {
        return new PlaybackModifiers(this.playerName, this.playerSkin, transformations, this.playerAsEntity, this.timeModifiers, this.entityFilter);
    }

    @Override
    public MocapPlayerAsEntity getPlayerAsEntity() {
        return this.playerAsEntity;
    }

    @Override
    public MocapModifiers withPlayerAsEntity(MocapPlayerAsEntity playerAsEntity) {
        return new PlaybackModifiers(this.playerName, this.playerSkin, this.transformations, playerAsEntity, this.timeModifiers, this.entityFilter);
    }

    @Override
    public MocapTimeModifiers getTimeModifiers() {
        return this.timeModifiers;
    }

    @Override
    public MocapModifiers withTimeModifiers(MocapTimeModifiers timeModifiers) {
        return new PlaybackModifiers(this.playerName, this.playerSkin, this.transformations, this.playerAsEntity, timeModifiers, this.entityFilter);
    }

    @Override
    public MocapEntityFilter getEntityFilter() {
        return this.entityFilter;
    }

    @Override
    public MocapModifiers withEntityFilter(MocapEntityFilter filter) {
        return new PlaybackModifiers(this.playerName, this.playerSkin, this.transformations, this.playerAsEntity, this.timeModifiers, filter);
    }

    @Override
    public boolean areDefault() {
        return this.playerName == null && this.playerSkin.getSource() == MocapPlayerSkin.Source.DEFAULT && this.transformations.areDefault() && !this.playerAsEntity.isEnabled() && this.timeModifiers.areDefault() && this.entityFilter.isDefaultForPlayback();
    }

    @Override
    public MocapModifiers mergeWithParent(MocapModifiers parent) {
        return new PlaybackModifiers(this.playerName != null ? this.playerName : parent.getPlayerName(), this.playerSkin.mergeWithParent(parent.getPlayerSkin()), this.transformations.mergeWithParent(parent.getTransformations()), this.playerAsEntity.isEnabled() ? this.playerAsEntity : parent.getPlayerAsEntity(), this.timeModifiers.mergeWithParent(parent.getTimeModifiers()), !this.entityFilter.isDefaultForPlayback() ? this.entityFilter : parent.getEntityFilter());
    }

    @Override
    public void save(SceneFiles.Writer writer) {
        writer.addString("player_name", this.playerName);
        writer.addObject("player_skin", this.playerSkin.save());
        writer.addObject("transformations", this.transformations.save());
        writer.addObject("player_as_entity", this.playerAsEntity.save());
        writer.addObject("time", this.timeModifiers.save());
        writer.addString("entity_filter", this.entityFilter.save());
    }

    @Override
    public void list(CommandOutput out) {
        if (this.playerName == null) {
            out.sendSuccess("scenes.element_info.player_name.default", new Object[0]);
        } else {
            out.sendSuccess("scenes.element_info.player_name.custom", this.playerName);
        }
        switch (this.playerSkin.getSource()) {
            case DEFAULT: {
                out.sendSuccess("scenes.element_info.skin.default", new Object[0]);
                break;
            }
            case FROM_PLAYER: {
                out.sendSuccess("scenes.element_info.skin.profile", this.playerSkin.getPath());
                break;
            }
            case FROM_FILE: {
                out.sendSuccess("scenes.element_info.skin.file", this.playerSkin.getPath());
                break;
            }
            case FROM_MINESKIN: {
                out.sendSuccess("scenes.element_info.skin.mineskin", new Object[0]);
                class_5250 urlComponent = Utils.getOpenUrlComponent(this.playerSkin.getPath(), class_2561.method_43470((String)String.format("  (\u00a7n%s\u00a7r)", this.playerSkin.getPath())));
                out.sendSuccessComponent((class_2561)urlComponent);
            }
        }
        this.transformations.list(out);
        this.timeModifiers.list(out);
        if (!this.playerAsEntity.isEnabled()) {
            out.sendSuccess("scenes.element_info.player_as_entity.disabled", new Object[0]);
        } else {
            out.sendSuccess("scenes.element_info.player_as_entity.enabled", this.playerAsEntity.getRawEntityId());
        }
        if (this.entityFilter.isDefaultForPlayback()) {
            out.sendSuccess("scenes.element_info.entity_filter.disabled", new Object[0]);
        } else {
            out.sendSuccess("scenes.element_info.entity_filter.enabled", this.entityFilter.save());
        }
    }

    @Override
    @Nullable
    public MocapModifiers modify(FullCommandInfo info, String propertyName, int propertyNodePos) throws CommandSyntaxException {
        switch (propertyName) {
            case "time": {
                MocapTimeModifiers newTimeModifiers = this.timeModifiers.modify(info, propertyNodePos + 1);
                return newTimeModifiers != null ? this.withTimeModifiers(newTimeModifiers) : null;
            }
            case "transformations": {
                MocapTransformations newTransformations = this.transformations.modify(info, propertyNodePos + 1);
                return newTransformations != null ? this.withTransformations(newTransformations) : null;
            }
            case "player_name": {
                String playerNameType;
                String string = playerNameType = info.getNode(propertyNodePos + 1);
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"inherited", "blank", "set"}, (Object)string, n)) {
                    case 0 -> this.withPlayerName(null);
                    case 1 -> this.withPlayerName("");
                    case 2 -> this.withPlayerName(info.getString("player_name"));
                    default -> null;
                };
            }
            case "player_skin": {
                MocapPlayerSkin newPlayerSkin = info.getPlayerSkin();
                return newPlayerSkin != null ? this.withPlayerSkin(newPlayerSkin) : null;
            }
            case "player_as_entity": {
                String playerAsEntityMode = info.getNode(propertyNodePos + 1);
                if (playerAsEntityMode == null) {
                    return null;
                }
                if (playerAsEntityMode.equals("disabled")) {
                    return this.withPlayerAsEntity(PlayerAsEntity.DISABLED);
                }
                if (playerAsEntityMode.equals("enabled")) {
                    class_2520 tag;
                    String playerAsEntityId = class_7733.method_45609(info.ctx, (String)"entity").method_40237().method_29177().toString();
                    try {
                        tag = class_2212.method_9390(info.ctx, (String)"nbt");
                    }
                    catch (Exception e) {
                        tag = null;
                    }
                    class_2487 nbt = tag instanceof class_2487 ? (class_2487)tag : null;
                    return this.withPlayerAsEntity(new PlayerAsEntity(playerAsEntityId, nbt != null ? nbt.toString() : null));
                }
                return null;
            }
            case "entity_filter": {
                String filterMode = info.getNode(propertyNodePos + 1);
                if (filterMode == null) {
                    return null;
                }
                if (filterMode.equals("disabled")) {
                    return this.withEntityFilter(EntityFilter.FOR_PLAYBACK);
                }
                if (filterMode.equals("enabled")) {
                    String filterStr = info.getString("entity_filter");
                    EntityFilterInstance filterInstance = EntityFilterInstance.create(filterStr);
                    if (filterInstance == null) {
                        info.sendFailure("failure.entity_filter.failed_to_parse", new Object[0]);
                        return null;
                    }
                    return this.withEntityFilter(new EntityFilter(filterInstance));
                }
                return null;
            }
        }
        return null;
    }

    public static boolean checkIfProperPlayerName(CommandOutput out, @Nullable String name) {
        if (name == null) {
            return true;
        }
        if (name.length() > 16) {
            out.sendFailure("failure.improper_player_name", new Object[0]);
            out.sendFailure("failure.improper_player_name.too_long", new Object[0]);
            return false;
        }
        if (name.contains(" ")) {
            out.sendFailure("failure.improper_player_name", new Object[0]);
            out.sendFailure("failure.improper_player_name.contains_spaces", new Object[0]);
            return false;
        }
        return true;
    }
}

