/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerAsEntity;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class PlayerAsEntity
implements MocapPlayerAsEntity {
    public static final PlayerAsEntity DISABLED = new PlayerAsEntity(null, null);
    @Nullable
    private final String entityId;
    @Nullable
    public final String entityNbt;
    @Nullable
    private final class_1299<?> entityType;
    @Nullable
    private final class_2487 compoundTag;

    public PlayerAsEntity(@Nullable String entityId, @Nullable String entityNbt) {
        this.entityId = entityId;
        this.entityNbt = entityNbt;
        this.entityType = PlayerAsEntity.prepareEntityType(entityId, entityNbt);
        this.compoundTag = PlayerAsEntity.prepareCompoundTag(entityId, entityNbt);
    }

    public static PlayerAsEntity fromObject(@Nullable SceneFiles.Reader reader) {
        return reader != null ? new PlayerAsEntity(reader.readString("id"), reader.readString("nbt")) : DISABLED;
    }

    @Override
    public boolean isEnabled() {
        return this.entityId != null;
    }

    @Override
    @Nullable
    public class_2960 getEntityId() {
        return this.entityId != null ? class_2960.method_12829((String)this.entityId) : null;
    }

    @Override
    @Nullable
    public class_1299<?> getEntityType() {
        class_2960 id = this.getEntityId();
        if (id == null || !class_7923.field_41177.method_10250(id)) {
            return null;
        }
        class_6880.class_6883 entityTypeRef = class_7923.field_41177.method_10223(id).orElse(null);
        return entityTypeRef != null ? (class_1299)entityTypeRef.comp_349() : null;
    }

    @Override
    @Nullable
    public String getRawEntityId() {
        return this.entityId;
    }

    @Override
    @Nullable
    public String getNbt() {
        return this.entityNbt;
    }

    @Override
    @Nullable
    public SceneFiles.Writer save() {
        if (!this.isEnabled()) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addString("id", this.entityId);
        writer.addString("nbt", this.entityNbt);
        return writer;
    }

    @Override
    @Nullable
    public class_1297 createEntity(class_1937 level) {
        if (this.entityType == null && this.compoundTag == null) {
            return null;
        }
        class_11368 nbt = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)level.method_30349(), (class_2487)this.compoundTag);
        return this.compoundTag != null ? (class_1297)class_1299.method_5892((class_11368)nbt, (class_1937)level, (class_3730)class_3730.field_16462).orElse(null) : this.entityType.method_5883(level, class_3730.field_16462);
    }

    @Nullable
    private static class_1299<?> prepareEntityType(@Nullable String entityId, @Nullable String entityNbt) {
        if (entityId == null || entityNbt != null) {
            return null;
        }
        class_2960 entityRes = class_2960.method_60654((String)entityId);
        class_6880.class_6883 entityTypeRef = class_7923.field_41177.method_10223(entityRes).orElse(null);
        return entityTypeRef != null ? (class_1299)entityTypeRef.comp_349() : null;
    }

    @Nullable
    private static class_2487 prepareCompoundTag(@Nullable String entityId, @Nullable String entityNbt) {
        if (entityId == null || entityNbt == null) {
            return null;
        }
        try {
            class_2487 nbt = Utils.nbtFromString(entityNbt);
            nbt.method_10582("id", entityId);
            return nbt;
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }
}

