/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerSkin;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.utils.ProfileUtils;
import org.jetbrains.annotations.Nullable;

public class PlayerSkin
implements MocapPlayerSkin {
    public static final PlayerSkin DEFAULT = new PlayerSkin(MocapPlayerSkin.Source.DEFAULT, null);
    private static final String MINESKIN_URL_PREFIX1 = "minesk.in/";
    private static final String MINESKIN_URL_PREFIX2 = "mineskin.org/skins/";
    private static final String MINESKIN_API_URL = "https://api.mineskin.org/get/uuid/";
    private final MocapPlayerSkin.Source source;
    @Nullable
    private final String path;

    public PlayerSkin(MocapPlayerSkin.Source source, @Nullable String path) {
        this.source = source;
        this.path = path;
    }

    public static PlayerSkin fromObject(@Nullable SceneFiles.Reader reader) {
        return reader != null ? new PlayerSkin(reader.readEnum("skin_source", MocapPlayerSkin.Source.DEFAULT), reader.readString("skin_path")) : DEFAULT;
    }

    @Nullable
    public static PlayerSkin createVerified(CommandOutput out, MocapPlayerSkin.Source source, @Nullable String skinPath) {
        if (source == MocapPlayerSkin.Source.FROM_MINESKIN && skinPath != null && !PlayerSkin.verifyMineskinUrl(skinPath)) {
            out.sendFailure("failure.improper_mineskin_link", new Object[0]);
            return null;
        }
        return new PlayerSkin(source, skinPath);
    }

    private static boolean verifyMineskinUrl(String url) {
        if (url.startsWith("https://")) {
            url = url.substring(8);
        } else if (url.startsWith("http://")) {
            url = url.substring(7);
        }
        return url.startsWith(MINESKIN_URL_PREFIX1) || url.startsWith(MINESKIN_URL_PREFIX2);
    }

    @Override
    public MocapPlayerSkin.Source getSource() {
        return this.source;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public SceneFiles.Writer save() {
        if (this.source == MocapPlayerSkin.Source.DEFAULT) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addEnum("skin_source", this.source, MocapPlayerSkin.Source.DEFAULT);
        writer.addString("skin_path", this.path);
        return writer;
    }

    @Override
    public PropertyMap addSkinToPropertyMap(CommandInfo info, PropertyMap propertyMap) {
        if (this.path == null) {
            return propertyMap;
        }
        HashMultimap mutableMap = HashMultimap.create((Multimap)propertyMap);
        switch (this.source) {
            case FROM_PLAYER: {
                GameProfile tempProfile = ProfileUtils.getGameProfile(info.getServer(), this.path);
                PropertyMap tempPropertyMap = tempProfile.properties();
                if (!tempPropertyMap.containsKey((Object)"textures")) {
                    info.sendFailure("playback.start.warning.skin.profile", new Object[0]);
                    break;
                }
                if (mutableMap.containsKey((Object)"textures")) {
                    mutableMap.get((Object)"textures").clear();
                }
                mutableMap.putAll((Object)"textures", (Iterable)tempPropertyMap.get((Object)"textures"));
                break;
            }
            case FROM_FILE: {
                mutableMap.put((Object)"mocap:skin_from_file", (Object)new Property("mocap:skin_from_file", this.path));
                break;
            }
            case FROM_MINESKIN: {
                if (!((Boolean)Settings.ALLOW_MINESKIN_REQUESTS.val).booleanValue()) break;
                Property skinProperty = this.propertyFromMineskinURL(this.path);
                if (skinProperty == null) {
                    info.sendFailure("playback.start.warning.skin.mineskin", new Object[0]);
                    break;
                }
                if (mutableMap.containsKey((Object)"textures")) {
                    mutableMap.get((Object)"textures").clear();
                }
                mutableMap.put((Object)"textures", (Object)skinProperty);
            }
        }
        return new PropertyMap((Multimap)mutableMap);
    }

    @Override
    public MocapPlayerSkin mergeWithParent(MocapPlayerSkin parent) {
        return this.source != MocapPlayerSkin.Source.DEFAULT ? new PlayerSkin(this.source, this.path) : new PlayerSkin(parent.getSource(), parent.getPath());
    }

    @Nullable
    private Property propertyFromMineskinURL(String mineskinURL) {
        String mineskinID = mineskinURL.contains("/") ? mineskinURL.substring(mineskinURL.lastIndexOf(47) + 1) : mineskinURL;
        String mineskinApiURL = MINESKIN_API_URL + mineskinID;
        try {
            URL url = new URI(mineskinApiURL).toURL();
            URLConnection connection = url.openConnection();
            if (!(connection instanceof HttpsURLConnection)) {
                return null;
            }
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setUseCaches(false);
            httpsConnection.setRequestMethod("GET");
            Scanner scanner = new Scanner(httpsConnection.getInputStream());
            String text = scanner.useDelimiter("\\A").next();
            scanner.close();
            httpsConnection.disconnect();
            String value = text.split("\"value\":\"")[1].split("\"")[0];
            String signature = text.split("\"signature\":\"")[1].split("\"")[0];
            return new Property("textures", value, signature);
        }
        catch (Exception e) {
            return null;
        }
    }
}

