/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.mt1006.mocap.mocap.files.SceneFiles;
import org.jetbrains.annotations.Nullable;

public class Scale {
    public static final Scale NORMAL = new Scale(1.0, 1.0);
    @Nullable
    private static final class_2960 SCALE_ID = class_7923.field_41190.method_10221((Object)((class_1320)class_5134.field_47760.comp_349()));
    public final double playerScale;
    public final double sceneScale;
    public final double totalSceneScale;

    private Scale(double playerScale, double sceneScale, double totalSceneScale) {
        this.playerScale = playerScale;
        this.sceneScale = sceneScale;
        this.totalSceneScale = totalSceneScale;
    }

    private Scale(double playerScale, double sceneScale) {
        this(playerScale, sceneScale, sceneScale);
    }

    public static Scale fromObject(@Nullable SceneFiles.Reader reader) {
        return reader != null ? new Scale(reader.readDouble("player_scale", 1.0), reader.readDouble("scene_scale", 1.0)) : NORMAL;
    }

    public Scale ofPlayer(double scale) {
        return new Scale(scale, this.sceneScale);
    }

    public Scale ofScene(double scale) {
        return new Scale(this.playerScale, scale);
    }

    @Nullable
    public SceneFiles.Writer save() {
        if (this.isNormal()) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addDouble("player_scale", this.playerScale, 1.0);
        writer.addDouble("scene_scale", this.sceneScale, 1.0);
        return writer;
    }

    public boolean isNormal() {
        return this.playerScale == 1.0 && this.sceneScale == 1.0;
    }

    public boolean canScaleInt(class_243 startPos) {
        if (this.sceneScale == 1.0) {
            return true;
        }
        if (this.sceneScale != (double)((int)this.sceneScale)) {
            return false;
        }
        class_243 vec = (int)this.sceneScale % 2 == 0 ? startPos : startPos.method_1031(0.5, 0.0, 0.5);
        return vec.field_1352 == (double)((int)vec.field_1352) && vec.field_1351 == (double)((int)vec.field_1351) && vec.field_1350 == (double)((int)vec.field_1350);
    }

    public void applyToPlayer(class_1297 player) {
        this.applyToEntity(player, this.playerScale * this.totalSceneScale);
    }

    public void applyToEntity(class_1297 entity) {
        this.applyToEntity(entity, this.totalSceneScale);
    }

    private void applyToEntity(class_1297 entity, double scale) {
        if (scale == 1.0 || !(entity instanceof class_1309) || SCALE_ID == null) {
            return;
        }
        class_1322 modifier = new class_1322(SCALE_ID, scale - 1.0, class_1322.class_1323.field_6331);
        class_1324 instance = ((class_1309)entity).method_6127().method_45329(class_5134.field_47760);
        if (instance != null) {
            instance.method_26837(modifier);
        }
    }

    public class_243 applyToPoint(class_243 point, class_243 center) {
        if (this.sceneScale == 1.0) {
            return point;
        }
        return new class_243((point.field_1352 - center.field_1352) * this.sceneScale + center.field_1352, (point.field_1351 - center.field_1351) * this.sceneScale + center.field_1351, (point.field_1350 - center.field_1350) * this.sceneScale + center.field_1350);
    }
}

