/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import java.lang.runtime.SwitchBootstraps;
import net.minecraft.class_243;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapOffset;
import net.mt1006.mocap.api.v1.modifiers.MocapTransformationsConfig;
import net.mt1006.mocap.command.io.FullCommandInfo;
import net.mt1006.mocap.mocap.files.SceneFiles;
import org.jetbrains.annotations.Nullable;

public class TransformationsConfig
implements MocapTransformationsConfig {
    public static final TransformationsConfig DEFAULT = new TransformationsConfig(false, MocapTransformationsConfig.RecordingCenter.AUTO, SceneCenter.DEFAULT, MocapOffset.ZERO);
    public static final TransformationsConfig LEGACY = new TransformationsConfig(true, MocapTransformationsConfig.RecordingCenter.AUTO, SceneCenter.DEFAULT, MocapOffset.ZERO);
    private final boolean roundBlockPos;
    private final MocapTransformationsConfig.RecordingCenter recordingCenter;
    private final SceneCenter sceneCenter;
    private final MocapOffset centerOffset;

    public TransformationsConfig(boolean roundBlockPos, MocapTransformationsConfig.RecordingCenter recordingCenter, SceneCenter sceneCenter, MocapOffset centerOffset) {
        this.roundBlockPos = roundBlockPos;
        this.recordingCenter = recordingCenter;
        this.sceneCenter = sceneCenter;
        this.centerOffset = centerOffset;
    }

    public TransformationsConfig(SceneFiles.Reader reader) {
        this.roundBlockPos = reader.readBoolean("round_block_pos", false);
        this.recordingCenter = reader.readEnum("recording_center", MocapTransformationsConfig.RecordingCenter.AUTO);
        this.sceneCenter = SceneCenter.fromObject(reader.readObject("scene_center"));
        this.centerOffset = MocapOffset.fromVec3(reader.readVec3("center_offset"));
    }

    public static TransformationsConfig fromObject(@Nullable SceneFiles.Reader reader) {
        return reader != null ? new TransformationsConfig(reader) : DEFAULT;
    }

    @Override
    public boolean getRoundBlockPos() {
        return this.roundBlockPos;
    }

    @Override
    public TransformationsConfig withRoundBlockPos(boolean roundBlockPos) {
        return new TransformationsConfig(roundBlockPos, this.recordingCenter, this.sceneCenter, this.centerOffset);
    }

    @Override
    public MocapTransformationsConfig.RecordingCenter getRecordingCenter() {
        return this.recordingCenter;
    }

    @Override
    public TransformationsConfig withRecordingCenter(MocapTransformationsConfig.RecordingCenter center) {
        return new TransformationsConfig(this.roundBlockPos, center, this.sceneCenter, this.centerOffset);
    }

    @Override
    public MocapTransformationsConfig.SceneCenterType getSceneCenterType() {
        return this.sceneCenter.type;
    }

    @Override
    @Nullable
    public String getSceneCenterSpecificStr() {
        return this.sceneCenter.specificStr;
    }

    @Override
    public TransformationsConfig withSceneCenter(MocapTransformationsConfig.SceneCenterType center, @Nullable String specificStr) {
        if (center != MocapTransformationsConfig.SceneCenterType.COMMON_SPECIFIC) {
            specificStr = null;
        }
        return new TransformationsConfig(this.roundBlockPos, this.recordingCenter, new SceneCenter(center, specificStr), this.centerOffset);
    }

    @Override
    public MocapOffset getCenterOffset() {
        return this.centerOffset;
    }

    @Override
    public TransformationsConfig withCenterOffset(MocapOffset offset) {
        return new TransformationsConfig(this.roundBlockPos, this.recordingCenter, this.sceneCenter, offset);
    }

    @Override
    public SceneCenter getSceneCenter() {
        return this.sceneCenter;
    }

    @Override
    public boolean isDefault() {
        return !this.roundBlockPos && this.recordingCenter == MocapTransformationsConfig.RecordingCenter.AUTO && this.centerOffset.isZero && this.sceneCenter.type == MocapTransformationsConfig.SceneCenterType.COMMON_FIRST;
    }

    @Override
    @Nullable
    public SceneFiles.Writer save() {
        if (this.isDefault()) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addBoolean("round_block_pos", this.roundBlockPos, false);
        writer.addEnum("recording_center", this.recordingCenter, MocapTransformationsConfig.RecordingCenter.AUTO);
        writer.addObject("scene_center", this.sceneCenter.save());
        writer.addVec3("center_offset", this.centerOffset.save());
        return writer;
    }

    @Override
    public void list(CommandOutput out) {
        if (this.isDefault()) {
            out.sendSuccess("scenes.element_info.transformations.default_config", new Object[0]);
            return;
        }
        out.sendSuccess("scenes.element_info.transformations.round_block_pos." + this.roundBlockPos, new Object[0]);
        out.sendSuccess("scenes.element_info.transformations.recording_center", this.recordingCenter.name());
        out.sendSuccess("scenes.element_info.transformations.scene_center", this.sceneCenter.toString());
        out.sendSuccess("scenes.element_info.transformations.center_offset", this.centerOffset.field_1352, this.centerOffset.field_1351, this.centerOffset.field_1350);
    }

    @Override
    @Nullable
    public MocapTransformationsConfig modify(FullCommandInfo info, int propertyNodePos) {
        String string = info.getNode(propertyNodePos);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"round_block_pos", "recording_center", "scene_center", "center_offset"}, (Object)string, n)) {
            case 0: {
                return this.withRoundBlockPos(info.getBool("round"));
            }
            case 1: {
                String centerPointStr = info.getNode(propertyNodePos + 1);
                return centerPointStr != null ? this.withRecordingCenter(MocapTransformationsConfig.RecordingCenter.valueOf(centerPointStr.toUpperCase())) : null;
            }
            case 2: {
                String sceneCenterStr = info.getNode(propertyNodePos + 1);
                if (sceneCenterStr == null) {
                    return null;
                }
                MocapTransformationsConfig.SceneCenterType centerType = MocapTransformationsConfig.SceneCenterType.valueOf(sceneCenterStr.toUpperCase());
                String specificStr = centerType == MocapTransformationsConfig.SceneCenterType.COMMON_SPECIFIC ? info.getString("specific_scene_element") : null;
                return this.withSceneCenter(centerType, specificStr);
            }
            case 3: {
                return this.withCenterOffset(new class_243(info.getDouble("offset_x"), info.getDouble("offset_y"), info.getDouble("offset_z")));
            }
        }
        return null;
    }

    public static class SceneCenter {
        public static final SceneCenter DEFAULT = new SceneCenter(MocapTransformationsConfig.SceneCenterType.COMMON_FIRST, null);
        public final MocapTransformationsConfig.SceneCenterType type;
        @Nullable
        public final String specificStr;

        public SceneCenter(MocapTransformationsConfig.SceneCenterType type, @Nullable String specificStr) {
            this.type = type;
            this.specificStr = specificStr;
        }

        public SceneCenter(SceneFiles.Reader reader) {
            this.type = reader.readEnum("type", MocapTransformationsConfig.SceneCenterType.COMMON_FIRST);
            this.specificStr = this.type == MocapTransformationsConfig.SceneCenterType.COMMON_SPECIFIC ? reader.readString("specific_str") : null;
        }

        public static SceneCenter fromObject(@Nullable SceneFiles.Reader reader) {
            return reader != null ? new SceneCenter(reader) : DEFAULT;
        }

        @Nullable
        public SceneFiles.Writer save() {
            if (this.type == MocapTransformationsConfig.SceneCenterType.COMMON_FIRST) {
                return null;
            }
            SceneFiles.Writer writer = new SceneFiles.Writer();
            writer.addEnum("type", this.type, MocapTransformationsConfig.SceneCenterType.COMMON_FIRST);
            if (this.type == MocapTransformationsConfig.SceneCenterType.COMMON_SPECIFIC) {
                writer.addString("specific_str", this.specificStr);
            }
            return writer;
        }

        public String toString() {
            return this.type == MocapTransformationsConfig.SceneCenterType.COMMON_SPECIFIC ? String.format("%s [%s]", this.type.name(), this.specificStr) : this.type.name();
        }
    }
}

