/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playable;

import net.mt1006.mocap.api.v1.controller.MocapPlaybackRoot;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.controller.playable.MocapActiveRecording;
import net.mt1006.mocap.api.v1.controller.playable.MocapRecordingFile;
import net.mt1006.mocap.api.v1.extension.MocapActiveRecordingActions;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.playing.PlaybackDataManager;
import net.mt1006.mocap.mocap.playing.PlaybackManager;
import net.mt1006.mocap.mocap.playing.playable.Playable;
import net.mt1006.mocap.mocap.playing.playable.RecordingFile;
import net.mt1006.mocap.mocap.playing.playback.Playback;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.playing.playback.RecordingPlayback;
import net.mt1006.mocap.mocap.recording.RecordingContext;
import net.mt1006.mocap.mocap.recording.RecordingManager;
import org.jetbrains.annotations.Nullable;

public class ActiveRecording
extends Playable
implements MocapActiveRecording {
    public final String id;
    public final RecordingContext ctx;

    private ActiveRecording(String id, RecordingContext ctx) {
        this.id = id;
        this.ctx = ctx;
    }

    public static ActiveRecording get(RecordingContext ctx) {
        return new ActiveRecording(ctx.id.str, ctx);
    }

    @Nullable
    public static ActiveRecording get(CommandInfo info, String name) {
        RecordingContext ctx = RecordingManager.resolveSingle(info, name);
        return ctx != null ? new ActiveRecording(name, ctx) : null;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean stop(CommandOutput out) {
        return this.ctx != null && RecordingManager.stopSingle(out, this.ctx, null);
    }

    @Override
    public boolean discard(CommandOutput out) {
        return this.ctx != null && RecordingManager.discardSingle(out, this.ctx);
    }

    @Override
    @Nullable
    public MocapRecordingFile save(CommandOutput out, String name) {
        boolean success = this.ctx != null && RecordingManager.saveSingle(out, this.ctx, name, false);
        return success ? RecordingFile.get(out, name) : null;
    }

    @Override
    public MocapActiveRecordingActions getActions() {
        return this.ctx;
    }

    @Override
    public boolean isValid() {
        return !this.ctx.isRemoved();
    }

    @Override
    public RecordingData getRecordingData() {
        return this.ctx.data;
    }

    @Override
    @Nullable
    public MocapPlaybackRoot startPlayback(CommandInfo info, MocapModifiers modifiers, MocapPlaybackConfig config, boolean isHidden) {
        RecordingPlayback playback;
        if (config.getStartAsRecorded() && modifiers.getPlayerName() == null) {
            modifiers = modifiers.withPlayerName(this.ctx.recordedPlayer.method_5477().getString());
        }
        return (playback = RecordingPlayback.start(info, true, this.ctx.data, config, modifiers, null)) != null ? PlaybackManager.addPlayback(this, playback, isHidden) : null;
    }

    @Override
    @Nullable
    public Playback startAsSubscene(CommandInfo info, MocapModifiers modifiers, MocapPlaybackConfig config, PlaybackDataManager dataManager, PositionTransformer parentTransformer) {
        return RecordingPlayback.start(info, false, this.ctx.data, config, modifiers, parentTransformer);
    }
}

