/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7828;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.extension.MocapPositionTransformer;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.utils.FakePlayer;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class ActionContext
implements MocapActionContext {
    private final MocapRecordingData recordingData;
    private final class_3222 owner;
    private final class_3324 packetTargets;
    private final MocapActionContext.EntityData mainEntityData;
    private final Map<Integer, MocapActionContext.EntityData> entityDataMap = new HashMap<Integer, MocapActionContext.EntityData>();
    private final class_3218 level;
    private final MocapPlaybackConfig config;
    private final MocapModifiers modifiers;
    @Nullable
    private final FakePlayer ghostPlayer;
    private final PositionTransformer transformer;
    private boolean mainEntityRemoved = false;
    @Nullable
    private MocapActionContext.EntityData currentEntityData = null;
    private class_1297 entity;
    private class_243 position;
    private int repeatCounter = 0;

    public ActionContext(MocapRecordingData recordingData, class_3222 owner, class_3324 packetTargets, class_1297 entity, MocapPlaybackConfig config, MocapModifiers modifiers, @Nullable FakePlayer ghostPlayer, PositionTransformer transformer) {
        if (!(entity.method_73183() instanceof class_3218)) {
            throw new RuntimeException("Failed to get ServerLevel for ActionContext!");
        }
        this.recordingData = recordingData;
        this.owner = owner;
        this.packetTargets = packetTargets;
        this.mainEntityData = new MocapActionContext.EntityData(entity, recordingData.getStartPos());
        this.level = (class_3218)entity.method_73183();
        this.config = config;
        this.modifiers = modifiers;
        this.ghostPlayer = ghostPlayer;
        this.transformer = transformer;
        this.setMainContextEntity();
    }

    @Override
    public MocapRecordingData getRecordingData() {
        return this.recordingData;
    }

    @Override
    public class_1297 getEntity() {
        return this.entity;
    }

    @Override
    public class_3218 getLevel() {
        return this.level;
    }

    @Override
    public MocapPlaybackConfig getConfig() {
        return this.config;
    }

    @Override
    public MocapModifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public MocapPositionTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public class_1297 getMainEntity() {
        return this.mainEntityData.entity;
    }

    @Override
    @Nullable
    public class_3222 getDummyPlayer() {
        return this.ghostPlayer;
    }

    @Override
    @Nullable
    public class_3222 getRealOrDummyPlayer() {
        return this.entity instanceof class_3222 ? (class_3222)this.entity : this.ghostPlayer;
    }

    @Nullable
    public class_3222 getLivingEntityOrDummyPlayer() {
        return this.entity instanceof class_3222 ? (class_3222)this.entity : this.ghostPlayer;
    }

    @Override
    public void setMainContextEntity() {
        this.setContextEntity(this.mainEntityData);
    }

    @Override
    public boolean setContextEntity(int id) {
        MocapActionContext.EntityData data = this.entityDataMap.get(id);
        if (data == null) {
            return false;
        }
        this.setContextEntity(data);
        return true;
    }

    private void setContextEntity(MocapActionContext.EntityData data) {
        if (this.currentEntityData != null) {
            this.currentEntityData.lastPosition = this.position;
        }
        this.currentEntityData = data;
        this.entity = data.entity;
        this.position = data.lastPosition;
    }

    @Override
    public void broadcast(class_2596<?> packet) {
        this.packetTargets.method_14581(packet);
    }

    @Override
    public void fluentMovement(Supplier<class_2596<?>> packetSupplier) {
        double fluentMovements = (Double)Settings.FLUENT_MOVEMENTS.val;
        if (fluentMovements == 0.0) {
            return;
        }
        class_2596<?> packet = packetSupplier.get();
        if (fluentMovements > 0.0) {
            class_243 pos = this.entity.method_73189();
            double maxDistSqr = fluentMovements * fluentMovements;
            for (class_3222 player : this.packetTargets.method_14571()) {
                if (player.method_5707(pos) > maxDistSqr) continue;
                player.field_13987.method_14364(packet);
            }
        } else {
            this.packetTargets.method_14581(packet);
        }
    }

    public void removeAdditionalEntities() {
        this.entityDataMap.values().forEach(data -> this.removeEntity(data.entity, this.level));
        this.entityDataMap.clear();
    }

    public void removeMainEntity() {
        FakePlayer playerToRemove;
        if (this.mainEntityRemoved) {
            return;
        }
        this.mainEntityRemoved = true;
        if (this.entity instanceof class_1657) {
            if (!(this.entity instanceof FakePlayer)) {
                Utils.sendMessage((class_1657)this.owner, "error.failed_to_remove_fake_player", new Object[0]);
                MocapMod.LOGGER.error("Failed to remove fake player!");
                return;
            }
            playerToRemove = (FakePlayer)this.entity;
        } else {
            this.removeEntity(this.entity, this.level);
            if (this.ghostPlayer == null) {
                return;
            }
            playerToRemove = this.ghostPlayer;
        }
        UUID uuid = playerToRemove.method_5667();
        if (PlayerConnectionEvent.nocolPlayers.contains(uuid)) {
            for (class_3222 player : PlayerConnectionEvent.players) {
                MocapPacketS2C.sendNocolPlayerRemove(player, uuid);
                PlayerConnectionEvent.removeNocolPlayer(uuid);
            }
        }
        if (playerToRemove != this.ghostPlayer) {
            this.broadcast((class_2596<?>)new class_7828(List.of(uuid)));
        }
        playerToRemove.method_5650(class_1297.class_5529.field_26998);
        playerToRemove.method_14236().method_12881();
    }

    @Override
    public class_243 getPosition() {
        return this.position;
    }

    @Override
    public void changePosition(class_243 newPos, float rotY, float rotX, boolean transformRot) {
        this.position = newPos;
        class_243 finPos = this.transformer.transformPos(this.position);
        float finRotY = transformRot ? this.transformer.transformRotation(rotY) : rotY;
        this.entity.method_60949(finPos, finRotY, rotX);
        if (this.ghostPlayer != null && this.entity == this.mainEntityData.entity) {
            this.ghostPlayer.method_60949(finPos, finRotY, rotX);
        }
    }

    @Override
    public void addEntity(int id, class_1297 entity, class_243 position) {
        this.entityDataMap.put(id, new MocapActionContext.EntityData(entity, position));
    }

    @Override
    @Nullable
    public MocapActionContext.EntityData getEntityData(int id) {
        return this.entityDataMap.get(id);
    }

    @Override
    public boolean hasEntity(int id) {
        return this.entityDataMap.containsKey(id);
    }

    @Override
    public void incrementRepeatCounter() {
        ++this.repeatCounter;
    }

    @Override
    public boolean shouldStopRepeat(int iter) {
        if (this.repeatCounter == iter) {
            this.repeatCounter = 0;
            return true;
        }
        return false;
    }

    private void removeEntity(class_1297 entity, class_3218 level) {
        switch (this.config.getEntitiesAfterPlayback()) {
            case REMOVE: {
                entity.method_5650(class_1297.class_5529.field_26998);
            }
            case KILL: {
                entity.field_6008 = 0;
                if (entity instanceof FakePlayer) {
                    ((FakePlayer)entity).fakeKill();
                    break;
                }
                entity.method_5768(level);
                break;
            }
            case LEFT_UNTOUCHED: {
                break;
            }
            case RELEASE_AS_NORMAL: {
                entity.method_5875(false);
                entity.method_5684(false);
                entity.method_5738("mocap_entity");
                if (!(entity instanceof class_1308)) break;
                ((class_1308)entity).method_5977(false);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.config.getEntitiesAfterPlayback()));
            }
        }
    }
}

