/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.v1.controller.config.MocapDimensionSource;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerSkin;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.actions.Die;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.playing.playback.Playback;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.playing.playback.PreExecuteContext;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.utils.EntityData;
import net.mt1006.mocap.utils.FakePlayer;
import net.mt1006.mocap.utils.ProfileUtils;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class RecordingPlayback
extends Playback {
    private final RecordingData recording;
    private final ActionContext ctx;
    private int pos = 0;

    private RecordingPlayback(boolean isRoot, @Nullable class_3222 owner, MocapPlaybackConfig config, MocapModifiers modifiers, RecordingData recording, ActionContext ctx) {
        super(isRoot, owner, config, modifiers);
        this.recording = recording;
        this.ctx = ctx;
    }

    @Nullable
    public static RecordingPlayback start(CommandInfo info, boolean isRoot, RecordingData recording, MocapPlaybackConfig config, MocapModifiers modifiers, @Nullable PositionTransformer parentTransformer) {
        Object entity;
        boolean delayedStart;
        if (recording == null) {
            throw new RuntimeException("Provided recording data is null!");
        }
        GameProfile oldProfile = RecordingPlayback.getGameProfile(info, modifiers.getPlayerName(), recording.playerName, config.getStartAsRecorded());
        if (oldProfile == null) {
            info.sendFailure("playback.start.error", new Object[0]);
            info.sendFailure("playback.start.error.profile", new Object[0]);
            return null;
        }
        GameProfile newProfile = RecordingPlayback.createNewProfile(info, oldProfile, modifiers.getPlayerSkin());
        class_3218 level = RecordingPlayback.getLevel(info, recording, config.getDimensionSource());
        class_3324 packetTargets = info.getServer().method_3760();
        FakePlayer ghost = null;
        class_243 center = modifiers.getTransformations().calculateCenter(recording.startPos);
        PositionTransformer transformer = new PositionTransformer(modifiers.getTransformations(), parentTransformer, center);
        boolean bl = delayedStart = modifiers.getTimeModifiers().getStartDelay().ticks != 0;
        if (!modifiers.getPlayerAsEntity().isEnabled()) {
            FakePlayer fakePlayer = new FakePlayer(level, newProfile, config.getInvulnerablePlayback());
            entity = fakePlayer;
            fakePlayer.field_13974.method_30118((Boolean)Settings.USE_CREATIVE_GAME_MODE.val != false ? class_1934.field_9220 : class_1934.field_9215);
            recording.initEntityPosition((class_1297)fakePlayer, transformer, delayedStart);
            modifiers.getTransformations().applyScaleToPlayer((class_1297)fakePlayer);
            packetTargets.method_14581((class_2596)new class_2703(class_2703.class_5893.field_29136, (class_3222)fakePlayer));
            level.method_18213((class_3222)fakePlayer);
            recording.preExecute(new PreExecuteContext(recording, (class_1297)entity, level, config, modifiers, transformer));
            EntityData.PLAYER_SKIN_PARTS.set((class_1297)fakePlayer, (byte)127);
            if (!config.getCanPushEntities()) {
                for (class_3222 player : PlayerConnectionEvent.players) {
                    MocapPacketS2C.sendNocolPlayerAdd(player, fakePlayer.method_5667());
                    PlayerConnectionEvent.addNocolPlayer(fakePlayer.method_5667());
                }
            }
        } else {
            entity = modifiers.getPlayerAsEntity().createEntity((class_1937)level);
            if (entity == null) {
                info.sendFailure("playback.start.warning.unknown_entity", modifiers.getPlayerAsEntity().getRawEntityId());
                return null;
            }
            recording.initEntityPosition((class_1297)entity, transformer, delayedStart);
            entity.method_18800(0.0, 0.0, 0.0);
            entity.method_5684(config.getInvulnerablePlayback());
            entity.method_5875(true);
            if (entity instanceof class_1308) {
                ((class_1308)entity).method_5977(true);
            }
            modifiers.getTransformations().applyScaleToPlayer((class_1297)entity);
            level.method_8649(entity);
            recording.preExecute(new PreExecuteContext(recording, (class_1297)entity, level, config, modifiers, transformer));
            if (((Boolean)Settings.ALLOW_GHOSTS.val).booleanValue()) {
                ghost = new FakePlayer(level, newProfile, config.getInvulnerablePlayback());
                ghost.field_13974.method_30118((Boolean)Settings.USE_CREATIVE_GAME_MODE.val != false ? class_1934.field_9220 : class_1934.field_9215);
                recording.initEntityPosition((class_1297)ghost, transformer, delayedStart);
                level.method_18213((class_3222)ghost);
            }
        }
        ActionContext ctx = new ActionContext(recording, info.getSourcePlayer(), packetTargets, (class_1297)entity, config, modifiers, ghost, transformer);
        RecordingPlayback playback = new RecordingPlayback(isRoot, info.getSourcePlayer(), config, modifiers, recording, ctx);
        if (entity instanceof FakePlayer) {
            ((FakePlayer)((Object)entity)).playback = playback;
        } else if (ghost != null) {
            ghost.playback = playback;
        }
        return playback;
    }

    private static class_3218 getLevel(CommandInfo info, RecordingData recording, MocapDimensionSource dimensionSource) {
        if (recording.dimensionId == null) {
            return switch (dimensionSource) {
                default -> throw new MatchException(null, null);
                case MocapDimensionSource.ASSIGNED_OR_CURRENT, MocapDimensionSource.CURRENT -> info.getLevel();
                case MocapDimensionSource.ASSIGNED_OR_OVERWORLD, MocapDimensionSource.OVERWORLD -> info.getServer().method_30002();
            };
        }
        return switch (dimensionSource) {
            default -> throw new MatchException(null, null);
            case MocapDimensionSource.ASSIGNED_OR_CURRENT, MocapDimensionSource.ASSIGNED_OR_OVERWORLD -> info.getServer().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)recording.dimensionId));
            case MocapDimensionSource.CURRENT -> info.getLevel();
            case MocapDimensionSource.OVERWORLD -> info.getServer().method_30002();
        };
    }

    @Nullable
    private static GameProfile getGameProfile(CommandInfo info, @Nullable String profileName, @Nullable String recordedName, boolean startAsRecorded) {
        class_1297 entity = info.getSourceEntity();
        class_3324 playerList = info.getServer().method_3760();
        if (profileName == null) {
            profileName = startAsRecorded && recordedName != null ? recordedName : (entity instanceof class_3222 ? ((class_3222)entity).method_7334().name() : (!playerList.method_14571().isEmpty() ? ((class_3222)playerList.method_14571().get(0)).method_7334().name() : "Player"));
        }
        return ProfileUtils.getGameProfile(info.getServer(), profileName);
    }

    private static GameProfile createNewProfile(CommandInfo info, GameProfile oldProfile, MocapPlayerSkin playerSkin) {
        PropertyMap newPropertyMap = playerSkin.addSkinToPropertyMap(info, oldProfile.properties());
        return new GameProfile(UUID.randomUUID(), oldProfile.name(), newPropertyMap);
    }

    @Override
    public void tick() {
        if (this.finished) {
            return;
        }
        if (this.shouldExecuteTick()) {
            if (this.waitOnEnd != 0) {
                if (this.waitOnEnd == 1) {
                    this.finished = true;
                }
                --this.waitOnEnd;
            } else {
                int startDelay = this.modifiers.getTimeModifiers().getStartDelay().ticks;
                int waitOnStart = this.modifiers.getTimeModifiers().getWaitOnStart().ticks;
                if (startDelay == this.tickCounter) {
                    boolean delayedStart;
                    boolean bl = delayedStart = this.modifiers.getTimeModifiers().getStartDelay().ticks != 0;
                    if (delayedStart) {
                        this.recording.initEntityPosition(this.ctx.getEntity(), this.ctx.getTransformer(), false);
                    }
                    this.recording.firstExecute(this.ctx.getEntity());
                    this.tickInitialActions();
                }
                if (startDelay + waitOnStart <= this.tickCounter) {
                    this.tickActions();
                }
            }
            ++this.tickCounter;
        }
        if (this.finished && this.modifiers.getTimeModifiers().getLoop()) {
            this.loop();
        } else if (this.shouldSelfStop()) {
            this.stop();
        }
    }

    private void tickInitialActions() {
        MocapAction.Result result;
        int tempPos = 0;
        block5: while (true) {
            result = this.recording.executeAction(this.ctx, this.config, true, tempPos++);
            switch (result) {
                case OK: 
                case IGNORED: {
                    continue block5;
                }
                case NEXT_TICK: 
                case REPEAT_TICK: 
                case END: {
                    return;
                }
                case ERROR: {
                    Utils.sendMessage((class_1657)this.owner, "error.playback_error", new Object[0]);
                    MocapMod.LOGGER.error("Something went wrong during initial tick!");
                    this.finished = true;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)result));
    }

    private void tickActions() {
        MocapAction.Result result;
        block7: while (true) {
            result = this.recording.executeAction(this.ctx, this.config, false, this.pos++);
            switch (result) {
                case OK: 
                case IGNORED: {
                    continue block7;
                }
                case NEXT_TICK: {
                    return;
                }
                case REPEAT_TICK: {
                    --this.pos;
                    return;
                }
                case END: {
                    if (this.recording.endsWithDeath) {
                        Die.INSTANCE.execute(this.ctx);
                    }
                    this.finishOrWaitOnEnd();
                    return;
                }
                case ERROR: {
                    Utils.sendMessage((class_1657)this.owner, "error.playback_error", new Object[0]);
                    MocapMod.LOGGER.error("Something went wrong during playback!");
                    this.finished = true;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)result));
    }

    @Override
    public void stop() {
        if (!this.stopped) {
            this.ctx.removeMainEntity();
            this.ctx.removeAdditionalEntities();
            this.finished = true;
            this.stopped = true;
        }
    }

    @Override
    protected void loop() {
        boolean delayedStart = this.modifiers.getTimeModifiers().getStartDelay().ticks != 0;
        this.recording.initEntityPosition(this.ctx.getEntity(), this.ctx.getTransformer(), delayedStart);
        this.ctx.removeAdditionalEntities();
        this.pos = 0;
        this.tickCounter = 0;
        this.finished = false;
    }
}

