/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.controller.playable.MocapActiveRecording;
import net.mt1006.mocap.api.v1.controller.playable.MocapPlayable;
import net.mt1006.mocap.api.v1.controller.playable.MocapRecordingFile;
import net.mt1006.mocap.api.v1.controller.playable.MocapSceneElement;
import net.mt1006.mocap.api.v1.controller.playable.MocapSceneFile;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapTransformations;
import net.mt1006.mocap.api.v1.modifiers.MocapTransformationsConfig;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.playing.PlaybackDataManager;
import net.mt1006.mocap.mocap.playing.modifiers.TransformationsConfig;
import net.mt1006.mocap.mocap.playing.playback.Playback;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import org.jetbrains.annotations.Nullable;

public class ScenePlayback
extends Playback {
    private final List<Playback> subscenes;

    private ScenePlayback(boolean isRoot, @Nullable class_3222 owner, MocapPlaybackConfig config, MocapModifiers modifiers, List<Playback> subscenes) {
        super(isRoot, owner, config, modifiers);
        this.subscenes = subscenes;
    }

    @Nullable
    public static ScenePlayback start(CommandInfo info, boolean isRoot, PlaybackDataManager dataManager, @Nullable SceneData sceneData, MocapPlaybackConfig config, MocapModifiers modifiers, @Nullable PositionTransformer parentTransformer) {
        if (sceneData == null) {
            return null;
        }
        if (sceneData.elements.isEmpty() && isRoot) {
            info.sendFailureWithTip("playback.start.error.empty_scene", new Object[0]);
            return null;
        }
        PositionTransformer transformer = ScenePlayback.createPosTransformer(info, modifiers.getTransformations(), parentTransformer, sceneData, dataManager);
        if (transformer == null) {
            return null;
        }
        ArrayList<Playback> subscenes = new ArrayList<Playback>();
        for (MocapSceneElement element : sceneData.elements) {
            MocapPlayable playable = element.getPlayable(info);
            if (playable == null) {
                return null;
            }
            MocapModifiers subsceneModifiers = element.getModifiers().mergeWithParent(modifiers);
            Playback playback = playable.startAsSubscene(info, subsceneModifiers, config, dataManager, transformer);
            if (playback == null) {
                return null;
            }
            subscenes.add(playback);
        }
        return new ScenePlayback(isRoot, info.getSourcePlayer(), config, modifiers, subscenes);
    }

    @Nullable
    private static class_243 getSceneStartPos(CommandInfo info, TransformationsConfig.SceneCenter centers, SceneData sceneData, PlaybackDataManager dataManager) {
        MocapSceneElement element;
        MocapTransformationsConfig.SceneCenterType centerType = centers.type;
        if (centerType == MocapTransformationsConfig.SceneCenterType.COMMON_SPECIFIC && centers.specificStr == null) {
            centerType = MocapTransformationsConfig.SceneCenterType.COMMON_FIRST;
        }
        switch (centerType) {
            case COMMON_FIRST: {
                MocapSceneElement mocapSceneElement = sceneData.elements.get(0);
                break;
            }
            case COMMON_LAST: {
                MocapSceneElement mocapSceneElement = sceneData.elements.get(sceneData.elements.size() - 1);
                break;
            }
            case COMMON_SPECIFIC: {
                MocapSceneElement mocapSceneElement = SceneData.loadSubscene(info, sceneData, CommandUtils.splitPosStr(centers.specificStr));
                break;
            }
            default: {
                MocapSceneElement mocapSceneElement = element = null;
            }
        }
        if (element == null) {
            return null;
        }
        MocapPlayable mocapPlayable = element.getPlayable(info);
        int n = 0;
        class_243 subsceneStartPos = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MocapSceneFile.class, MocapRecordingFile.class, MocapActiveRecording.class}, (Object)mocapPlayable, n)) {
            case 0 -> {
                MocapSceneFile sceneFile = (MocapSceneFile)mocapPlayable;
                yield ScenePlayback.getSceneStartPos(info, element.getModifiers().getTransformations().getConfig().getSceneCenter(), dataManager.getScene(sceneFile), dataManager);
            }
            case 1 -> {
                MocapRecordingFile recordingFile = (MocapRecordingFile)mocapPlayable;
                yield dataManager.getRecording((MocapRecordingFile)recordingFile).startPos;
            }
            case 2 -> {
                MocapActiveRecording activeRecording = (MocapActiveRecording)mocapPlayable;
                yield activeRecording.getRecordingData().startPos;
            }
            case -1 -> throw new NullPointerException("Playable is null");
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(element.getPlayable(info)));
        };
        return element.getModifiers().getTransformations().calculateCenter(subsceneStartPos);
    }

    @Nullable
    private static PositionTransformer createPosTransformer(CommandInfo info, MocapTransformations transformations, @Nullable PositionTransformer parent, SceneData sceneData, PlaybackDataManager dataManager) {
        if (parent != null && transformations.areDefault()) {
            return parent;
        }
        TransformationsConfig.SceneCenter center = transformations.getConfig().getSceneCenter();
        if (center.type == MocapTransformationsConfig.SceneCenterType.INDIVIDUAL || sceneData.elements.isEmpty()) {
            return new PositionTransformer(transformations, parent, null);
        }
        class_243 sceneStartPos = ScenePlayback.getSceneStartPos(info, center, sceneData, dataManager);
        if (sceneStartPos == null) {
            return null;
        }
        return new PositionTransformer(transformations, parent, sceneStartPos);
    }

    @Override
    public void tick() {
        if (this.finished) {
            return;
        }
        if (this.shouldExecuteTick()) {
            if (this.waitOnEnd != 0) {
                if (this.waitOnEnd == 1) {
                    this.finished = true;
                }
                --this.waitOnEnd;
            } else {
                boolean subscenesInactive = true;
                boolean subscenesStopped = true;
                for (Playback scene : this.subscenes) {
                    scene.tick();
                    if (scene.isActive()) {
                        subscenesInactive = false;
                    }
                    if (scene.stopped) continue;
                    subscenesStopped = false;
                }
                if (subscenesInactive) {
                    this.finishOrWaitOnEnd();
                }
                if (subscenesStopped) {
                    this.stop();
                }
            }
            ++this.tickCounter;
        }
        if (this.finished && this.modifiers.getTimeModifiers().getLoop()) {
            this.loop();
        } else if (this.shouldSelfStop()) {
            this.stop();
        }
    }

    @Override
    public void stop() {
        if (!this.stopped) {
            this.subscenes.forEach(Playback::stop);
            this.finished = true;
            this.stopped = true;
        }
    }

    @Override
    protected void loop() {
        this.subscenes.forEach(Playback::loop);
        this.tickCounter = 0;
        this.finished = false;
    }
}

