/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.skins;

import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_12079;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketC2S;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class CustomClientSkinManager {
    private static final int MAX_CLIENT_CACHE_SIZE = 4096;
    private static final String SKIN_RES_PREFIX = "custom_skin/";
    private static final String SLIM_SKIN_RES_PREFIX = "custom_skin/slim/";
    private static final ConcurrentMap<String, Boolean> skinCache = new ConcurrentHashMap<String, Boolean>();
    private static boolean clientWarned = false;

    @Nullable
    public static class_12079.class_12081 get(@Nullable String name) {
        if (name == null) {
            return null;
        }
        Boolean accessible = (Boolean)skinCache.get(name);
        if (accessible == null) {
            CustomClientSkinManager.loadClientSkin(name);
            return null;
        }
        if (!accessible.booleanValue()) {
            return null;
        }
        class_2960 id = CustomClientSkinManager.resFromName(name);
        return new class_12079.class_10726(id, id);
    }

    public static void loadClientSkin(String name) {
        if (skinCache.size() > 4096) {
            if (clientWarned) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            Utils.sendMessage((class_1657)player, "warning.custom_skin_cache_limit", new Object[0]);
            if (((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
                Utils.sendMessage((class_1657)player, "warning.custom_skin_cache_limit.tip", new Object[0]);
            }
            clientWarned = true;
            return;
        }
        skinCache.put(name, false);
        MocapPacketC2S.sendRequestCustomSkin(name);
    }

    public static void register(Pair<String, byte[]> customSkinData) {
        String name = (String)customSkinData.getFirst();
        byte[] array = (byte[])customSkinData.getSecond();
        Boolean accessible = (Boolean)skinCache.get(name);
        if (accessible == null || accessible.booleanValue()) {
            return;
        }
        try {
            class_1011 nativeImage;
            try {
                nativeImage = class_1011.method_49277((byte[])array);
            }
            catch (IOException e) {
                Utils.exception(e, "Failed to load skin texture into buffer!");
                return;
            }
            if (nativeImage.method_4307() > 4096 || nativeImage.method_4323() > 4096) {
                MocapMod.LOGGER.warn("Skin texture too big!");
                return;
            }
            class_2960 id = CustomClientSkinManager.resFromName(name);
            class_310.method_1551().method_1531().method_4616(id, (class_1044)new class_1043(() -> ((class_2960)id).toString(), nativeImage));
            skinCache.put(name, true);
        }
        catch (Exception e) {
            Utils.exception(e, "Failed to read skin texture!");
        }
    }

    public static void clearCache() {
        class_1060 textureManager = class_310.method_1551().method_1531();
        for (Map.Entry entry : skinCache.entrySet()) {
            Boolean val = (Boolean)entry.getValue();
            if (val == null || !val.booleanValue()) continue;
            textureManager.method_4615(CustomClientSkinManager.resFromName((String)entry.getKey()));
        }
        skinCache.clear();
        clientWarned = false;
    }

    public static boolean isSlimSkin(class_12079.class_12081 texture) {
        return texture.comp_3627().method_12832().startsWith(SLIM_SKIN_RES_PREFIX);
    }

    private static class_2960 resFromName(String name) {
        return class_2960.method_60655((String)"mocap", (String)(SKIN_RES_PREFIX + name));
    }
}

