/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.skins;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_156;
import net.minecraft.class_3222;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.network.MocapPacketS2C;

public class CustomServerSkinManager {
    public static final String PROPERTY_ID = "mocap:skin_from_file";
    private static final ConcurrentMap<String, byte[]> skinCache = new ConcurrentHashMap<String, byte[]>();

    public static void sendSkinToClient(class_3222 player, String name) {
        byte[] image = (byte[])skinCache.get(name);
        if (image != null) {
            MocapPacketS2C.sendCustomSkinData(player, name, image);
        } else {
            class_156.method_18349().execute(() -> CustomServerSkinManager.sendSkinToClientThread(player, name));
        }
    }

    public static void sendSkinToClientThread(class_3222 player, String name) {
        if (!CustomServerSkinManager.checkIfProperName(CommandOutput.DUMMY, name)) {
            return;
        }
        byte[] array = Files.loadFile(Files.getSkinFile(name));
        if (array != null) {
            skinCache.put(name, array);
            MocapPacketS2C.sendCustomSkinData(player, name, array);
        }
    }

    public static boolean checkIfProperName(CommandOutput out, String name) {
        return Files.checkIfProperName(out, name.startsWith("slim/") ? name.substring(5) : name);
    }

    public static void clearCache() {
        skinCache.clear();
    }
}

