/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.mt1006.mocap.api.v1.extension.MocapActiveRecordingActions;
import net.mt1006.mocap.mixin.fields.LevelFields;
import net.mt1006.mocap.mocap.actions.EntityUpdate;
import net.mt1006.mocap.mocap.recording.PositionTracker;
import net.mt1006.mocap.mocap.recording.RecordedEntityState;
import net.mt1006.mocap.mocap.recording.RecordingContext;
import org.jetbrains.annotations.Nullable;

public class EntityTracker {
    private final RecordingContext ctx;
    private final Map<class_1297, TrackedEntity> map = new HashMap<class_1297, TrackedEntity>();
    private int counter = 0;
    private class_1297 playerVehicle = null;

    public EntityTracker(RecordingContext ctx) {
        this.ctx = ctx;
    }

    public TrackedEntity get(class_1297 entity) {
        return this.map.get(entity);
    }

    public Collection<TrackedEntity> getAll() {
        return this.map.values();
    }

    public void onTick() {
        if (this.ctx.config.getEntityTrackingDistance() != 0.0) {
            this.updateTracked();
            this.updateVehicle();
        }
        this.removeOld();
    }

    private void updateTracked() {
        double entityTrackingDist = this.ctx.config.getEntityTrackingDistance();
        boolean limitDistance = entityTrackingDist >= 0.0;
        double maxDistanceSqr = entityTrackingDist * entityTrackingDist;
        for (class_1297 entity : ((LevelFields)this.ctx.recordedPlayer.method_51469()).callGetEntities().method_31803()) {
            if (limitDistance && this.ctx.recordedPlayer.method_5858(entity) > maxDistanceSqr || entity instanceof class_1657 || this.ctx.config.getPreventTrackingPlayedEntities() && entity.method_5752().contains("mocap_entity") || !this.ctx.entityFilter.isAllowed(entity)) continue;
            TrackedEntity trackedEntity = this.map.get(entity);
            if (trackedEntity == null) {
                trackedEntity = new TrackedEntity(this.ctx, this.counter++, entity);
                this.map.put(entity, trackedEntity);
                this.ctx.addAction(EntityUpdate.addEntity(trackedEntity.id, entity, this.ctx.config));
            }
            trackedEntity.onTick();
        }
    }

    private void updateVehicle() {
        TrackedEntity trackedEntity;
        class_1297 newPlayerVehicle = this.ctx.recordedPlayer.method_5854();
        if (newPlayerVehicle == null) {
            if (this.playerVehicle != null) {
                this.ctx.addAction(EntityUpdate.playerDismount());
                this.playerVehicle = null;
            }
            return;
        }
        if (newPlayerVehicle.equals((Object)this.playerVehicle)) {
            return;
        }
        if (this.playerVehicle != null) {
            this.ctx.addAction(EntityUpdate.playerDismount());
            this.playerVehicle = null;
        }
        if ((trackedEntity = this.map.get(newPlayerVehicle)) != null) {
            this.ctx.addAction(EntityUpdate.playerMount(trackedEntity.id));
            this.playerVehicle = newPlayerVehicle;
        }
    }

    private void removeOld() {
        int tick = this.ctx.getTick();
        ArrayList<class_1297> toRemove = new ArrayList<class_1297>();
        for (Map.Entry<class_1297, TrackedEntity> entry : this.map.entrySet()) {
            if (entry.getValue().lastTick == tick) continue;
            if (!entry.getValue().dying) {
                int entityId = entry.getValue().id;
                EntityUpdate entityUpdate = entry.getKey().method_35049() == class_1297.class_5529.field_26998 ? EntityUpdate.kill(entityId) : EntityUpdate.removeEntity(entityId);
                this.ctx.addAction(entityUpdate);
            }
            toRemove.add(entry.getKey());
        }
        toRemove.forEach(this.map::remove);
    }

    public static class TrackedEntity
    implements MocapActiveRecordingActions.TrackedEntity {
        private final RecordingContext ctx;
        private final int id;
        private final class_1297 entity;
        private final PositionTracker positionTracker;
        @Nullable
        private RecordedEntityState previousState = null;
        private boolean dying;
        private int lastTick;

        public TrackedEntity(RecordingContext ctx, int id, class_1297 entity) {
            this.ctx = ctx;
            this.id = id;
            this.entity = entity;
            this.positionTracker = new PositionTracker(entity, true, ctx.data.startPos);
        }

        public void onTick() {
            RecordedEntityState state = new RecordedEntityState(this.entity);
            state.saveTrackedEntityDifference(this.ctx.data.actions, this.id, this.previousState);
            this.previousState = state;
            this.positionTracker.onTick(this.ctx.data.actions, this.id);
            this.lastTick = this.ctx.getTick();
            if (this.entity instanceof class_1309 && ((class_1309)this.entity).method_29504() && !this.dying) {
                this.ctx.addAction(EntityUpdate.kill(this.id));
                this.dying = true;
            }
        }

        @Override
        public MocapActiveRecordingActions getParent() {
            return this.ctx;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public class_1297 getEntity() {
            return this.entity;
        }
    }
}

