/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.mocap.actions.EntityAction;
import net.mt1006.mocap.mocap.actions.Movement;
import net.mt1006.mocap.mocap.files.RecordingData;
import org.jetbrains.annotations.Nullable;

public class PositionTracker {
    public static final class_243 FAR_AWAY = new class_243(0.0, 1000000.0, 0.0);
    private class_1297 entity;
    private final class_243 startPos;
    private class_243 pos;
    private final float[] rotation = new float[2];
    private float headRot;
    private boolean onGround;
    private boolean forceNonPosDataFlag;

    public PositionTracker(class_1297 entity, boolean initRotAndGround, class_243 startPos) {
        this.entity = entity;
        this.startPos = startPos;
        this.pos = entity.method_73189();
        this.rotation[0] = entity.method_36455();
        this.rotation[1] = entity.method_36454();
        this.headRot = entity.method_5791();
        this.onGround = entity.method_24828();
        this.forceNonPosDataFlag = initRotAndGround;
    }

    public void setEntity(class_1297 entity) {
        this.entity = entity;
    }

    public void onTick(List<MocapAction> actionList, @Nullable Integer entityId) {
        Movement movement = this.getDelta(true, this.forceNonPosDataFlag);
        this.forceNonPosDataFlag = false;
        if (movement == null) {
            return;
        }
        actionList.add(entityId != null ? new EntityAction(entityId, movement) : movement);
    }

    public void teleportFarAway(List<MocapAction> actionList) {
        Movement movement = Movement.teleportToPos(FAR_AWAY, false);
        actionList.add(movement);
        this.pos = movement.getNewPosition(this.startPos, this.pos);
        this.rotation[0] = 0.0f;
        this.rotation[1] = 0.0f;
        this.headRot = 0.0f;
        this.onGround = false;
    }

    @Nullable
    public Movement getDelta() {
        return this.getDelta(false, false);
    }

    @Nullable
    private Movement getDelta(boolean applyChanges, boolean forceNonPosData) {
        float newXRot = this.entity.method_36455();
        float newYRot = this.entity.method_36454();
        float newHeadRot = this.entity.method_5791();
        boolean newOnGround = this.entity.method_24828();
        Movement movement = Movement.delta(this.startPos, this.pos, this.entity.method_73189(), this.rotation, newXRot, newYRot, this.headRot, newHeadRot, this.onGround, newOnGround, forceNonPosData);
        if (applyChanges) {
            this.rotation[0] = newXRot;
            this.rotation[1] = newYRot;
            this.headRot = newHeadRot;
            this.onGround = newOnGround;
            if (movement != null) {
                this.pos = movement.getNewPosition(this.startPos, this.pos);
            }
        }
        return movement;
    }

    public void writeStartPos(RecordingData data) {
        data.startPos = this.startPos;
        data.startRot[0] = this.rotation[1];
        data.startRot[1] = this.rotation[0];
    }
}

