/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.v1.controller.config.MocapRecordingConfig;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandsContext;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.PlaybackManager;
import net.mt1006.mocap.mocap.playing.playable.RecordingFile;
import net.mt1006.mocap.mocap.recording.EntityTracker;
import net.mt1006.mocap.mocap.recording.RecordingContext;
import net.mt1006.mocap.mocap.recording.RecordingId;
import net.mt1006.mocap.mocap.recording.RecordingSource;
import net.mt1006.mocap.mocap.settings.Settings;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class RecordingManager {
    private static final Multimap<String, RecordingContext> contextsBySource = HashMultimap.create();
    private static final Collection<RecordingContext> contexts = contextsBySource.values();
    public static final BiMultimap<class_3222, RecordingContext> waitingForRespawn = new BiMultimap();

    @Nullable
    public static RecordingContext startOrWait(CommandInfo info, class_3222 player, RecordingSource source, @Nullable String instantSave, boolean multiplePlayers) {
        if (!RecordingManager.checkDoubleStart(info, player)) {
            return null;
        }
        boolean startInstantly = (Boolean)Settings.START_INSTANTLY.val != false || multiplePlayers;
        RecordingContext ctx = RecordingManager.start(player, source, MocapRecordingConfig.createFromSettings(), instantSave, startInstantly, !multiplePlayers);
        if (ctx != null && !startInstantly) {
            info.sendSuccess(player.equals((Object)info.getSourcePlayer()) ? "recording.start.waiting_for_action.self" : "recording.start.waiting_for_action.another_player", new Object[0]);
        }
        if (ctx == null) {
            info.sendFailure("recording.start.error", new Object[0]);
        }
        return ctx;
    }

    @Nullable
    public static RecordingContext start(class_3222 player, RecordingSource source, MocapRecordingConfig config, @Nullable String instantSave, boolean startNow, boolean sendMessage) {
        RecordingId id = new RecordingId(contexts, player, source.name);
        if (!id.isProper()) {
            return null;
        }
        RecordingContext ctx = new RecordingContext(id, player, source, config, instantSave);
        contextsBySource.put((Object)source.name, (Object)ctx);
        CommandSuggestions.inputSet.add(id.str);
        if (startNow) {
            ctx.start(sendMessage);
        }
        return ctx;
    }

    private static boolean checkDoubleStart(CommandInfo info, class_3222 recordedPlayer) {
        class_3222 sourcePlayer = info.getSourcePlayer();
        if (sourcePlayer == null) {
            return true;
        }
        String recordedPlayerName = recordedPlayer.method_5477().getString();
        if (!recordedPlayerName.equals(CommandsContext.get((class_3222)sourcePlayer).doubleStart)) {
            for (RecordingContext ctx : contexts) {
                if (ctx.source.player != sourcePlayer || ctx.recordedPlayer != recordedPlayer) continue;
                RecordingManager.handleDoubleStart(info, ctx);
                return false;
            }
        }
        CommandsContext.get((class_3222)sourcePlayer).doubleStart = null;
        return true;
    }

    private static void handleDoubleStart(CommandOutput out, RecordingContext ctx) {
        boolean addToDoubleStart = false;
        switch (ctx.state) {
            case WAITING_FOR_ACTION: {
                ctx.start(true);
                break;
            }
            case RECORDING: {
                out.sendFailureWithTip("recording.start.already_recording", new Object[0]);
                addToDoubleStart = true;
                break;
            }
            case WAITING_FOR_DECISION: {
                out.sendFailureWithTip("recording.start.waiting_for_decision", new Object[0]);
                addToDoubleStart = true;
                break;
            }
            default: {
                MocapMod.LOGGER.error("Undefined recording context state supplied to double start handler!");
                out.sendFailureWithTip("recording.start.error", new Object[0]);
            }
        }
        if (addToDoubleStart && ctx.source.player != null) {
            CommandsContext.get((class_3222)ctx.source.player).doubleStart = ctx.recordedPlayer.method_5477().getString();
        }
    }

    public static boolean stop(CommandInfo info, @Nullable String id) {
        boolean success;
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(info, id, false);
        if (resolvedContexts == null) {
            return false;
        }
        boolean bl = success = resolvedContexts.isSingle ? RecordingManager.stopSingle(info, resolvedContexts.list.iterator().next(), info.getSourcePlayer()) : RecordingManager.stopMultiple(info, resolvedContexts.list);
        if (CommandsContext.haveSyncEnabled != 0) {
            RecordingManager.refreshSyncOnStop(resolvedContexts);
        }
        return success;
    }

    public static boolean stopSingle(CommandOutput out, RecordingContext ctx, @Nullable class_3222 sourcePlayer) {
        if (ctx.state == RecordingContext.State.WAITING_FOR_DECISION) {
            if (!((Boolean)Settings.QUICK_DISCARD.val).booleanValue()) {
                return out.sendFailureWithTip("recording.stop.quick_discard.disabled", new Object[0]);
            }
            if (ctx.requiresSafeDiscard) {
                ctx.requiresSafeDiscard = false;
                return out.sendFailureWithTip("recording.stop.quick_discard.safe_discard_required", new Object[0]);
            }
            return RecordingManager.discardSingle(out, ctx);
        }
        ctx.stop(out);
        return switch (ctx.state) {
            case RecordingContext.State.WAITING_FOR_DECISION -> RecordingManager.sendStopMessage(x$0 -> out.sendSuccess((String)x$0, new Object[0]), ctx, sourcePlayer);
            case RecordingContext.State.CANCELED -> out.sendSuccess("recording.stop.canceled", new Object[0]);
            case RecordingContext.State.SAVED -> out.sendSuccess("recording.stop.instant_save", ctx.instantSave != null ? ctx.instantSave : "[error]");
            default -> out.sendFailure("recording.undefined_state", ctx.state.name());
        };
    }

    public static boolean sendStopMessage(Consumer<String> successSender, RecordingContext ctx, @Nullable class_3222 sourcePlayer) {
        successSender.accept("recording.stop.stopped");
        if (((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
            successSender.accept(RecordingManager.shouldSuggestQuickDiscard(ctx, sourcePlayer) ? "recording.stop.stopped.stop_tip" : "recording.stop.stopped.discard_tip");
        }
        return true;
    }

    public static boolean shouldSuggestQuickDiscard(RecordingContext ctx, @Nullable class_3222 source) {
        return (Boolean)Settings.QUICK_DISCARD.val != false && !ctx.requiresSafeDiscard && source != null && RecordingManager.bySourcePlayer(source).size() == 1;
    }

    private static boolean stopMultiple(CommandOutput out, Collection<RecordingContext> contexts) {
        int stopped = 0;
        int cancelled = 0;
        int saved = 0;
        int stillWaiting = 0;
        int unknownState = 0;
        block5: for (RecordingContext ctx : contexts) {
            if (ctx.state == RecordingContext.State.WAITING_FOR_DECISION) {
                ++stillWaiting;
                continue;
            }
            ctx.stop(out);
            switch (ctx.state) {
                case WAITING_FOR_DECISION: {
                    ++stopped;
                    continue block5;
                }
                case CANCELED: {
                    ++cancelled;
                    continue block5;
                }
                case SAVED: {
                    ++saved;
                    continue block5;
                }
            }
            ++unknownState;
        }
        if (stopped == 0 && cancelled == 0 && saved == 0 && stillWaiting == 0 && unknownState == 0) {
            out.sendSuccess("recording.multiple.results.none", new Object[0]);
            return true;
        }
        out.sendSuccess("recording.multiple.results", new Object[0]);
        if (stopped != 0) {
            out.sendSuccess("recording.multiple.results.stopped", stopped);
        }
        if (cancelled != 0) {
            out.sendSuccess("recording.multiple.results.cancelled", cancelled);
        }
        if (saved != 0) {
            out.sendSuccess("recording.multiple.results.saved", saved);
        }
        if (stillWaiting != 0) {
            out.sendSuccess("recording.multiple.results.still_waiting", stillWaiting);
        }
        if (unknownState != 0) {
            out.sendSuccess("recording.multiple.results.error", unknownState);
            return out.sendFailure("recording.multiple.undefined_state", new Object[0]);
        }
        return true;
    }

    @Nullable
    public static RecordingContext resolveSingle(CommandInfo info, String id) {
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(info, id, false);
        return resolvedContexts != null && resolvedContexts.isSingle ? resolvedContexts.list.iterator().next() : null;
    }

    private static void refreshSyncOnStop(ResolvedContexts resolvedContexts) {
        HashSet<class_3222> players = new HashSet<class_3222>();
        for (RecordingContext ctx : resolvedContexts.list) {
            if (ctx.source.player == null) continue;
            players.add(ctx.source.player);
        }
        for (class_3222 player : players) {
            boolean stillRecording = false;
            for (RecordingContext ctx : RecordingManager.bySourcePlayer(player)) {
                if (ctx.state != RecordingContext.State.RECORDING) continue;
                stillRecording = true;
                break;
            }
            if (stillRecording) continue;
            PlaybackManager.stopAll(CommandOutput.DUMMY, player);
        }
    }

    public static boolean discard(CommandInfo out, @Nullable String id) {
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(out, id, false);
        if (resolvedContexts == null) {
            return false;
        }
        if (resolvedContexts.isSingle) {
            RecordingContext ctx = resolvedContexts.list.iterator().next();
            boolean showQuickDiscardTip = RecordingManager.shouldSuggestQuickDiscard(ctx, out.getSourcePlayer()) && (Boolean)Settings.SHOW_TIPS.val != false;
            boolean success = RecordingManager.discardSingle(out, ctx);
            if (success && ctx.state == RecordingContext.State.DISCARDED && showQuickDiscardTip) {
                out.sendSuccess("recording.discard.quick_discard_tip", new Object[0]);
            }
            return success;
        }
        return RecordingManager.discardMultiple(out, resolvedContexts.list);
    }

    public static boolean discardSingle(CommandOutput out, RecordingContext ctx) {
        if (ctx.state == RecordingContext.State.RECORDING) {
            out.sendFailure("recording.discard.not_stopped", new Object[0]);
            return false;
        }
        ctx.discard();
        return switch (ctx.state) {
            case RecordingContext.State.DISCARDED -> out.sendSuccess("recording.discard.discarded", new Object[0]);
            case RecordingContext.State.CANCELED -> out.sendSuccess("recording.stop.canceled", new Object[0]);
            default -> out.sendFailure("recording.undefined_state", ctx.state.name());
        };
    }

    private static boolean discardMultiple(CommandOutput out, Collection<RecordingContext> contexts) {
        int discarded = 0;
        int cancelled = 0;
        int stillRecording = 0;
        int unknownState = 0;
        block4: for (RecordingContext ctx : contexts) {
            if (ctx.state == RecordingContext.State.RECORDING) {
                ++stillRecording;
                continue;
            }
            ctx.discard();
            switch (ctx.state) {
                case DISCARDED: {
                    ++discarded;
                    continue block4;
                }
                case CANCELED: {
                    ++cancelled;
                    continue block4;
                }
            }
            ++unknownState;
        }
        if (discarded == 0 && cancelled == 0 && stillRecording == 0 && unknownState == 0) {
            out.sendSuccess("recording.multiple.results.none", new Object[0]);
            return true;
        }
        out.sendSuccess("recording.multiple.results", new Object[0]);
        if (discarded != 0) {
            out.sendSuccess("recording.multiple.results.discarded", discarded);
        }
        if (cancelled != 0) {
            out.sendSuccess("recording.multiple.results.cancelled", cancelled);
        }
        if (stillRecording != 0) {
            out.sendSuccess("recording.multiple.results.still_recording", stillRecording);
        }
        if (unknownState != 0) {
            out.sendSuccess("recording.multiple.results.error", unknownState);
            return out.sendFailure("recording.multiple.undefined_state", new Object[0]);
        }
        return true;
    }

    public static boolean save(CommandInfo info, @Nullable String id, String name) {
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(info, id, false);
        if (resolvedContexts == null) {
            return false;
        }
        return resolvedContexts.isSingle ? RecordingManager.saveSingle(info, resolvedContexts.list.iterator().next(), name, true) : RecordingManager.saveMultiple(info, resolvedContexts.list, name);
    }

    public static boolean saveSingle(CommandOutput out, RecordingContext ctx, String name, boolean sendSavedMessage) {
        if (ctx.state == RecordingContext.State.RECORDING) {
            return out.sendFailure("recording.save.not_stopped", new Object[0]);
        }
        RecordingFile recordingFile = RecordingFile.get(out, name);
        if (recordingFile == null) {
            return false;
        }
        if (recordingFile.exists()) {
            out.sendFailure("recording.save.already_exists", new Object[0]);
            String alternativeName = RecordingFiles.findAlternativeName(name);
            if (alternativeName != null) {
                out.sendFailure("recording.save.already_exists.alternative", alternativeName);
            }
            return false;
        }
        ctx.save(recordingFile.getFile(), name);
        switch (ctx.state) {
            case SAVED: {
                if (sendSavedMessage) {
                    out.sendSuccess("recording.save.saved", new Object[0]);
                }
                return true;
            }
            case WAITING_FOR_DECISION: {
                return out.sendFailure("recording.save.error", new Object[0]);
            }
        }
        return out.sendFailure("recording.undefined_state", ctx.state.name());
    }

    private static boolean saveMultiple(CommandOutput out, Collection<RecordingContext> contexts, String namePrefix) {
        ArrayList<RecordingContext> stopped = new ArrayList<RecordingContext>();
        for (RecordingContext ctx : contexts) {
            if (ctx.state != RecordingContext.State.WAITING_FOR_DECISION) continue;
            stopped.add(ctx);
        }
        if (stopped.isEmpty()) {
            out.sendFailure("recording.save.multiple.nothing_to_save", new Object[0]);
            return false;
        }
        ArrayList<String> filenames = new ArrayList<String>();
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 1; i <= stopped.size(); ++i) {
            String filename = String.format("%s%d", namePrefix, i);
            RecordingFile recordingFile = RecordingFile.get(out, filename);
            if (recordingFile == null) {
                return false;
            }
            if (recordingFile.exists()) {
                out.sendFailure("recording.save.multiple.already_exists", filename);
                return false;
            }
            filenames.add(filename);
            files.add(recordingFile.getFile());
        }
        boolean somethingFailed = false;
        for (int i = 0; i < stopped.size(); ++i) {
            RecordingContext ctx = (RecordingContext)stopped.get(i);
            ctx.save((File)files.get(i), (String)filenames.get(i));
            switch (ctx.state) {
                case SAVED: {
                    out.sendSuccess("recording.save.multiple.saved", ctx.id.str, filenames.get(i));
                    break;
                }
                case WAITING_FOR_DECISION: {
                    out.sendFailure("recording.save.multiple.failed", ctx.id.str, filenames.get(i));
                    break;
                }
                default: {
                    out.sendFailure("recording.save.multiple.unknown_state", ctx.id.str, filenames.get(i), ctx.state.name());
                }
            }
            if (ctx.state == RecordingContext.State.SAVED) continue;
            somethingFailed = true;
        }
        if (somethingFailed) {
            out.sendFailure("recording.save.multiple.error", new Object[0]);
        }
        return !somethingFailed;
    }

    public static boolean list(CommandInfo info, @Nullable String id) {
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(info, id, true);
        if (resolvedContexts == null) {
            return false;
        }
        if (resolvedContexts.isSingle) {
            RecordingContext ctx = resolvedContexts.list.iterator().next();
            return info.sendSuccess("recording.list.state", resolvedContexts.fullId.str, ctx.state.name());
        }
        ArrayList<String> waitingForAction = new ArrayList<String>();
        ArrayList recording = new ArrayList();
        ArrayList waitingForDecision = new ArrayList();
        ArrayList error = new ArrayList();
        for (RecordingContext ctx : resolvedContexts.list) {
            ArrayList<String> list = switch (ctx.state) {
                case RecordingContext.State.WAITING_FOR_ACTION -> waitingForAction;
                case RecordingContext.State.RECORDING -> recording;
                case RecordingContext.State.WAITING_FOR_DECISION -> waitingForDecision;
                default -> error;
            };
            list.add(ctx.id.str);
        }
        Collections.sort(waitingForAction);
        Collections.sort(recording);
        Collections.sort(waitingForDecision);
        Collections.sort(error);
        info.sendSuccess("recording.list.list", resolvedContexts.fullId.str);
        if (waitingForAction.isEmpty()) {
            info.sendSuccess("recording.list.waiting_for_action.none", new Object[0]);
        } else {
            info.sendSuccess("recording.list.waiting_for_action", StringUtils.join(waitingForAction, (String)" "));
        }
        if (recording.isEmpty()) {
            info.sendSuccess("recording.list.recording.none", new Object[0]);
        } else {
            info.sendSuccess("recording.list.recording", StringUtils.join(recording, (String)" "));
        }
        if (waitingForDecision.isEmpty()) {
            info.sendSuccess("recording.list.waiting_for_decision.none", new Object[0]);
        } else {
            info.sendSuccess("recording.list.waiting_for_decision", StringUtils.join(waitingForDecision, (String)" "));
        }
        if (!error.isEmpty()) {
            info.sendSuccess("recording.list.unknown_state", StringUtils.join(error, (String)" "));
            info.sendSuccess("recording.list.unknown_state.error", new Object[0]);
        }
        return true;
    }

    public static void onTick() {
        new ArrayList<RecordingContext>(contexts).forEach(RecordingContext::onTick);
    }

    public static boolean isRecordedPlayer(@Nullable class_1297 entity) {
        if (contexts.isEmpty() || !(entity instanceof class_3222)) {
            return false;
        }
        for (RecordingContext ctx : contexts) {
            if (!entity.equals((Object)ctx.recordedPlayer)) continue;
            return true;
        }
        return false;
    }

    public static boolean isActive() {
        return !contexts.isEmpty();
    }

    public static List<RecordingContext> byRecordedPlayer(int id) {
        ArrayList<RecordingContext> list = new ArrayList<RecordingContext>(1);
        for (RecordingContext ctx : contexts) {
            if (ctx.recordedPlayer.method_5628() != id) continue;
            list.add(ctx);
        }
        return list;
    }

    public static List<RecordingContext> byRecordedPlayer(UUID uuid) {
        ArrayList<RecordingContext> list = new ArrayList<RecordingContext>(1);
        for (RecordingContext ctx : contexts) {
            if (!ctx.recordedPlayer.method_5667().equals(uuid)) continue;
            list.add(ctx);
        }
        return list;
    }

    public static List<RecordingContext> byRecordedPlayer(class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            return List.of();
        }
        ArrayList<RecordingContext> list = new ArrayList<RecordingContext>(1);
        for (RecordingContext ctx : contexts) {
            if (ctx.recordedPlayer != entity) continue;
            list.add(ctx);
        }
        return list;
    }

    @Nullable
    public static Collection<RecordingContext> resolveContexts(CommandInfo info, String id) {
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(info, id, false);
        return resolvedContexts != null ? resolvedContexts.list : null;
    }

    public static List<EntityTracker.TrackedEntity> listTrackedEntities(class_1297 entity) {
        ArrayList<EntityTracker.TrackedEntity> list = new ArrayList<EntityTracker.TrackedEntity>(1);
        for (RecordingContext ctx : contexts) {
            EntityTracker.TrackedEntity trackedEntity = ctx.getTrackedEntity(entity);
            if (trackedEntity == null) continue;
            list.add(trackedEntity);
        }
        return list;
    }

    public static Collection<RecordingContext> bySourcePlayer(class_3222 player) {
        return contextsBySource.get((Object)player.method_5477().getString());
    }

    public static void removeContext(RecordingContext ctx) {
        waitingForRespawn.removeByValue(ctx);
        contextsBySource.remove((Object)ctx.source.name, (Object)ctx);
        CommandSuggestions.inputSet.remove(ctx.id.str);
    }

    public static Collection<RecordingContext> allContexts() {
        return contexts;
    }

    public static void onServerStop() {
        waitingForRespawn.clear();
        contextsBySource.clear();
    }

    private record ResolvedContexts(Collection<RecordingContext> list, boolean isSingle, RecordingId fullId) {
        @Nullable
        public static ResolvedContexts resolve(CommandInfo info, @Nullable String idStr, boolean listMode) {
            if (idStr == null) {
                if (listMode) {
                    return new ResolvedContexts(contexts, false, RecordingId.ALL);
                }
                RecordingContext ctx = ResolvedContexts.resolveEmpty(info);
                return ctx != null ? new ResolvedContexts(List.of(ctx), true, ctx.id) : null;
            }
            RecordingId id = new RecordingId(idStr, info.getSourceName());
            if (!id.isProper()) {
                if (idStr.contains("_")) {
                    info.sendFailureWithTip("recording.resolve.improper_group_structure", new Object[0]);
                } else {
                    info.sendFailure("recording.resolve.improper_structure", new Object[0]);
                    if (!listMode && ((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
                        info.sendFailure("recording.resolve.list_tip", new Object[0]);
                    }
                }
                return null;
            }
            ArrayList<RecordingContext> matchingContexts = new ArrayList<RecordingContext>();
            for (RecordingContext ctx : contexts) {
                if (!ctx.id.matches(id)) continue;
                matchingContexts.add(ctx);
            }
            boolean isSingle = id.isSingle();
            if (isSingle) {
                if (matchingContexts.size() > 1) {
                    MocapMod.LOGGER.error("Multiple recording contexts are matching single id!");
                }
                if (matchingContexts.isEmpty()) {
                    info.sendFailure("recording.resolve.not_found", new Object[0]);
                    if (!listMode && ((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
                        info.sendFailure("recording.resolve.list_tip", new Object[0]);
                    }
                    return null;
                }
            }
            return new ResolvedContexts(matchingContexts, isSingle, id);
        }

        @Nullable
        private static RecordingContext resolveEmpty(CommandInfo info) {
            class_3222 source = info.getSourcePlayer();
            if (source == null) {
                info.sendFailure("failure.resolve_player", new Object[0]);
                return null;
            }
            Collection<RecordingContext> sourceContexts = RecordingManager.bySourcePlayer(source);
            if (sourceContexts.size() > 1) {
                info.sendFailureWithTip("recording.resolve.multiple_recordings", new Object[0]);
                return null;
            }
            if (sourceContexts.isEmpty()) {
                if (contexts.isEmpty()) {
                    info.sendFailure("recording.resolve.server_not_recording", new Object[0]);
                } else {
                    info.sendFailureWithTip("recording.resolve.player_not_recording", new Object[0]);
                }
                return null;
            }
            return sourceContexts.iterator().next();
        }
    }

    public static class BiMultimap<A, B> {
        public final Multimap<A, B> byKey = HashMultimap.create();
        public final Multimap<B, A> byValue = HashMultimap.create();

        public void put(A key, B val) {
            this.byKey.put(key, val);
            this.byValue.put(val, key);
        }

        public void removeByValue(B val) {
            Collection keys = this.byValue.removeAll(val);
            keys.forEach(k -> this.byKey.remove(k, val));
        }

        public void clear() {
            this.byKey.clear();
            this.byValue.clear();
        }

        public boolean isEmpty() {
            return this.byKey.isEmpty() && this.byValue.isEmpty();
        }
    }
}

