/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.settings;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.io.FullCommandInfo;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilterInstance;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class SettingFields {
    public final Map<String, Field<?>> fieldMap = new HashMap();

    public BooleanField add(String name, boolean val) {
        return this.addField(name, new BooleanField(name, val));
    }

    public DoubleField add(String name, double val) {
        return this.addField(name, new DoubleField(name, val));
    }

    public <T extends Enum<T>> EnumField<T> add(String name, T val) {
        return this.addField(name, new EnumField<T>(name, val));
    }

    public EntityFilterField addFilterField(String name, String val, @Nullable Consumer<String> onSet) {
        return this.addField(name, new EntityFilterField(name, val, onSet));
    }

    private <T extends Field<?>> T addField(String name, T field) {
        if (this.fieldMap.put(name, field) != null) {
            throw new RuntimeException("Duplicate field names!");
        }
        return field;
    }

    public void save() {
        try {
            File settingsFile = Files.getSettingsFile();
            if (settingsFile == null) {
                return;
            }
            PrintWriter printWriter = new PrintWriter(settingsFile);
            this.fieldMap.values().forEach(f -> printWriter.print(f.toFileLine()));
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load() {
        try {
            File settingsFile = Files.getSettingsFile();
            if (settingsFile == null) {
                return;
            }
            Scanner fileScanner = new Scanner(settingsFile);
            while (fileScanner.hasNextLine()) {
                String line = fileScanner.nextLine();
                if (line.isEmpty()) continue;
                String[] parts = line.split("=");
                if (parts.length != 2) {
                    fileScanner.close();
                    return;
                }
                Field<?> field = this.fieldMap.get(parts[0]);
                if (field == null) continue;
                field.setFromString(parts[1]);
            }
            fileScanner.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unload() {
        this.fieldMap.values().forEach(Field::reset);
    }

    public static class BooleanField
    extends Field<Boolean> {
        public BooleanField(String name, Boolean val) {
            super(name, val, null);
        }

        @Override
        public Boolean parseFromString(String str) {
            return Boolean.valueOf(str);
        }

        @Override
        public Boolean parseFromCommand(FullCommandInfo info) {
            return info.getBool("new_value");
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return BoolArgumentType.bool();
        }
    }

    public static abstract class Field<T> {
        public final String name;
        @Nullable
        private final Consumer<T> onSet;
        public final T defVal;
        public T val;

        public Field(String name, T defVal, @Nullable Consumer<T> onSet) {
            this.name = name;
            this.defVal = defVal;
            this.val = defVal;
            this.onSet = onSet;
            if (onSet != null) {
                onSet.accept(this.val);
            }
        }

        public void set(T val) {
            this.val = val;
            if (this.onSet != null) {
                this.onSet.accept(val);
            }
        }

        public void reset() {
            this.set(this.defVal);
        }

        public class_2561 getInfo(CommandInfo info) {
            String key = this.val.equals(this.defVal) ? "settings.list.info_def" : "settings.list.info";
            return info.getTranslatableComponent(key, this.name, this.valToString());
        }

        public void printValues(CommandInfo info) {
            info.sendSuccess("settings.info.current_value", this.valToString());
            info.sendSuccess("settings.info.default_value", this.valToString(this.defVal));
        }

        public final String toFileLine() {
            return this.name + "=" + this.valToString() + "\n";
        }

        public final boolean setFromString(String str) {
            try {
                this.set(this.parseFromString(str));
                return true;
            }
            catch (Exception e) {
                Utils.exception(e, "Failed to load settings from string");
                return false;
            }
        }

        public final boolean fromCommand(FullCommandInfo info) {
            try {
                T newVal = this.parseFromCommand(info);
                if (newVal == null) {
                    info.sendFailure("settings.set.invalid_value", new Object[0]);
                    return false;
                }
                this.set(newVal);
                return true;
            }
            catch (Exception e) {
                info.sendException(e, "settings.set.error", new Object[0]);
                this.reset();
                return false;
            }
        }

        public final String valToString() {
            return this.valToString(this.val);
        }

        protected String valToString(T val) {
            return val.toString();
        }

        @Nullable
        public SuggestionProvider<class_2168> getSuggestionProvider() {
            return null;
        }

        public abstract T parseFromString(String var1);

        @Nullable
        public abstract T parseFromCommand(FullCommandInfo var1);

        public abstract ArgumentType<?> getArgumentType();
    }

    public static class DoubleField
    extends Field<Double> {
        public DoubleField(String name, Double val) {
            super(name, val, null);
        }

        @Override
        public Double parseFromString(String str) {
            return Double.valueOf(str);
        }

        @Override
        public Double parseFromCommand(FullCommandInfo info) {
            return info.getDouble("new_value");
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return DoubleArgumentType.doubleArg();
        }
    }

    public static class EnumField<T extends Enum<T>>
    extends Field<T> {
        private final Class<T> enumClass;
        private final T[] constants;

        public EnumField(String name, T val) {
            super(name, val, null);
            this.enumClass = val.getClass();
            this.constants = (Enum[])this.enumClass.getEnumConstants();
        }

        @Override
        public T parseFromString(String str) {
            return Enum.valueOf(this.enumClass, str.toUpperCase());
        }

        @Override
        @Nullable
        public T parseFromCommand(FullCommandInfo info) {
            String newValue = info.getString("new_value");
            try {
                return Enum.valueOf(this.enumClass, newValue.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return StringArgumentType.word();
        }

        @Override
        protected String valToString(T val) {
            return ((Enum)val).toString().toLowerCase();
        }

        @Override
        public SuggestionProvider<class_2168> getSuggestionProvider() {
            return this::suggestionProvider;
        }

        private CompletableFuture<Suggestions> suggestionProvider(CommandContext<?> ctx, SuggestionsBuilder builder) {
            String remaining = builder.getRemaining();
            for (T e : this.constants) {
                String str = ((Enum)e).name().toLowerCase();
                if (!str.startsWith(remaining)) continue;
                builder.suggest(str);
            }
            return builder.buildFuture();
        }
    }

    public static class EntityFilterField
    extends StringField {
        public EntityFilterField(String name, String val, @Nullable Consumer<String> onSet) {
            super(name, val, onSet);
        }

        @Override
        public String parseFromString(String str) {
            return EntityFilterInstance.test(str) ? str : (String)this.defVal;
        }

        @Override
        @Nullable
        public String parseFromCommand(FullCommandInfo info) {
            String newValue = info.getString("new_value");
            return EntityFilterInstance.test(newValue) ? newValue : null;
        }

        @Override
        public SuggestionProvider<class_2168> getSuggestionProvider() {
            return CommandSuggestions::entityFilter;
        }
    }

    public static class StringField
    extends Field<String> {
        public StringField(String name, String val, @Nullable Consumer<String> onSet) {
            super(name, val, onSet);
        }

        @Override
        public String parseFromString(String str) {
            return str;
        }

        @Override
        @Nullable
        public String parseFromCommand(FullCommandInfo info) {
            return info.getString("new_value");
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return StringArgumentType.greedyString();
        }

        @Override
        public void printValues(CommandInfo info) {
            String valStr = (String)this.val;
            String defValStr = (String)this.defVal;
            info.sendSuccess("settings.info.string_value", info.getTranslatableComponent("settings.info.current_value", valStr), StringField.createButton(info, valStr));
            info.sendSuccess("settings.info.string_value", info.getTranslatableComponent("settings.info.default_value", defValStr), StringField.createButton(info, defValStr));
        }

        private static class_2561 createButton(CommandInfo info, String textToCopy) {
            class_2558.class_10606 clickEvent = new class_2558.class_10606(textToCopy);
            class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)info.getTranslatableComponent("settings.info.copy_button_info", new Object[0]));
            return info.getTranslatableComponent("settings.info.copy_button", new Object[0]).method_10862(class_2583.field_24360.method_10958((class_2558)clickEvent).method_10949((class_2568)hoverEvent));
        }
    }
}

