/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.network;

import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.playing.skins.CustomClientSkinManager;
import net.mt1006.mocap.network.MocapPacketC2S;
import net.mt1006.mocap.network.NetworkUtils;
import org.jetbrains.annotations.NotNull;

public class MocapPacketS2C
implements class_8710 {
    private static final String TYPE_ID = MocapMod.loaderInterface.getLoaderName().toLowerCase() + "_s2c";
    public static final class_8710.class_9154<MocapPacketS2C> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"mocap", (String)TYPE_ID));
    public static final class_9139<class_2540, MocapPacketS2C> CODEC = class_9139.method_56437((b, p) -> p.encode((class_2540)b), MocapPacketS2C::new);
    public static final int ON_LOGIN = 0;
    public static final int NOCOL_PLAYER_ADD = 1;
    public static final int NOCOL_PLAYER_REMOVE = 2;
    public static final int CUSTOM_SKIN_DATA = 5;
    public static final int CLEAR_CACHE = 6;
    private final int version;
    private final int op;
    private final Object object;

    public MocapPacketS2C(int op, Object object) {
        this.version = 5;
        this.op = op;
        this.object = object;
    }

    public MocapPacketS2C(class_2540 buf) {
        this.version = buf.readInt();
        this.op = buf.readInt();
        switch (this.op) {
            case 1: 
            case 2: {
                this.object = buf.method_10790();
                break;
            }
            case 5: {
                String customSkinName = NetworkUtils.readString(buf);
                byte[] customSkinArray = NetworkUtils.readByteArray(buf);
                this.object = Pair.of((Object)customSkinName, (Object)customSkinArray);
                break;
            }
            default: {
                this.object = null;
            }
        }
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public void encode(class_2540 buf) {
        buf.method_53002(this.version);
        buf.method_53002(this.op);
        switch (this.op) {
            case 1: 
            case 2: {
                if (!(this.object instanceof UUID)) break;
                buf.method_10797((UUID)this.object);
                break;
            }
            case 5: {
                if (!(this.object instanceof Pair)) break;
                Pair customSkinData = (Pair)this.object;
                NetworkUtils.writeString(buf, (String)customSkinData.getFirst());
                NetworkUtils.writeByteArray(buf, (byte[])customSkinData.getSecond());
            }
        }
    }

    public void handle(Server server) {
        if (this.version != 5) {
            return;
        }
        switch (this.op) {
            case 0: {
                MocapPacketC2S.sendAcceptServer(server);
                break;
            }
            case 1: {
                PlayerConnectionEvent.addNocolPlayer((UUID)this.object);
                break;
            }
            case 2: {
                PlayerConnectionEvent.removeNocolPlayer((UUID)this.object);
                break;
            }
            case 5: {
                CustomClientSkinManager.register((Pair<String, byte[]>)((Pair)this.object));
                break;
            }
            case 6: {
                CustomClientSkinManager.clearCache();
            }
        }
    }

    public static void sendOnLogin(MocapPacketC2S.Client client) {
        client.respond(new MocapPacketS2C(0, null));
    }

    public static void sendNocolPlayerAdd(class_3222 serverPlayer, UUID playerToAdd) {
        MocapPacketS2C.send(serverPlayer, 1, playerToAdd);
    }

    public static void sendNocolPlayerRemove(class_3222 serverPlayer, UUID playerToAdd) {
        MocapPacketS2C.send(serverPlayer, 2, playerToAdd);
    }

    public static void sendCustomSkinData(class_3222 player, String name, byte[] byteArray) {
        MocapPacketS2C.send(player, 5, Pair.of((Object)name, (Object)byteArray));
    }

    public static void sendClearCache(class_3222 player) {
        MocapPacketS2C.send(player, 6, null);
    }

    private static void send(class_3222 player, int op, Object object) {
        MocapMod.loaderInterface.sendPacketToClient(player, new MocapPacketS2C(op, object));
    }

    public static interface Server {
        public void respond(MocapPacketC2S var1);
    }
}

