/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create.mixin.energy;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import crazywoddman.warium_create.Config;
import crazywoddman.warium_create.util.WariumCreateTooltipHelper;
import java.util.List;
import net.mcreator.crustychunks.block.entity.EnergyBatteryBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(remap=false, value={EnergyBatteryBlockEntity.class})
public abstract class EnergyBatteryBlockEntityMixin
implements IHaveGoggleInformation {
    @Unique
    private final int energyToFErate;
    @Unique
    private LazyOptional<IEnergyStorage> forgeEnergy;

    public EnergyBatteryBlockEntityMixin() {
        this.energyToFErate = (Integer)Config.SERVER.energyToFErate.get();
        this.forgeEnergy = null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockEntity blockEntity = (BlockEntity)this;
        WariumCreateTooltipHelper.addEnergyTooltip(tooltip, blockEntity, this.energyToFErate);
        return true;
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectForgeEnergy(Capability<?> capability, Direction facing, CallbackInfoReturnable<LazyOptional<?>> cir) {
        if (capability == ForgeCapabilities.ENERGY) {
            if (this.forgeEnergy == null) {
                this.forgeEnergy = LazyOptional.of(this::createEnergyStorage);
            }
            cir.setReturnValue((Object)this.forgeEnergy.cast());
        }
    }

    @Unique
    private IEnergyStorage createEnergyStorage() {
        final BlockEntity blockEntity = (BlockEntity)this;
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int energy = (int)blockEntity.getPersistentData().m_128459_("Energy");
                int capacity = (int)blockEntity.getPersistentData().m_128459_("Capacity");
                if (!simulate && maxReceive > 0 && energy < capacity) {
                    blockEntity.getPersistentData().m_128347_("Energy", (double)Math.min(capacity, energy + maxReceive / EnergyBatteryBlockEntityMixin.this.energyToFErate));
                    blockEntity.m_6596_();
                }
                return Math.min(maxReceive, (capacity - energy) * 100);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int energy = (int)blockEntity.getPersistentData().m_128459_("Energy");
                if (!simulate && maxExtract > 0 && energy > 0) {
                    blockEntity.getPersistentData().m_128347_("Energy", (double)Math.max(0, energy - maxExtract / EnergyBatteryBlockEntityMixin.this.energyToFErate));
                    blockEntity.m_6596_();
                }
                return Math.min(maxExtract, energy * 100);
            }

            public int getEnergyStored() {
                return (int)blockEntity.getPersistentData().m_128459_("Energy") * EnergyBatteryBlockEntityMixin.this.energyToFErate;
            }

            public int getMaxEnergyStored() {
                return (int)blockEntity.getPersistentData().m_128459_("Capacity") * EnergyBatteryBlockEntityMixin.this.energyToFErate;
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return true;
            }
        };
    }
}

