/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create.mixin.energy;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import crazywoddman.warium_create.Config;
import crazywoddman.warium_create.util.WariumCreateTooltipHelper;
import java.util.List;
import net.mcreator.crustychunks.block.entity.GeneratorBlockEntity;
import net.mcreator.crustychunks.block.entity.PowerReactorPortBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(remap=false, value={PowerReactorPortBlockEntity.class, GeneratorBlockEntity.class})
public class GeneratingBlockEntityMixin
implements IHaveGoggleInformation {
    private final LazyOptional<IEnergyStorage> energyStorage = LazyOptional.of(this::getEnergyStorage);
    private final int energyToFErate;

    public GeneratingBlockEntityMixin() {
        this.energyToFErate = (Integer)Config.SERVER.energyToFErate.get();
    }

    private IEnergyStorage getEnergyStorage() {
        final BlockEntity blockEntity = (BlockEntity)this;
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return 0;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int energy = (int)blockEntity.getPersistentData().m_128459_("Energy");
                if (!simulate && maxExtract > 0 && energy > 0) {
                    blockEntity.getPersistentData().m_128347_("Energy", (double)Math.max(0, energy - maxExtract / GeneratingBlockEntityMixin.this.energyToFErate));
                    blockEntity.m_6596_();
                }
                return Math.min(maxExtract, energy * GeneratingBlockEntityMixin.this.energyToFErate);
            }

            public int getEnergyStored() {
                return (int)blockEntity.getPersistentData().m_128459_("Energy") * GeneratingBlockEntityMixin.this.energyToFErate;
            }

            public int getMaxEnergyStored() {
                return (int)blockEntity.getPersistentData().m_128459_("Capacity") * GeneratingBlockEntityMixin.this.energyToFErate;
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return false;
            }
        };
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectEnergyCapability(Capability<?> capability, Direction facing, CallbackInfoReturnable<LazyOptional<?>> cir) {
        if (capability == ForgeCapabilities.ENERGY) {
            cir.setReturnValue((Object)this.energyStorage.cast());
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockEntity blockEntity = (BlockEntity)this;
        if (blockEntity instanceof GeneratorBlockEntity) {
            return false;
        }
        WariumCreateTooltipHelper.addEnergyTooltip(tooltip, blockEntity, this.energyToFErate);
        return true;
    }
}

