/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create.mixin.fluid;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.mcreator.crustychunks.block.entity.BlockMinerBlockEntity;
import net.mcreator.crustychunks.block.entity.OilFireboxBlockEntity;
import net.mcreator.crustychunks.init.CrustyChunksModFluids;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(remap=false, value={OilFireboxBlockEntity.class, BlockMinerBlockEntity.class})
public abstract class OilFireboxAndBlockMinerBlockEntityMixin
implements IHaveGoggleInformation {
    @Unique
    private FluidTank fluidTank;
    @Unique
    private final LazyOptional<IFluidHandler> lazyFluid = LazyOptional.of(() -> this.getOrCreateFluidTank());

    @Unique
    private FluidTank getOrCreateFluidTank() {
        if (this.fluidTank == null) {
            final BlockEntity blockEntity = (BlockEntity)this;
            this.fluidTank = new FluidTank(5000){

                public int fill(FluidStack fluidStack, IFluidHandler.FluidAction action) {
                    if (!fluidStack.isEmpty()) {
                        Fluid fluid = fluidStack.getFluid();
                        String fuelName = blockEntity instanceof OilFireboxBlockEntity ? "kerosene" : "diesel";
                        boolean isAcceptableId = ForgeRegistries.FLUIDS.getKey((Object)fluid).m_135815_().equals(fuelName);
                        boolean isAcceptableTag = ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)fuelName))).contains((Object)fluid);
                        if (isAcceptableId || isAcceptableTag) {
                            int amount = blockEntity.getPersistentData().m_128451_("Fuel");
                            int capacity = this.getCapacity();
                            int toAdd = fluidStack.getAmount();
                            if (action != IFluidHandler.FluidAction.SIMULATE && toAdd > 0 && amount < capacity) {
                                blockEntity.getPersistentData().m_128347_("Fuel", (double)Math.min(capacity, amount + toAdd));
                                blockEntity.m_6596_();
                                blockEntity.m_58904_().m_7260_(blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity.m_58900_(), 3);
                                OilFireboxAndBlockMinerBlockEntityMixin.this.syncFromPersistent();
                                return Math.min(toAdd, capacity - amount);
                            }
                        }
                    }
                    return 0;
                }

                public FluidStack drain(FluidStack fluidstack, IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }

                public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }
            };
        }
        return this.fluidTank;
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectFluidCap(Capability<?> cap, Direction side, CallbackInfoReturnable<LazyOptional<Object>> cir) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            this.syncFromPersistent();
            cir.setReturnValue((Object)this.lazyFluid.cast());
        }
    }

    @Unique
    private void syncFromPersistent() {
        BlockEntity blockEntity = (BlockEntity)this;
        int amount = blockEntity.getPersistentData().m_128451_("Fuel");
        FluidStack stack = FluidStack.EMPTY;
        if (amount > 0) {
            stack = new FluidStack(blockEntity instanceof OilFireboxBlockEntity ? (Fluid)CrustyChunksModFluids.KEROSENE.get() : (Fluid)CrustyChunksModFluids.DIESEL.get(), amount);
        }
        this.getOrCreateFluidTank().setFluid(stack);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        this.syncFromPersistent();
        return ((IHaveGoggleInformation)this).containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(this::getOrCreateFluidTank));
    }
}

