/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create.recipe;

import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import crazywoddman.warium_create.recipe.ColoringRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

@Mod.EventBusSubscriber(modid="warium_create", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ColoringRecipeRegistry {
    public static final List<ColoringRecipe> cachedRecipes = new ArrayList<ColoringRecipe>();
    private static final boolean supplementariesLoaded = ModList.get().isLoaded("supplementaries");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerStarted(ServerStartedEvent event) {
        ColoringRecipeRegistry.updateCacheAndGenerateRecipes(event.getServer());
    }

    public static void updateCacheAndGenerateRecipes(MinecraftServer server) {
        RecipeManager recipeManager = server.m_129894_();
        cachedRecipes.clear();
        for (Recipe recipe : recipeManager.m_44051_()) {
            if (!(recipe instanceof ColoringRecipe)) continue;
            ColoringRecipe coloringRecipe = (ColoringRecipe)recipe;
            cachedRecipes.add(coloringRecipe);
        }
        if (cachedRecipes.isEmpty()) {
            return;
        }
        Collection existingRecipes = recipeManager.m_44051_();
        ArrayList allRecipes = new ArrayList(existingRecipes);
        int recipesAdded = 0;
        for (ColoringRecipe template : cachedRecipes) {
            ResourceLocation soapRecipeId = ResourceLocation.fromNamespaceAndPath((String)template.m_6423_().m_135827_(), (String)(template.m_6423_().m_135815_() + "_cleaning"));
            Recipe<?> soapRecipe = ColoringRecipeRegistry.createSoapCleanRecipe(soapRecipeId, template);
            if (soapRecipe != null) {
                allRecipes.add(soapRecipe);
                ++recipesAdded;
            }
            for (DyeColor color : DyeColor.values()) {
                ResourceLocation deployingRecipeId;
                Recipe<?> deployingRecipe;
                ResourceLocation mixingRecipeId;
                Recipe<?> mixingRecipe;
                if (!template.getFluidIngredients().isEmpty() && (mixingRecipe = ColoringRecipeRegistry.createMixingRecipe(mixingRecipeId = ResourceLocation.fromNamespaceAndPath((String)template.m_6423_().m_135827_(), (String)(template.m_6423_().m_135815_() + "_" + color.m_41065_() + "_mixing")), template, color)) != null) {
                    allRecipes.add(mixingRecipe);
                    ++recipesAdded;
                }
                if (template.getItemIngredientPatterns().isEmpty() || (deployingRecipe = ColoringRecipeRegistry.createDeployingRecipe(deployingRecipeId = ResourceLocation.fromNamespaceAndPath((String)template.m_6423_().m_135827_(), (String)(template.m_6423_().m_135815_() + "_" + color.m_41065_() + "_deploying")), template, color)) == null) continue;
                allRecipes.add(deployingRecipe);
                ++recipesAdded;
            }
        }
        if (recipesAdded > 0) {
            recipeManager.m_44024_(allRecipes);
            System.out.println("Generated " + recipesAdded + " mixing/deploying recipes from " + cachedRecipes.size() + " ColoringRecipes");
            if (supplementariesLoaded) {
                System.out.println("Supplementaries detected - crafting recipes with soap included");
            }
        }
    }

    private static Recipe<?> createMixingRecipe(ResourceLocation recipeId, ColoringRecipe template, DyeColor color) {
        try {
            String colorName = color.m_41065_();
            ResourceLocation outputLocation = ResourceLocation.parse((String)template.getResultItem().replace("{color}", colorName));
            if (!ForgeRegistries.ITEMS.containsKey(outputLocation)) {
                return null;
            }
            Ingredient baseIngredient = ColoringRecipeRegistry.createIngredientExcludingColor(template.getBaseIngredientPattern(), color);
            if (baseIngredient.m_43947_()) {
                return null;
            }
            FluidStack fluidStack = FluidStack.EMPTY;
            for (ColoringRecipe.FluidIngredient fluidIngredient : template.getFluidIngredients()) {
                fluidStack = fluidIngredient.createFluidStack(colorName);
                if (!fluidStack.isEmpty()) continue;
                return null;
            }
            return new ProcessingRecipeBuilder(MixingRecipe::new, recipeId).withItemIngredients(new Ingredient[]{baseIngredient}).withFluidIngredients(new FluidIngredient[]{FluidIngredient.fromFluidStack((FluidStack)fluidStack)}).output(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(outputLocation))).duration(100).build();
        }
        catch (Exception e) {
            System.err.println("Failed to create mixing recipe " + String.valueOf(recipeId) + ": " + e.getMessage());
            return null;
        }
    }

    private static Recipe<?> createDeployingRecipe(ResourceLocation recipeId, ColoringRecipe template, DyeColor color) {
        try {
            String colorName = color.m_41065_();
            ResourceLocation outputLocation = ResourceLocation.parse((String)template.getResultItem().replace("{color}", colorName));
            if (!ForgeRegistries.ITEMS.containsKey(outputLocation)) {
                return null;
            }
            Ingredient baseIngredient = ColoringRecipeRegistry.createIngredientExcludingColor(template.getBaseIngredientPattern(), color);
            if (baseIngredient.m_43947_()) {
                return null;
            }
            Ingredient toolIngredient = ColoringRecipeRegistry.createIngredientFromPattern(template.getItemIngredientPatterns().get(0), colorName);
            if (toolIngredient.m_43947_()) {
                return null;
            }
            return new ProcessingRecipeBuilder(DeployerApplicationRecipe::new, recipeId).withItemIngredients(new Ingredient[]{baseIngredient, toolIngredient}).output(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(outputLocation))).build();
        }
        catch (Exception e) {
            System.err.println("Failed to create deploying recipe " + String.valueOf(recipeId) + ": " + e.getMessage());
            return null;
        }
    }

    private static Ingredient createIngredientFromPattern(String pattern, String color) {
        if (pattern == null || pattern.isEmpty()) {
            return Ingredient.f_43901_;
        }
        String processedPattern = pattern.replace("{color}", color);
        try {
            if (processedPattern.startsWith("#")) {
                String tagName = processedPattern.substring(1);
                ResourceLocation tagLocation = ResourceLocation.parse((String)tagName);
                return Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(ItemTags.create((ResourceLocation)tagLocation))));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)processedPattern);
            if (ForgeRegistries.ITEMS.containsKey(itemLocation)) {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemLocation))});
            }
        }
        catch (Exception e) {
            System.err.println("Failed to create ingredient from pattern: " + pattern + " with color: " + color);
        }
        return Ingredient.f_43901_;
    }

    private static Ingredient createIngredientExcludingColor(String pattern, DyeColor excludeColor) {
        if (pattern == null || pattern.isEmpty()) {
            return Ingredient.f_43901_;
        }
        try {
            if (pattern.startsWith("#")) {
                Ingredient tagIngredient = Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)pattern.substring(1))))));
                ArrayList<ItemStack> validItems = new ArrayList<ItemStack>();
                for (ItemStack stack : tagIngredient.m_43908_()) {
                    String itemPath = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
                    if (itemPath.contains(excludeColor.m_41065_())) continue;
                    validItems.add(stack);
                }
                if (validItems.isEmpty()) {
                    return tagIngredient;
                }
                return Ingredient.m_43927_((ItemStack[])validItems.toArray(new ItemStack[0]));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)pattern);
            if (ForgeRegistries.ITEMS.containsKey(itemLocation)) {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemLocation))});
            }
        }
        catch (Exception e) {
            System.err.println("Failed to create ingredient excluding color from pattern: " + pattern);
        }
        return Ingredient.f_43901_;
    }

    private static Recipe<?> createSoapCleanRecipe(ResourceLocation recipeId, ColoringRecipe template) {
        if (!supplementariesLoaded) {
            return null;
        }
        try {
            String basePattern = template.getBaseIngredientPattern();
            if (!basePattern.startsWith("#")) {
                return null;
            }
            ResourceLocation tagLocation = ResourceLocation.parse((String)basePattern.substring(1));
            ITag items = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)tagLocation));
            if (items.isEmpty()) {
                return null;
            }
            Item result = (Item)items.iterator().next();
            ArrayList<ItemStack> validIngredients = new ArrayList<ItemStack>();
            for (Item item : items) {
                if (item == result) continue;
                validIngredients.add(new ItemStack((ItemLike)item));
            }
            if (validIngredients.isEmpty()) {
                return null;
            }
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ingredients.add(Ingredient.m_43927_((ItemStack[])validIngredients.toArray(new ItemStack[0])));
            ResourceLocation soapLocation = ResourceLocation.fromNamespaceAndPath((String)"supplementaries", (String)"soap");
            if (!ForgeRegistries.ITEMS.containsKey(soapLocation)) {
                return null;
            }
            ingredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(soapLocation))}));
            return new ShapelessRecipe(recipeId, "misc", CraftingBookCategory.MISC, new ItemStack((ItemLike)result), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients.toArray(new Ingredient[0])));
        }
        catch (Exception e) {
            System.err.println("Failed to create soap cleaning recipe " + String.valueOf(recipeId) + ": " + e.getMessage());
            return null;
        }
    }

    public static List<String> getPatternsForSoapBlacklist() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (ColoringRecipe recipe : cachedRecipes) {
            String resultItem = recipe.getResultItem();
            if (resultItem.isEmpty()) continue;
            String pattern = resultItem.replace("_{color}_", "").replace("_{color}", "").replace("{color}_", "").replace("{color}", "");
            patterns.add(pattern);
        }
        return patterns;
    }

    public static List<ColoringRecipe> getCachedRecipes() {
        return cachedRecipes;
    }
}

