/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create.mixin.fluid;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BucketItem.class})
public abstract class BucketItemMixin {
    @Inject(method={"initCapabilities"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void addFluidHandler(final ItemStack stack, CompoundTag nbt, CallbackInfoReturnable<ICapabilityProvider> cir) {
        ResourceLocation key;
        String regName = "";
        if (stack != null && stack.m_41720_() != null && (key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) != null) {
            regName = key.m_135827_();
        }
        if (regName.equals("crusty_chunks")) {
            cir.setReturnValue((Object)new ICapabilityProvider(){
                private final LazyOptional<IFluidHandlerItem> handler = LazyOptional.of(() -> new FluidBucketWrapper(stack));

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                    if (cap == ForgeCapabilities.FLUID_HANDLER_ITEM) {
                        return this.handler.cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }
}

