/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create.mixin.fluid;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.mcreator.crustychunks.block.entity.EngineCyllinderBlockEntity;
import net.mcreator.crustychunks.block.entity.JetTurbineBlockEntity;
import net.mcreator.crustychunks.block.entity.LightCombustionEngineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightCombustionEngineBlockEntity.class, EngineCyllinderBlockEntity.class, JetTurbineBlockEntity.class}, remap=false)
public class EnginesBlockEntityMixin
implements IHaveGoggleInformation {
    @Shadow(remap=false)
    private FluidTank fluidTank;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void acceptAnyDiesel(BlockPos pos, BlockState state, CallbackInfo ci) {
        this.fluidTank.setValidator(this::allowedFluid);
    }

    @Unique
    private boolean allowedFluid(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return false;
        }
        BlockEntity self = (BlockEntity)this;
        String fuelType = "";
        if (self.getPersistentData().m_128441_("FuelType")) {
            fuelType = self.getPersistentData().m_128461_("FuelType").toLowerCase();
        }
        if (fuelType.isEmpty()) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        boolean isAcceptableId = ForgeRegistries.FLUIDS.getKey((Object)fluid).m_135815_().equals(fuelType);
        boolean isAcceptableTag = ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)fuelType))).contains((Object)fluid);
        return isAcceptableId || isAcceptableTag;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return ((IHaveGoggleInformation)this).containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(() -> this.fluidTank));
    }
}

