/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create.mixin.fluid;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.mcreator.crustychunks.block.entity.FuelTankBlockEntity;
import net.mcreator.crustychunks.block.entity.FuelTankInputBlockEntity;
import net.mcreator.crustychunks.block.entity.FuelTankModuleBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FuelTankBlockEntity.class, FuelTankModuleBlockEntity.class, FuelTankInputBlockEntity.class}, remap=false)
public abstract class FuelTanksBlockEntityMixin
implements IHaveGoggleInformation {
    @Shadow(remap=false)
    private FluidTank fluidTank;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void acceptAnyFuel(BlockPos position, BlockState state, CallbackInfo callback) {
        this.fluidTank.setValidator(this::isAllowedFluid);
    }

    @Unique
    private boolean isAllowedFluid(FluidStack fluidStack) {
        boolean isAcceptable;
        if (fluidStack.isEmpty()) {
            return false;
        }
        BlockEntity self = (BlockEntity)this;
        String fluidPath = ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid()).m_135815_();
        Fluid fluid = fluidStack.getFluid();
        String fuelType = "";
        if (fluidPath.equals("kerosene") || ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"kerosene"))).contains((Object)fluid)) {
            fuelType = "Kerosene";
        } else if (fluidPath.equals("diesel") || ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"diesel"))).contains((Object)fluid)) {
            fuelType = "Diesel";
        } else if (fluidPath.equals("oil") || ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"heavy_oil"))).contains((Object)fluid)) {
            fuelType = "Oil";
        } else if (fluidPath.equals("petrolium") || fluidPath.equals("gasoline") || ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"gasoline"))).contains((Object)fluid)) {
            fuelType = "Petrolium";
        }
        boolean bl = isAcceptable = !fuelType.isEmpty();
        if (isAcceptable) {
            self.getPersistentData().m_128359_("FuelType", fuelType);
        }
        return isAcceptable;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return ((IHaveGoggleInformation)this).containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(() -> this.fluidTank));
    }
}

