/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_create.mixin.fluid;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.mcreator.crustychunks.block.entity.RefineryTowerBlockEntity;
import net.mcreator.crustychunks.init.CrustyChunksModFluids;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(remap=false, value={RefineryTowerBlockEntity.class})
public abstract class RefineryTowerBlockEntityMixin
implements IHaveGoggleInformation {
    @Unique
    private FluidTank fluidTank;
    @Unique
    private final LazyOptional<IFluidHandler> lazyFluid = LazyOptional.of(() -> this.getOrCreateFluidTank());

    @Unique
    private FluidTank getOrCreateFluidTank() {
        if (this.fluidTank == null) {
            final RefineryTowerBlockEntity blockEntity = (RefineryTowerBlockEntity)this;
            this.fluidTank = new FluidTank(16000){

                public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                    return 0;
                }

                public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                    RefineryTowerBlockEntityMixin.this.syncFromPersistent();
                    return super.drain(resource, action);
                }

                public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                    RefineryTowerBlockEntityMixin.this.syncFromPersistent();
                    return super.drain(maxDrain, action);
                }

                protected void onContentsChanged() {
                    String fluidName = RefineryTowerBlockEntityMixin.this.getFluidName(this.getFluid());
                    if (!fluidName.isEmpty()) {
                        blockEntity.getPersistentData().m_128359_("Fluid", fluidName);
                    }
                    blockEntity.getPersistentData().m_128347_("Level", (double)this.getFluidAmount());
                    blockEntity.m_6596_();
                }
            };
        }
        return this.fluidTank;
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectFluidCap(Capability<?> cap, Direction side, CallbackInfoReturnable<LazyOptional<Object>> cir) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            this.syncFromPersistent();
            cir.setReturnValue((Object)this.lazyFluid.cast());
        }
    }

    @Unique
    private void syncFromPersistent() {
        RefineryTowerBlockEntity blockEntity = (RefineryTowerBlockEntity)this;
        double level = blockEntity.getPersistentData().m_128459_("Level");
        String fluid = blockEntity.getPersistentData().m_128461_("Fluid");
        FluidStack stack = FluidStack.EMPTY;
        if (fluid.equals("Diesel")) {
            stack = new FluidStack((Fluid)CrustyChunksModFluids.DIESEL.get(), (int)level);
        } else if (fluid.equals("Kerosene")) {
            stack = new FluidStack((Fluid)CrustyChunksModFluids.KEROSENE.get(), (int)level);
        } else if (fluid.equals("Oil")) {
            stack = new FluidStack((Fluid)CrustyChunksModFluids.OIL.get(), (int)level);
        } else if (fluid.equals("Petrolium")) {
            stack = new FluidStack((Fluid)CrustyChunksModFluids.PETROLIUM.get(), (int)level);
        }
        this.getOrCreateFluidTank().setFluid(stack);
    }

    @Unique
    private String getFluidName(FluidStack stack) {
        if (stack.getFluid() == CrustyChunksModFluids.DIESEL.get()) {
            return "Diesel";
        }
        if (stack.getFluid() == CrustyChunksModFluids.KEROSENE.get()) {
            return "Kerosene";
        }
        if (stack.getFluid() == CrustyChunksModFluids.OIL.get()) {
            return "Oil";
        }
        if (stack.getFluid() == CrustyChunksModFluids.PETROLIUM.get()) {
            return "Petrolium";
        }
        return "";
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        this.syncFromPersistent();
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(this::getOrCreateFluidTank));
    }
}

